/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.SimpleMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLookupMap<V>
implements SimpleMap<V> {
    private final boolean isCaseSensitive;
    private TreeMap<String, V> specificMap;
    private TreeMap<String, V> prefixMap;
    private V rootPrefixValue;

    public StringLookupMap() {
        this(true);
    }

    public StringLookupMap(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public int size() {
        return (this.rootPrefixValue == null ? 0 : 1) + (this.specificMap == null ? 0 : this.specificMap.size()) + (this.prefixMap == null ? 0 : this.prefixMap.size());
    }

    protected static void assertValidKey(String key) throws NullPointerException, IllegalArgumentException {
        if (key == null) {
            throw new NullPointerException("A null key is not permitted");
        }
        if (key.length() <= 0) {
            throw new IllegalArgumentException("Illegal key [" + key + "]: must be a minimum length of 1");
        }
    }

    protected static void assertValidGetKey(String key) throws NullPointerException, IllegalArgumentException {
        StringLookupMap.assertValidKey(key);
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char c = key.charAt(i);
            if (c != '*') continue;
            throw new IllegalArgumentException("Illegal key [" + key + "]: unsupported char [" + c + "] at index [" + i + "]");
        }
    }

    protected static void assertValidPutKey(String key) throws NullPointerException, IllegalArgumentException {
        StringLookupMap.assertValidKey(key);
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char c = key.charAt(i);
            if (c != '*' || i + 1 == len) continue;
            throw new IllegalArgumentException("Illegal key [" + key + "]: [*] can only be the last char in key");
        }
    }

    public String toCorrectKeyCaseSensitivity(String key) {
        if (this.isCaseSensitive) {
            return key;
        }
        return key.toLowerCase();
    }

    @Override
    public V get(String key) throws IllegalArgumentException {
        Map.Entry<String, V> entry;
        V specificValue;
        StringLookupMap.assertValidGetKey(key);
        key = this.toCorrectKeyCaseSensitivity(key);
        if (this.specificMap != null && (specificValue = this.specificMap.get(key)) != null) {
            return specificValue;
        }
        if (this.prefixMap != null && (entry = this.prefixMap.floorEntry(key)) != null && key.startsWith(entry.getKey()) && key.length() > entry.getKey().length()) {
            return entry.getValue();
        }
        if (this.rootPrefixValue != null) {
            return this.rootPrefixValue;
        }
        return null;
    }

    @Override
    public V put(String key, V value) throws IllegalArgumentException {
        StringLookupMap.assertValidPutKey(key);
        char lastChar = key.charAt(key.length() - 1);
        if (lastChar != '*') {
            if (this.specificMap == null) {
                this.specificMap = new TreeMap();
            }
            return this.specificMap.put(this.toCorrectKeyCaseSensitivity(key), value);
        }
        if (key.equals("*")) {
            V previousValue = this.rootPrefixValue;
            this.rootPrefixValue = value;
            return previousValue;
        }
        key = key.substring(0, key.length() - 1);
        if (this.prefixMap == null) {
            this.prefixMap = new TreeMap();
        }
        return this.prefixMap.put(this.toCorrectKeyCaseSensitivity(key), value);
    }
}

