/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.LoadBalancedList;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinLoadBalancedList<E>
implements LoadBalancedList<E> {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobinLoadBalancedList.class);
    private final ArrayList<LoadBalancedList.Node<E>> allItems = new ArrayList();
    private final ArrayList<LoadBalancedList.Node<E>> remainingItems = new ArrayList();
    private int currentIndex = 0;

    @Override
    public List<LoadBalancedList.Node<E>> getValues() {
        return this.allItems;
    }

    @Override
    public void clear() {
        this.allItems.clear();
        this.remainingItems.clear();
        this.currentIndex = 0;
    }

    @Override
    public boolean contains(E item) {
        LoadBalancedList.Node<E> newNode = new LoadBalancedList.Node<E>(item);
        return this.allItems.contains(newNode);
    }

    @Override
    public void set(E item, int weight) {
        if (weight <= 0) {
            this.remove(item);
            return;
        }
        LoadBalancedList.Node<E> newNode = new LoadBalancedList.Node<E>(item, weight);
        int i = this.allItems.indexOf(newNode);
        if (i < 0) {
            this.allItems.add(newNode);
            this.remainingItems.add(newNode);
        } else {
            LoadBalancedList.Node<E> currentNode = this.allItems.get(i);
            currentNode.setWeight(weight);
            if (currentNode.getCount() >= currentNode.getWeight()) {
                currentNode.setCount(0);
                this.remainingItems.remove(currentNode);
                if (this.remainingItems.isEmpty() && this.allItems.size() > 0) {
                    this.rebuildRemainingItems();
                }
            }
        }
    }

    @Override
    public void remove(E item) {
        LoadBalancedList.Node<E> newNode = new LoadBalancedList.Node<E>(item);
        int i = this.allItems.indexOf(newNode);
        if (i >= 0) {
            this.allItems.remove(i);
            this.remainingItems.remove(newNode);
        }
        if (this.remainingItems.isEmpty() && this.allItems.size() > 0) {
            this.rebuildRemainingItems();
        }
    }

    protected void rebuildRemainingItems() {
        this.remainingItems.clear();
        for (LoadBalancedList.Node<E> node : this.allItems) {
            if (node.getWeight() <= node.getCount()) continue;
            this.remainingItems.add(node);
        }
    }

    protected void resetCountsAndRebuildRemainingItems() {
        for (LoadBalancedList.Node<E> node : this.allItems) {
            node.setCount(0);
        }
        this.rebuildRemainingItems();
    }

    @Override
    public int getSize() {
        return this.allItems.size();
    }

    public int getRemainingSize() {
        return this.remainingItems.size();
    }

    @Override
    public E getNext() {
        if (this.allItems.isEmpty()) {
            return null;
        }
        if (this.remainingItems.isEmpty()) {
            logger.error("Impossible bug occurred with RoundRobinLoadBalancedList where allItems > 0, but remainingItems == 0, going to completely internally rebuild everything");
            this.resetCountsAndRebuildRemainingItems();
        }
        if (this.currentIndex >= this.remainingItems.size()) {
            this.currentIndex = 0;
        }
        LoadBalancedList.Node<E> node = this.remainingItems.get(this.currentIndex);
        node.incrementCount();
        if (node.getCount() >= node.getWeight()) {
            node.setCount(0);
            this.remainingItems.remove(this.currentIndex);
        } else {
            ++this.currentIndex;
        }
        if (this.remainingItems.isEmpty()) {
            this.rebuildRemainingItems();
        }
        if (this.currentIndex >= this.remainingItems.size()) {
            this.currentIndex = 0;
        }
        return node.getValue();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(200);
        buf.append("curIdx=");
        buf.append(this.currentIndex);
        buf.append(" [");
        int i = 0;
        for (LoadBalancedList.Node<E> node : this.remainingItems) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(node);
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }
}

