/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.LoadBalancedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancedLists {
    public static <E> LoadBalancedList<E> synchronizedList(LoadBalancedList<E> list) {
        return new ConcurrentLoadBalancedList<E>(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConcurrentLoadBalancedList<E>
    implements LoadBalancedList<E> {
        private final LoadBalancedList<E> list;
        private final ReentrantLock lock;

        protected ConcurrentLoadBalancedList(LoadBalancedList<E> list) {
            this.list = list;
            this.lock = new ReentrantLock();
        }

        @Override
        public List<LoadBalancedList.Node<E>> getValues() {
            return this.list.getValues();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            this.lock.lock();
            try {
                this.list.clear();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(E item) {
            this.lock.lock();
            try {
                boolean bl = this.list.contains(item);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E getNext() {
            this.lock.lock();
            try {
                E e = this.list.getNext();
                return e;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getSize() {
            this.lock.lock();
            try {
                int n = this.list.getSize();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(E item) {
            this.lock.lock();
            try {
                this.list.remove(item);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E item, int weight) {
            this.lock.lock();
            try {
                this.list.set(item, weight);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

