/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.charset;

import com.cloudhopper.commons.charset.UCS2Charset;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class UCS2LECharset
extends UCS2Charset {
    public byte[] encode(CharSequence str0) {
        return this.getLittleEndianBytes(super.encode(str0));
    }

    public void decode(byte[] bytes, StringBuilder buffer) {
        super.decode(this.getLittleEndianBytes(bytes), buffer);
    }

    public String decode(byte[] bytes) {
        return super.decode(this.getLittleEndianBytes(bytes));
    }

    private byte[] getLittleEndianBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteBuffer sourceByteBuffer = ByteBuffer.wrap(bytes);
        ByteBuffer destByteBuffer = ByteBuffer.allocate(bytes.length);
        destByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        while (sourceByteBuffer.hasRemaining()) {
            destByteBuffer.putShort(sourceByteBuffer.getShort());
        }
        return destByteBuffer.array();
    }
}

