/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.charset;

import com.cloudhopper.commons.charset.GSMCharset;
import com.cloudhopper.commons.util.FastByteArrayOutputStream;
import java.io.IOException;

public class TMobileNlGSMCharset
extends GSMCharset {
    static final int TMO_EURO_BYTE = 128;
    static final char EURO_MARK = '\u20ac';

    public static boolean canRepresent(CharSequence str0) {
        if (str0 == null) {
            return true;
        }
        int len = str0.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = str0.charAt(i);
            if (c >= ' ' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            switch (c) {
                case '\n': 
                case '\r': 
                case '_': 
                case '\u00a1': 
                case '\u00a3': 
                case '\u00a4': 
                case '\u00a5': 
                case '\u00a7': 
                case '\u00bf': 
                case '\u00c4': 
                case '\u00c5': 
                case '\u00c6': 
                case '\u00c7': 
                case '\u00c9': 
                case '\u00d1': 
                case '\u00d6': 
                case '\u00d8': 
                case '\u00dc': 
                case '\u00df': 
                case '\u00e0': 
                case '\u00e4': 
                case '\u00e5': 
                case '\u00e6': 
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ec': 
                case '\u00f1': 
                case '\u00f2': 
                case '\u00f6': 
                case '\u00f8': 
                case '\u00f9': 
                case '\u00fc': 
                case '\u0393': 
                case '\u0394': 
                case '\u0398': 
                case '\u039b': 
                case '\u039e': 
                case '\u03a0': 
                case '\u03a3': 
                case '\u03a6': 
                case '\u03a8': 
                case '\u03a9': 
                case '\u20ac': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public byte[] encode(CharSequence str0) {
        if (str0 == null) {
            return null;
        }
        int estimatedByteLength = str0.length();
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream(estimatedByteLength);
        try {
            int len = str0.length();
            for (int i = 0; i < len; ++i) {
                int search;
                char c = str0.charAt(i);
                if (c == '\u20ac') {
                    baos.write(128);
                    continue;
                }
                for (search = 0; search < CHAR_TABLE.length; ++search) {
                    if (search == 27 || c != CHAR_TABLE[search]) continue;
                    baos.write(search);
                    break;
                }
                if (search != CHAR_TABLE.length) continue;
                baos.write(63);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible error with FastByteArrayOutputStream: " + e.getMessage(), e);
        }
        return baos.toByteArray();
    }

    public void decode(byte[] bytes, StringBuilder buffer) {
        if (bytes == null) {
            return;
        }
        char[] table = CHAR_TABLE;
        for (int i = 0; i < bytes.length; ++i) {
            int code = bytes[i] & 0xFF;
            if (code == 128) {
                buffer.append('\u20ac');
                continue;
            }
            buffer.append(code >= table.length ? (char)'?' : table[code]);
        }
    }
}

