/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift.tree;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.reploop.parser.thrift.AstVisitor;
import org.reploop.parser.thrift.Node;
import org.reploop.parser.thrift.tree.Entity;
import org.reploop.parser.thrift.tree.Header;

public class ThriftProgram
extends Node {
    Path file;
    List<String> comments;
    List<Header> headers;
    List<Entity> entities;

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitProgram(this, context);
    }

    public Path getFile() {
        return this.file;
    }

    public void setFile(Path file) {
        this.file = file;
    }

    public ThriftProgram(List<Header> headers, List<Entity> entities) {
        this(Collections.emptyList(), headers, entities);
    }

    public ThriftProgram(List<String> comments, List<Header> headers, List<Entity> entities) {
        this.file = this.file;
        this.comments = comments;
        this.headers = headers;
        this.entities = entities;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftProgram that = (ThriftProgram)o;
        return Objects.equals(this.file, that.file) && Objects.equals(this.headers, that.headers) && Objects.equals(this.entities, that.entities);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.file, this.headers, this.entities);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("entities", this.entities).append("file", (Object)this.file).append("headers", this.headers).toString();
    }
}

