/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift.tree;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.reploop.parser.QualifiedName;
import org.reploop.parser.thrift.AstVisitor;
import org.reploop.parser.thrift.tree.Entity;
import org.reploop.parser.thrift.tree.Function;

public class Service
extends Entity {
    Optional<QualifiedName> parent;
    List<Function> functions;

    public Service(QualifiedName name, List<String> comments, List<Function> functions) {
        this(Optional.empty(), name, comments, functions);
    }

    public Service(String name, List<String> comments, List<Function> functions) {
        this(Optional.empty(), name, comments, functions);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitService(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        return Objects.equals(this.getName(), service.getName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public Service(Optional<QualifiedName> parent, String name, List<Function> functions) {
        this(parent, QualifiedName.of((String)name), Collections.emptyList(), functions);
    }

    public Service(Optional<QualifiedName> parent, String name, List<String> comments, List<Function> functions) {
        this(parent, QualifiedName.of((String)name), comments, functions);
    }

    public Service(Optional<QualifiedName> parent, QualifiedName name, List<String> comments, List<Function> functions) {
        super(name, comments);
        this.parent = parent;
        this.functions = functions;
    }

    public Optional<QualifiedName> getParent() {
        return this.parent;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    @Override
    public String toString() {
        String sb = "Service{" + super.toString() + "parent=" + this.parent + ", functions=" + this.functions + "}";
        return sb;
    }
}

