/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift.tree;

import java.util.List;
import java.util.Optional;
import org.reploop.parser.QualifiedName;
import org.reploop.parser.thrift.AstVisitor;
import org.reploop.parser.thrift.Node;
import org.reploop.parser.thrift.tree.Value;
import org.reploop.parser.thrift.type.FieldType;

public class Field
extends Node {
    Integer filedId;
    boolean required;
    List<String> comments;
    QualifiedName name;
    FieldType fieldType;
    Optional<Value> value;

    public Field(List<String> comments, FieldType fieldType, Integer filedId, String name, boolean required) {
        this(comments, fieldType, filedId, QualifiedName.of((String)name), required);
    }

    public Field(List<String> comments, FieldType fieldType, Integer filedId, String name, boolean required, Optional<Value> value) {
        this(comments, fieldType, filedId, QualifiedName.of((String)name), required, value);
    }

    public Field(List<String> comments, FieldType fieldType, Integer filedId, QualifiedName name, boolean required) {
        this(comments, fieldType, filedId, name, required, Optional.empty());
    }

    public Field(List<String> comments, FieldType fieldType, Integer filedId, QualifiedName name, boolean required, Optional<Value> value) {
        this.comments = comments;
        this.fieldType = fieldType;
        this.filedId = filedId;
        this.name = name;
        this.required = required;
        this.value = value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitField(this, context);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public Integer getFiledId() {
        return this.filedId;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Optional<Value> getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return false;
    }

    @Override
    public String toString() {
        String sb = "Field{filedId=" + this.filedId + ", required=" + this.required + ", comments=" + this.comments + ", name='" + this.name + "', fieldType=" + this.fieldType + "}";
        return sb;
    }
}

