/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift.generator;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.reploop.parser.thrift.tree.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorContext
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorContext.class);
    private int indent;
    private final Map<Service, StringBuilder> services;
    public static final int DEFAULT_INDENT = 4;
    public static GeneratorContext ZERO_INDENT_CONTEXT = new GeneratorContext(0, Collections.emptyMap());
    public static GeneratorContext ONE_INDENT_CONTEXT = new GeneratorContext(1, Collections.emptyMap());

    public GeneratorContext(int indent, Map<Service, StringBuilder> services) {
        this.indent = indent;
        this.services = services;
    }

    public GeneratorContext(int indent) {
        this(indent, new HashMap<Service, StringBuilder>());
    }

    public GeneratorContext() {
        this(0);
    }

    public int getIndent() {
        return this.indent;
    }

    public Map<Service, StringBuilder> getServices() {
        return this.services;
    }

    public StringBuilder code(Service service) {
        return this.services.computeIfAbsent(service, key -> new StringBuilder());
    }

    public GeneratorContext copyThenIndent() {
        return this.copyThenIndent(4);
    }

    public GeneratorContext copyThenIndent(int indent) {
        GeneratorContext gc = this.copy();
        return gc.indent();
    }

    public GeneratorContext indentThenCopy() {
        return this.indentThenCopy(4);
    }

    public GeneratorContext indentThenCopy(int indent) {
        this.indent(indent);
        return this.copy();
    }

    public GeneratorContext copy() {
        return new GeneratorContext(this.indent, this.services);
    }

    public GeneratorContext indent() {
        return this.indent(4);
    }

    public GeneratorContext indent(int indent) {
        this.indent += indent;
        return this;
    }

    public GeneratorContext dedent() {
        return this.dedent(4);
    }

    public GeneratorContext dedent(int dedent) {
        this.indent -= dedent;
        return this;
    }

    public String toString() {
        return "GeneratorContext{indent=" + this.indent + ", services=" + this.services + "}";
    }
}

