/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.thrift;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.reploop.parser.QualifiedName;
import org.reploop.parser.commons.CommentHelper;
import org.reploop.parser.thrift.Node;
import org.reploop.parser.thrift.base.ThriftBaseBaseVisitor;
import org.reploop.parser.thrift.base.ThriftBaseParser;
import org.reploop.parser.thrift.tree.Entity;
import org.reploop.parser.thrift.tree.Enum;
import org.reploop.parser.thrift.tree.EnumField;
import org.reploop.parser.thrift.tree.Exception;
import org.reploop.parser.thrift.tree.Field;
import org.reploop.parser.thrift.tree.Function;
import org.reploop.parser.thrift.tree.FunctionType;
import org.reploop.parser.thrift.tree.Header;
import org.reploop.parser.thrift.tree.Include;
import org.reploop.parser.thrift.tree.Lang;
import org.reploop.parser.thrift.tree.Namespace;
import org.reploop.parser.thrift.tree.NamespaceScope;
import org.reploop.parser.thrift.tree.PrimitiveType;
import org.reploop.parser.thrift.tree.Raise;
import org.reploop.parser.thrift.tree.Requiredness;
import org.reploop.parser.thrift.tree.ReturnType;
import org.reploop.parser.thrift.tree.Service;
import org.reploop.parser.thrift.tree.Struct;
import org.reploop.parser.thrift.tree.ThriftProgram;
import org.reploop.parser.thrift.tree.VoidType;
import org.reploop.parser.thrift.type.BinaryType;
import org.reploop.parser.thrift.type.BoolType;
import org.reploop.parser.thrift.type.ByteType;
import org.reploop.parser.thrift.type.DoubleType;
import org.reploop.parser.thrift.type.FieldType;
import org.reploop.parser.thrift.type.IntType;
import org.reploop.parser.thrift.type.ListType;
import org.reploop.parser.thrift.type.LongType;
import org.reploop.parser.thrift.type.MapType;
import org.reploop.parser.thrift.type.SetType;
import org.reploop.parser.thrift.type.ShortType;
import org.reploop.parser.thrift.type.StringType;
import org.reploop.parser.thrift.type.StructType;

public class ThriftAstBuilder
extends ThriftBaseBaseVisitor<Node> {
    private CommonTokenStream tokens;
    private BiFunction<Token, Integer, List<Token>> leftComment = new BiFunction<Token, Integer, List<Token>>(){

        @Override
        public List<Token> apply(Token token, Integer channel) {
            if (null != ThriftAstBuilder.this.tokens) {
                return ThriftAstBuilder.this.tokens.getHiddenTokensToLeft(token.getTokenIndex(), channel.intValue());
            }
            return Collections.emptyList();
        }
    };

    public ThriftAstBuilder(CommonTokenStream tokens) {
        this.tokens = tokens;
    }

    private List<String> comments(Token token) {
        return CommentHelper.comments((Token)token, (Integer)1, this.leftComment);
    }

    @Override
    public NamespaceScope visitNamespaceScope(ThriftBaseParser.NamespaceScopeContext ctx) {
        EnumSet<Lang> scopes;
        String lang = ctx.getText();
        if ("*".equals(lang)) {
            scopes = EnumSet.allOf(Lang.class);
        } else {
            Lang l = Lang.valueOf(lang.toUpperCase());
            scopes = EnumSet.of(l);
        }
        return new NamespaceScope(scopes);
    }

    @Override
    public Namespace visitNamespace(ThriftBaseParser.NamespaceContext ctx) {
        NamespaceScope scope = this.visitNamespaceScope(ctx.namespaceScope());
        ctx.ID().getText();
        return new Namespace(scope, ctx.ID().getText());
    }

    @Override
    public Include visitInclude(ThriftBaseParser.IncludeContext ctx) {
        if (null != ctx) {
            return new Include(ctx.LITERAL().getText());
        }
        return null;
    }

    @Override
    public Header visitIncludeDefinition(ThriftBaseParser.IncludeDefinitionContext ctx) {
        return this.visitInclude(ctx.include());
    }

    @Override
    public Header visitNamespaceDefinition(ThriftBaseParser.NamespaceDefinitionContext ctx) {
        return this.visitNamespace(ctx.namespace());
    }

    public Header visitHeader(ThriftBaseParser.HeaderContext ctx) {
        return this.visit(ctx, Header.class);
    }

    @Override
    public Node visitPrimitiveType(ThriftBaseParser.PrimitiveTypeContext ctx) {
        return this.visitPrimitives(ctx.primitives());
    }

    @Override
    public MapType visitMapType(ThriftBaseParser.MapTypeContext ctx) {
        return new MapType(this.visit(ctx.key, FieldType.class), this.visit(ctx.value, FieldType.class));
    }

    @Override
    public VoidType visitVoidType(ThriftBaseParser.VoidTypeContext ctx) {
        return new VoidType();
    }

    @Override
    public FunctionType visitReturnType(ThriftBaseParser.ReturnTypeContext ctx) {
        return new ReturnType(this.visit(ctx.fieldType(), FieldType.class));
    }

    public FunctionType visitFunctionType(ThriftBaseParser.FunctionTypeContext ctx) {
        return this.visit(ctx, FunctionType.class);
    }

    @Override
    public StructType visitStructType(ThriftBaseParser.StructTypeContext ctx) {
        return new StructType(ctx.ID().getText());
    }

    private FieldType visitFieldType(ThriftBaseParser.FieldTypeContext ctx) {
        return (FieldType)this.visit((ParseTree)ctx);
    }

    @Override
    public Exception visitXception(ThriftBaseParser.XceptionContext ctx) {
        return new Exception(ctx.ID().getText(), this.visit(ctx.field(), Field.class));
    }

    @Override
    public FieldType visitPrimitives(ThriftBaseParser.PrimitivesContext ctx) {
        String text = ctx.getText().toUpperCase();
        PrimitiveType type = PrimitiveType.valueOf(text);
        if (null != type) {
            switch (type) {
                case BOOL: {
                    return new BoolType();
                }
                case BYTE: {
                    return new ByteType();
                }
                case I16: {
                    return new ShortType();
                }
                case I32: {
                    return new IntType();
                }
                case I64: {
                    return new LongType();
                }
                case BINARY: {
                    return new BinaryType();
                }
                case STRING: {
                    return new StringType();
                }
                case DOUBLE: {
                    return new DoubleType();
                }
            }
            throw new IllegalArgumentException("Do not support this type " + text + "right now");
        }
        return null;
    }

    @Override
    public ListType visitListType(ThriftBaseParser.ListTypeContext ctx) {
        return new ListType(this.visit(ctx.element, FieldType.class));
    }

    @Override
    public SetType visitSetType(ThriftBaseParser.SetTypeContext ctx) {
        return new SetType(this.visit(ctx.element, FieldType.class));
    }

    @Override
    public Field visitField(ThriftBaseParser.FieldContext ctx) {
        TerminalNode node;
        String name = ctx.ID().getText();
        Integer fieldId = 0;
        ThriftBaseParser.FieldIDContext context = ctx.fieldID();
        if (null != context) {
            fieldId = Integer.valueOf(context.INT().getText());
        }
        boolean required = null != (node = ctx.FieldRequiredness()) && Requiredness.REQUIRED == Requiredness.valueOf(node.getText().toUpperCase());
        return new Field(this.comments(ctx.getStart()), this.visitFieldType(ctx.fieldType()), fieldId, name, required);
    }

    @Override
    public Raise visitRaise(ThriftBaseParser.RaiseContext ctx) {
        if (null != ctx) {
            return new Raise(this.visit(ctx.field(), Field.class));
        }
        return null;
    }

    @Override
    public Function visitFunction(ThriftBaseParser.FunctionContext ctx) {
        List<String> comments = this.comments(ctx.getStart());
        Optional<List<Field>> exceptions = Optional.empty();
        Raise raise = this.visitRaise(ctx.raise());
        if (null != raise) {
            exceptions = Optional.ofNullable(raise.getFields());
        }
        return new Function(comments, null != ctx.ONEWAY(), QualifiedName.of((String)ctx.ID().getText()), this.visitFunctionType(ctx.functionType()), this.visit(ctx.field(), Field.class), exceptions);
    }

    private <R> Optional<R> visitIfPresent(ParserRuleContext context, Class<R> clazz) {
        return Optional.ofNullable(context).map(arg_0 -> ((ThriftAstBuilder)this).visit(arg_0)).filter(Objects::nonNull).map(clazz::cast);
    }

    private <R> R visit(ParserRuleContext context, Class<R> clazz) {
        return clazz.cast(this.visit((ParseTree)context));
    }

    @Override
    public Service visitService(ThriftBaseParser.ServiceContext ctx) {
        List<String> comments = this.comments(ctx.getStart());
        List<Function> functions = this.visit(ctx.function(), Function.class);
        String name = Optional.ofNullable(ctx.ID(0)).map(ParseTree::getText).get();
        Optional<QualifiedName> parent = Optional.ofNullable(ctx.ID(1)).map(ParseTree::getText).map(QualifiedName::of);
        return new Service(parent, QualifiedName.of((String)name), comments, functions);
    }

    @Override
    public Struct visitStructDefinition(ThriftBaseParser.StructDefinitionContext ctx) {
        return this.visitStruct(ctx.struct());
    }

    @Override
    public Exception visitExceptionDefinition(ThriftBaseParser.ExceptionDefinitionContext ctx) {
        return this.visitXception(ctx.xception());
    }

    public Entity visitTypeDefinition(ThriftBaseParser.TypeDefinitionContext ctx) {
        return (Entity)this.visit((ParseTree)ctx);
    }

    @Override
    public Struct visitStruct(ThriftBaseParser.StructContext ctx) {
        List<String> comments = this.comments(ctx.getStart());
        return new Struct(ctx.ID().getText(), comments, this.visit(ctx.field(), Field.class));
    }

    @Override
    public Enum visitEnumeration(ThriftBaseParser.EnumerationContext ctx) {
        return new Enum(ctx.ID().getText(), this.comments(ctx.getStart()), this.visit(ctx.enumDef(), EnumField.class));
    }

    @Override
    public EnumField visitEnumDef(ThriftBaseParser.EnumDefContext ctx) {
        Optional<Integer> index = Optional.empty();
        TerminalNode node = ctx.INT();
        if (null != node) {
            index = Optional.of(Integer.valueOf(node.getText()));
        }
        return new EnumField(ctx.ID().getText(), index, this.comments(ctx.getStart()));
    }

    @Override
    public Entity visitTypeDefinitionDefinition(ThriftBaseParser.TypeDefinitionDefinitionContext ctx) {
        return this.visitTypeDefinition(ctx.typeDefinition());
    }

    @Override
    public Entity visitServiceDefinition(ThriftBaseParser.ServiceDefinitionContext ctx) {
        return this.visitService(ctx.service());
    }

    private <C extends ParserRuleContext, R extends Node> List<R> visit(List<C> contexts, Class<R> clazz) {
        if (null != contexts) {
            return contexts.stream().map(arg_0 -> ((ThriftAstBuilder)this).visit(arg_0)).filter(Objects::nonNull).map(clazz::cast).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public ThriftProgram visitProgram(ThriftBaseParser.ProgramContext ctx) {
        return new ThriftProgram(this.comments(ctx.getStart()), this.visit(ctx.header(), Header.class), this.visit(ctx.definition(), Entity.class));
    }
}

