/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.json.tree;

import java.util.Objects;
import org.reploop.parser.json.AstVisitor;
import org.reploop.parser.json.Node;
import org.reploop.parser.json.tree.Value;

public class Pair
extends Node
implements Comparable<Pair> {
    private final String key;
    private final Value value;

    public Pair(String key, Value value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPair(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.key, pair.key) && Objects.equals(this.value, pair.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    @Override
    public String toString() {
        return this.key + ": " + this.value;
    }

    @Override
    public int compareTo(Pair o) {
        return this.key.compareTo(o.getKey());
    }
}

