/*
 * Decompiled with CFR 0.152.
 */
package org.reploop.parser.json;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.reploop.parser.json.Node;
import org.reploop.parser.json.base.JsonBaseBaseVisitor;
import org.reploop.parser.json.base.JsonBaseParser;
import org.reploop.parser.json.tree.Array;
import org.reploop.parser.json.tree.Bool;
import org.reploop.parser.json.tree.ByteVal;
import org.reploop.parser.json.tree.DoubleVal;
import org.reploop.parser.json.tree.Entity;
import org.reploop.parser.json.tree.FloatVal;
import org.reploop.parser.json.tree.IntVal;
import org.reploop.parser.json.tree.Json;
import org.reploop.parser.json.tree.LongVal;
import org.reploop.parser.json.tree.Null;
import org.reploop.parser.json.tree.Number;
import org.reploop.parser.json.tree.Pair;
import org.reploop.parser.json.tree.ShortVal;
import org.reploop.parser.json.tree.Text;
import org.reploop.parser.json.tree.Value;

public class JsonAstBuilder
extends JsonBaseBaseVisitor<Node> {
    private CommonTokenStream tokens;

    public JsonAstBuilder() {
    }

    public JsonAstBuilder(CommonTokenStream tokens) {
        this.tokens = tokens;
    }

    @Override
    public Json visitJson(JsonBaseParser.JsonContext ctx) {
        Value value = (Value)this.visit((ParseTree)ctx.value());
        return new Json(value);
    }

    @Override
    public Entity visitObj(JsonBaseParser.ObjContext ctx) {
        return new Entity(this.visit(ctx.pair(), Pair.class));
    }

    private String stripQuotationMark(String text) {
        return StringUtils.strip((String)text, (String)"\"");
    }

    private String removeAllWhitespace(String text) {
        return text.replaceAll("\\s+", "");
    }

    @Override
    public Pair visitPair(JsonBaseParser.PairContext ctx) {
        String text = this.removeAllWhitespace(this.stripQuotationMark(ctx.STRING().getText()));
        return new Pair(text, this.visit(ctx.value(), Value.class));
    }

    @Override
    public Array visitArr(JsonBaseParser.ArrContext ctx) {
        return new Array(this.visit(ctx.value(), Value.class));
    }

    @Override
    public Text visitStringValue(JsonBaseParser.StringValueContext ctx) {
        return new Text(this.stripQuotationMark(ctx.STRING().getText()));
    }

    private <D extends Comparable<D>, T, E> Optional<E> castIf(D val, T min, T max, Function<T, D> to, Function<D, E> cast) {
        Comparable minVal = (Comparable)to.apply(min);
        Comparable maxVal = (Comparable)to.apply(max);
        if (val.compareTo((Comparable)minVal) >= 0 && val.compareTo((Comparable)maxVal) <= 0) {
            return Optional.of(cast.apply(val));
        }
        return Optional.empty();
    }

    @Override
    public Number visitNumberValue(JsonBaseParser.NumberValueContext ctx) {
        String val = ctx.NUMBER().getText();
        try {
            return this.toNumber(val);
        }
        catch (NumberFormatException e) {
            try {
                return this.toFloat(val);
            }
            catch (NumberFormatException ex) {
                throw new IllegalStateException(val, e);
            }
        }
    }

    private Number toNumber(String val) {
        Long value = Long.valueOf(val);
        Optional<ByteVal> ob = this.castIf(value, (byte)-128, (byte)127, Byte::longValue, vb -> new ByteVal(vb.byteValue()));
        if (ob.isPresent()) {
            return ob.get();
        }
        Optional<ShortVal> os = this.castIf(value, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, Short::longValue, vs -> new ShortVal(vs.shortValue()));
        if (os.isPresent()) {
            return os.get();
        }
        Optional<IntVal> oi = this.castIf(value, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer::longValue, vi -> new IntVal(vi.intValue()));
        if (oi.isPresent()) {
            return oi.get();
        }
        return new LongVal(value);
    }

    private Number toFloat(String val) {
        double value = Double.parseDouble(val);
        Optional<FloatVal> of = this.castIf(value, (T)Float.valueOf(Float.MIN_VALUE), (T)Float.valueOf(Float.MAX_VALUE), Float::doubleValue, vf -> new FloatVal(vf.floatValue()));
        if (of.isPresent()) {
            return of.get();
        }
        return new DoubleVal(value);
    }

    @Override
    public Entity visitObjValue(JsonBaseParser.ObjValueContext ctx) {
        return this.visitObj(ctx.obj());
    }

    @Override
    public Array visitArrValue(JsonBaseParser.ArrValueContext ctx) {
        return this.visitArr(ctx.arr());
    }

    @Override
    public Bool visitTrueValue(JsonBaseParser.TrueValueContext ctx) {
        return new Bool(Boolean.TRUE);
    }

    @Override
    public Bool visitFalseValue(JsonBaseParser.FalseValueContext ctx) {
        return new Bool(Boolean.FALSE);
    }

    @Override
    public Null visitNullValue(JsonBaseParser.NullValueContext ctx) {
        return new Null();
    }

    private <R> R visit(ParserRuleContext context, Class<R> clazz) {
        return clazz.cast(this.visit((ParseTree)context));
    }

    private <C extends ParserRuleContext, R extends Node> List<R> visit(List<C> contexts, Class<R> clazz) {
        if (null != contexts) {
            return contexts.stream().map(arg_0 -> ((JsonAstBuilder)this).visit(arg_0)).filter(Objects::nonNull).map(clazz::cast).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

