/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.utils;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Utils {
    private static final String JAR_SNAPSHOT_POSTFIX = "-SNAPSHOT";
    private static final String OSGI_SNAPSHOT_POSTFIX = ".SNAPSHOT";
    private static final String ECLIPSE_QUALIFIER_POSTFIX = ".qualifier";
    public static final String TYCHO_VERSION = "1.7.0";

    public static String getTimeStamp() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        return format.format(new Date());
    }

    public static String eclipseQualifierToTimeStamp(String version, String timestamp) {
        String tweakedVersion = version;
        if (version.contains(ECLIPSE_QUALIFIER_POSTFIX)) {
            tweakedVersion = tweakedVersion.replace(ECLIPSE_QUALIFIER_POSTFIX, "." + timestamp);
        }
        return tweakedVersion;
    }

    public static String snapshotToTimestamp(String version, String timestamp) {
        String tweakedVersion = version;
        if (version.contains(JAR_SNAPSHOT_POSTFIX)) {
            tweakedVersion = tweakedVersion.replace(JAR_SNAPSHOT_POSTFIX, "-" + timestamp);
        } else if (version.contains(OSGI_SNAPSHOT_POSTFIX)) {
            tweakedVersion = tweakedVersion.replace(OSGI_SNAPSHOT_POSTFIX, "." + timestamp);
        }
        return tweakedVersion;
    }

    public static String mavenToEclipse(String version, String timestamp) {
        String tweakedVersion = version;
        if (version.contains(JAR_SNAPSHOT_POSTFIX)) {
            tweakedVersion = tweakedVersion.replace(JAR_SNAPSHOT_POSTFIX, "." + timestamp);
        }
        return tweakedVersion;
    }
}

