/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.bundler.impl;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import java.io.File;
import java.util.UUID;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.reficio.p2.bundler.ArtifactBundlerInstructions;
import org.reficio.p2.bundler.ArtifactBundlerRequest;
import org.reficio.p2.utils.BundleUtils;

public class AquteHelper {
    public static final String SINGLETON = "singleton:=true";
    public static final String TOOL_KEY = "Tool";
    public static final String TOOL = "p2-maven-plugin (reficio.org)";

    public static Analyzer buildAnalyzer(ArtifactBundlerRequest request, ArtifactBundlerInstructions instructions, boolean pedantic) throws Exception {
        Analyzer analyzer = AquteHelper.instantiateAnalyzer(request);
        AquteHelper.setAnalyzerOptions(analyzer, pedantic);
        AquteHelper.setPackageOptions(analyzer);
        AquteHelper.setInstructions(analyzer, instructions);
        AquteHelper.setBundleOptions(analyzer, instructions);
        AquteHelper.setManifest(analyzer);
        return analyzer;
    }

    private static Analyzer instantiateAnalyzer(ArtifactBundlerRequest request) throws Exception {
        Analyzer analyzer = new Analyzer();
        analyzer.setJar(AquteHelper.getInputJarWithBlankManifest(request));
        return analyzer;
    }

    private static void setAnalyzerOptions(Analyzer analyzer, boolean pedantic) {
        analyzer.setPedantic(pedantic);
    }

    private static void setPackageOptions(Analyzer analyzer) {
        analyzer.setProperty("Import-Package", "*;resolution:=optional");
        String export = analyzer.calculateExportsFromContents(analyzer.getJar());
        analyzer.setProperty("Export-Package", export);
    }

    private static void setBundleOptions(Analyzer analyzer, ArtifactBundlerInstructions instructions) {
        analyzer.setProperty("Bundle-SymbolicName", instructions.getSymbolicNameWithOptions());
        if (analyzer.getProperty("Bundle-Name") == null) {
            analyzer.setProperty("Bundle-Name", instructions.getName());
        }
        analyzer.setProperty("Bundle-Version", instructions.getVersion());
        analyzer.setProperty(TOOL_KEY, TOOL);
    }

    private static void setInstructions(Analyzer analyzer, ArtifactBundlerInstructions instructions) {
        if (!instructions.getInstructions().isEmpty()) {
            analyzer.setProperties(BundleUtils.transformDirectivesToProperties(instructions.getInstructions()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Jar getInputJarWithBlankManifest(ArtifactBundlerRequest request) throws Exception {
        File parentFolder = request.getBinaryInputFile().getParentFile();
        File jarBlankManifest = new File(parentFolder, request.getBinaryInputFile().getName() + "." + UUID.randomUUID());
        Jar jar = new Jar(request.getBinaryInputFile());
        try {
            jar.setManifest(new Manifest());
            jar.write(jarBlankManifest);
            Jar jar2 = new Jar(jarBlankManifest);
            return jar2;
        }
        finally {
            FileUtils.deleteQuietly((File)jarBlankManifest);
        }
    }

    private static void setManifest(Analyzer analyzer) throws Exception {
        analyzer.mergeManifest(analyzer.getJar().getManifest());
    }
}

