/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2;

import java.util.Locale;
import org.reficio.p2.P2Artifact;
import org.reficio.p2.logger.Logger;
import org.reficio.p2.resolver.maven.ResolvedArtifact;
import org.reficio.p2.utils.BundleUtils;

public class P2Validator {
    public static void validateBundleRequest(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact) {
        P2Validator.validateGeneralConfig(p2Artifact);
        P2Validator.validateArtifactConfig(p2Artifact, resolvedArtifact);
    }

    private static void validateGeneralConfig(P2Artifact p2Artifact) {
        if (p2Artifact.shouldIncludeTransitive() && !p2Artifact.getCombinedInstructions().isEmpty()) {
            String message = String.format(Locale.ENGLISH, "BND instructions are NOT applied to the transitive dependencies of %s", p2Artifact.getId());
            Logger.getLog().warn(message);
        }
        if (p2Artifact.getCombinedInstructions().size() != p2Artifact.getInstructions().size()) {
            for (String propertyName : p2Artifact.getInstructionsProperties().stringPropertyNames()) {
                if (!p2Artifact.getInstructions().containsKey(propertyName)) continue;
                String message = String.format(Locale.ENGLISH, "BND instruction <%s> from <instructions> is overridden in <instructionsProperties>", propertyName);
                Logger.getLog().warn(message);
            }
        }
    }

    public static void validateArtifactConfig(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact) {
        boolean bundle = BundleUtils.INSTANCE.isBundle(resolvedArtifact.getArtifact().getFile());
        if (resolvedArtifact.isRoot() && bundle) {
            if (!p2Artifact.shouldOverrideManifest() && !p2Artifact.getCombinedInstructions().isEmpty()) {
                String message = String.format(Locale.ENGLISH, "p2-maven-plugin misconfiguration%n%n\tJar [%s] is already a bundle. %n\tBND instructions are specified, but the <override> flag is set to false.%n\tEither remove the instructions or set the <override> flag to true.%n\tWATCH OUT! Setting <override> to true will re-bundle the artifact!%n", resolvedArtifact.getArtifact().toString());
                throw new RuntimeException(message);
            }
            if (!p2Artifact.shouldOverrideManifest() && p2Artifact.isSingleton()) {
                String message = String.format(Locale.ENGLISH, "p2-maven-plugin misconfiguration%n%n\tJar [%s] is already a bundle. %n\tsingleton is set to true, but the <override> flag is set to false.%n\tEither remove the singleton flag or set the <override> flag to true.%n\tWATCH OUT! Setting <override> to true will re-bundle the artifact!%n", resolvedArtifact.getArtifact().toString());
                throw new RuntimeException(message);
            }
        }
    }
}

