/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.reficio.p2.P2Artifact;
import org.reficio.p2.P2FeatureDefinition;
import org.reficio.p2.bundler.ArtifactBundlerInstructions;
import org.reficio.p2.bundler.P2ArtifactMap;
import org.reficio.p2.logger.Logger;
import org.reficio.p2.utils.JarUtils;
import org.reficio.p2.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FeatureBuilder {
    private P2ArtifactMap<ArtifactBundlerInstructions> bundlerInstructions;
    private P2FeatureDefinition p2FeatureDefintion;
    private boolean generateSourceFeature;
    private boolean unpack;
    private String featureTimeStamp;

    public FeatureBuilder(P2FeatureDefinition p2FeatureDefintion, P2ArtifactMap<ArtifactBundlerInstructions> bundlerInstructions, boolean generateSourceFeature, boolean unpack, String timestamp) {
        this.p2FeatureDefintion = p2FeatureDefintion;
        this.bundlerInstructions = bundlerInstructions;
        this.generateSourceFeature = generateSourceFeature;
        this.unpack = unpack;
        this.featureTimeStamp = timestamp;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void generate(File destinationFolder) {
        try {
            File featureContent = new File(destinationFolder, this.getFeatureFullName());
            featureContent.mkdir();
            Document xmlDoc = this.buildXml();
            XmlUtils.writeXml(xmlDoc, new File(featureContent, "feature.xml"));
            File destJar = new File(destinationFolder, this.getFeatureFullName() + ".jar");
            JarUtils.createJar(featureContent, destJar);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot generate feature", e);
        }
    }

    String getQualifiedFeatureVersion() {
        String v = this.p2FeatureDefintion.getVersion();
        return v.replace("qualifier", this.featureTimeStamp);
    }

    String getFeatureFullName() {
        String id = this.p2FeatureDefintion.getId();
        if (this.generateSourceFeature) {
            id = id + ".source";
        }
        return id + "_" + this.getQualifiedFeatureVersion();
    }

    private Logger log() {
        return Logger.getLog();
    }

    Document buildXml() throws ParserConfigurationException, FileNotFoundException {
        String id;
        Document xmlDoc = this.fetchOrCreateXml();
        Element featureElement = XmlUtils.fetchOrCreateElement(xmlDoc, xmlDoc, "feature");
        this.computeFeatureId(featureElement);
        this.computeFeatureVersion(featureElement);
        this.computeFeatureAttributes(xmlDoc, featureElement);
        if (this.generateSourceFeature && !(id = featureElement.getAttribute("id")).endsWith(".source")) {
            featureElement.setAttribute("id", id + ".source");
            featureElement.setAttribute("label", featureElement.getAttribute("label") + " (Developer Resources)");
        }
        this.generateFeatureContent(xmlDoc, featureElement);
        return xmlDoc;
    }

    private void computeFeatureId(Element featureElement) {
        if (this.p2FeatureDefintion.getId() != null) {
            featureElement.setAttribute("id", this.p2FeatureDefintion.getId());
        } else if (featureElement.hasAttribute("id")) {
            this.p2FeatureDefintion.setId(featureElement.getAttribute("id"));
        } else {
            throw new RuntimeException("No id defined for feature in pom or featureFile");
        }
    }

    private void computeFeatureVersion(Element featureElement) {
        if (this.p2FeatureDefintion.getVersion() != null) {
            featureElement.setAttribute("version", this.p2FeatureDefintion.getVersion());
        } else if (featureElement.hasAttribute("version")) {
            this.p2FeatureDefintion.setVersion(featureElement.getAttribute("version"));
        } else {
            throw new RuntimeException("No version defined for feature in pom or featureFile");
        }
        String xmlVersion = featureElement.getAttribute("version");
        if (xmlVersion.contains("qualifier")) {
            featureElement.setAttribute("version", xmlVersion.replace("qualifier", this.featureTimeStamp));
        }
    }

    private void computeFeatureAttributes(Document xmlDoc, Element featureElement) {
        if (this.p2FeatureDefintion.getLabel() != null) {
            featureElement.setAttribute("label", this.p2FeatureDefintion.getLabel());
        }
        if (this.p2FeatureDefintion.getProviderName() != null) {
            featureElement.setAttribute("provider-name", this.p2FeatureDefintion.getProviderName());
        }
        if (this.p2FeatureDefintion.getDescription() != null) {
            Element descriptionElement = XmlUtils.fetchOrCreateElement(xmlDoc, featureElement, "description");
            descriptionElement.setTextContent(this.p2FeatureDefintion.getDescription());
        }
        if (this.p2FeatureDefintion.getCopyright() != null) {
            Element copyrightElement = XmlUtils.fetchOrCreateElement(xmlDoc, featureElement, "copyright");
            copyrightElement.setTextContent(this.p2FeatureDefintion.getCopyright());
        }
        if (this.p2FeatureDefintion.getLicense() != null) {
            Element licenceElement = XmlUtils.fetchOrCreateElement(xmlDoc, featureElement, "license");
            licenceElement.setTextContent(this.p2FeatureDefintion.getLicense());
        }
    }

    private void generateFeatureContent(Document xmlDoc, Element featureElement) {
        for (P2Artifact artifact : this.p2FeatureDefintion.getArtifacts()) {
            Object abis = this.bundlerInstructions.get(artifact);
            Iterator iterator = abis.iterator();
            while (iterator.hasNext()) {
                String id;
                ArtifactBundlerInstructions abi = (ArtifactBundlerInstructions)iterator.next();
                String version = abi.getProposedVersion();
                if (this.generateSourceFeature) {
                    id = abi.getSourceSymbolicName();
                    if (id == null || id.trim().isEmpty()) {
                        this.log().info("\t [WARN] No source found for " + abi.getSymbolicName());
                        continue;
                    }
                } else {
                    id = abi.getSymbolicName();
                }
                Element pluginElement = XmlUtils.createElement(xmlDoc, featureElement, "plugin");
                pluginElement.setAttribute("id", id);
                pluginElement.setAttribute("download-size", "0");
                pluginElement.setAttribute("install-size", "0");
                pluginElement.setAttribute("version", version);
                pluginElement.setAttribute("unpack", this.unpack ? "true" : "false");
            }
        }
    }

    Document fetchOrCreateXml() throws ParserConfigurationException, FileNotFoundException {
        if (null == this.p2FeatureDefintion.getFeatureFile()) {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        return XmlUtils.parseXml(new FileInputStream(this.p2FeatureDefintion.getFeatureFile()));
    }
}

