/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2;

import aQute.bnd.osgi.Jar;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.reficio.p2.P2Artifact;
import org.reficio.p2.bundler.ArtifactBundlerInstructions;
import org.reficio.p2.bundler.ArtifactBundlerRequest;
import org.reficio.p2.resolver.maven.Artifact;
import org.reficio.p2.resolver.maven.ResolvedArtifact;
import org.reficio.p2.utils.BundleUtils;
import org.reficio.p2.utils.Utils;

public class P2Helper {
    public static ArtifactBundlerRequest createBundlerRequest(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact, File outputFolder) {
        Artifact artifact = resolvedArtifact.getArtifact();
        Artifact sourceArtifact = resolvedArtifact.getSourceArtifact();
        File artifactOutputFolder = P2Helper.forceMkdirSilently(new File(outputFolder, artifact.getGroupId()));
        File binaryInputFile = artifact.getFile();
        File binaryOutputFile = new File(artifactOutputFolder, artifact.getFile().getName());
        File sourceInputFile = null;
        File sourceOutputFile = null;
        if (sourceArtifact != null) {
            sourceInputFile = sourceArtifact.getFile();
            sourceOutputFile = new File(artifactOutputFolder, sourceArtifact.getFile().getName());
        }
        boolean bundle = BundleUtils.INSTANCE.isBundle(artifact.getFile());
        boolean shouldBundle = P2Helper.shouldBundle(p2Artifact, resolvedArtifact, bundle);
        return new ArtifactBundlerRequest(binaryInputFile, binaryOutputFile, sourceInputFile, sourceOutputFile, shouldBundle);
    }

    private static File forceMkdirSilently(File folder) {
        try {
            FileUtils.forceMkdir((File)folder);
            return folder;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static boolean shouldBundle(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact, boolean resolvedArtifactIsBundle) {
        if (resolvedArtifactIsBundle) {
            return p2Artifact.shouldOverrideManifest() && resolvedArtifact.isRoot();
        }
        return true;
    }

    public static ArtifactBundlerInstructions createBundlerInstructions(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact, String timestamp) {
        try {
            String fullSymbolicName = P2Helper.calculateFullSymbolicName(p2Artifact, resolvedArtifact);
            String symbolicNameWithOptions = P2Helper.calculateSymbolicNameWithOptions(p2Artifact, resolvedArtifact, fullSymbolicName);
            String symbolicName = P2Helper.calculateSymbolicName(fullSymbolicName);
            String name = P2Helper.calculateName(symbolicName);
            String version = P2Helper.calculateVersion(p2Artifact, resolvedArtifact, timestamp);
            String proposedVersion = P2Helper.calculateProposedVersion(resolvedArtifact, timestamp);
            String sourceSymbolicName = null;
            String sourceName = null;
            if (resolvedArtifact.getSourceArtifact() != null) {
                sourceSymbolicName = P2Helper.calculateSourceSymbolicName(symbolicName);
                sourceName = P2Helper.calculateSourceName(name, symbolicName);
            }
            ArtifactBundlerInstructions.Builder builder = ArtifactBundlerInstructions.builder().name(name).symbolicName(symbolicName).symbolicNameWithOptions(symbolicNameWithOptions).version(version).snapshot(resolvedArtifact.isSnapshot()).sourceName(sourceName).sourceSymbolicName(sourceSymbolicName).proposedVersion(proposedVersion);
            if (resolvedArtifact.isRoot()) {
                builder.instructions(p2Artifact.getInstructions());
            }
            return builder.build();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static String calculateName(String symbolicName) {
        return symbolicName;
    }

    private static String calculateSymbolicName(String fullSymbolicName) {
        int pos = fullSymbolicName.indexOf(59);
        if (pos < 0) {
            return fullSymbolicName;
        }
        return fullSymbolicName.substring(0, pos);
    }

    private static String calculateFullSymbolicName(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact) throws IOException {
        String classifier;
        String symbolicName = null;
        if (resolvedArtifact.isRoot()) {
            String symbolicNameValue = p2Artifact.getInstructions().get("Bundle-SymbolicName");
            String string = symbolicName = symbolicNameValue != null ? symbolicNameValue.toString() : null;
        }
        if (symbolicName == null) {
            symbolicName = BundleUtils.INSTANCE.getBundleSymbolicName(new Jar(resolvedArtifact.getArtifact().getFile()));
        }
        if (symbolicName == null) {
            symbolicName = BundleUtils.INSTANCE.calculateBundleSymbolicName(resolvedArtifact.getArtifact());
        }
        if (StringUtils.isNotBlank((String)(classifier = resolvedArtifact.getArtifact().getClassifier()))) {
            symbolicName = symbolicName + "." + classifier;
        }
        return symbolicName;
    }

    private static String calculateVersion(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact, String timestamp) throws IOException {
        String version = P2Helper.getUserDefinedVersion(p2Artifact, resolvedArtifact, timestamp);
        if (version != null) {
            return BundleUtils.INSTANCE.cleanupVersion(version);
        }
        return P2Helper.calculateProposedVersion(resolvedArtifact, timestamp);
    }

    private static String getUserDefinedVersion(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact, String timestamp) {
        String version = null;
        if (resolvedArtifact.isRoot()) {
            String versionValue = p2Artifact.getInstructions().get("Bundle-Version");
            version = versionValue != null ? Utils.snapshotToTimestamp(versionValue.toString(), timestamp) : null;
        }
        return version;
    }

    private static String calculateProposedVersion(ResolvedArtifact resolvedArtifact, String timestamp) throws IOException {
        String version;
        if (resolvedArtifact.isSnapshot()) {
            version = P2Helper.calculateSnapshotVersion(resolvedArtifact);
        } else {
            version = BundleUtils.INSTANCE.getBundleVersion(new Jar(resolvedArtifact.getArtifact().getFile()));
            if (version == null) {
                version = BundleUtils.INSTANCE.calculateBundleVersion(resolvedArtifact.getArtifact());
            }
        }
        return BundleUtils.INSTANCE.cleanupVersion(Utils.snapshotToTimestamp(version, timestamp));
    }

    private static String calculateSnapshotVersion(ResolvedArtifact resolvedArtifact) {
        String version;
        if (BundleUtils.INSTANCE.isReuseSnapshotVersionFromArtifact() && P2Helper.isProperSnapshotVersion(version = resolvedArtifact.getArtifact().getVersion())) {
            return version;
        }
        String baseVersion = resolvedArtifact.getArtifact().getBaseVersion();
        if (P2Helper.isProperSnapshotVersion(baseVersion)) {
            return baseVersion;
        }
        if (!baseVersion.contains("SNAPSHOT")) {
            baseVersion = baseVersion + ".SNAPSHOT";
        }
        return baseVersion;
    }

    public static boolean isProperSnapshotVersion(String version) {
        return version.matches(".*[0-9\\.]{13,16}-[0-9]{3}");
    }

    public static String calculateSourceSymbolicName(String symbolicName) {
        return symbolicName + ".source";
    }

    public static String calculateSourceName(String name, String symbolicName) {
        String sourceName = null;
        if (name == null) {
            sourceName = symbolicName + ".source";
        } else {
            sourceName = name.trim();
            sourceName = sourceName.matches(".*\\s+.*") ? sourceName + " " : sourceName + ".";
            sourceName = sourceName.matches(".*[A-Z].*") ? sourceName + "Source" : sourceName + "source";
        }
        return sourceName;
    }

    public static String calculateSymbolicNameWithOptions(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact, String symbolicName) {
        String fullSymbolicName = symbolicName;
        if (resolvedArtifact.isRoot() && p2Artifact.isSingleton() && !fullSymbolicName.contains("singleton:=true")) {
            fullSymbolicName = fullSymbolicName + ";" + "singleton:=true";
        }
        return fullSymbolicName;
    }
}

