// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

import org.refcodes.matcher.Matcher;

/**
 * This interface typifies the matcher interface for the usage with services. A
 * service matcher most commonly uses the service Meta-Data in order to
 * determine whether an event matches or not.
 *
 * @param <S> The matchee type
 */
public interface ServiceMatcher<S extends Service<?>> extends Matcher<S> {

	/**
	 * Tests whether the given service matches this descriptor by comparing the
	 * service's type with the type specified in this descriptor as well as the
	 * service's Meta-Data with the Meta-Data stored in the descriptor. .
	 * 
	 * @param aService The service to be compared.
	 * 
	 * @return True in case descriptor and service match, else false.
	 */
	@Override
	boolean isMatching( S aService );
}
