// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

import org.refcodes.component.ext.observer.ObservableLifeCycleStatusAutomaton;

/**
 * The {@link ServiceContextImpl} implements the {@link ServiceContext}.
 *
 * @param <S> The type to be used for the {@link Service}.
 */
public class ServiceContextImpl<S extends Service<?>> implements ServiceContext<S> {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private ObservableLifeCycleStatusAutomaton _observableLifeCycleAutomaton;

	private ServiceBus<S> _serviceBus;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs the {@link ServiceContextImpl} to be configured with the given
	 * {@link ObservableLifeCycleStatusAutomaton}.
	 * 
	 * @param aServiceBus The {@link ServiceBus} with which to construct the
	 *        {@link ServiceContextImpl}.
	 * 
	 * @param aObservableLifeCycleAutomaton The
	 *        {@link ObservableLifeCycleStatusAutomaton} with which to construct
	 *        the {@link ServiceContextImpl}.
	 */
	public ServiceContextImpl( ServiceBus<S> aServiceBus, ObservableLifeCycleStatusAutomaton aObservableLifeCycleAutomaton ) {
		_observableLifeCycleAutomaton = aObservableLifeCycleAutomaton;
		_serviceBus = aServiceBus;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ObservableLifeCycleStatusAutomaton getObservableLifeCycleAutomaton() {
		return _observableLifeCycleAutomaton;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ServiceBus<S> getServiceBus() {
		return _serviceBus;
	}
}
