// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

/**
 * Provides an accessor for a {@link ServiceBus} property.
 *
 * @param <S> The type to be used for the {@link Service}.
 */
public interface ServiceBusAccessor<S extends Service<?>> {

	/**
	 * Retrieves the {@link ServiceBus} property from the property.
	 * 
	 * @return Returns the {@link ServiceBus} property stored by the property.
	 */
	ServiceBus<S> getServiceBus();

	/**
	 * Provides a mutator for a {@link ServiceBus} property.
	 *
	 * @param <S> the generic type
	 */
	public interface ServiceBusMutator<S extends Service<?>> {

		/**
		 * Sets the {@link ServiceBus} property for the property.
		 * 
		 * @param aServiceBus The {@link ServiceBus} property to be stored by
		 *        the property.
		 */
		void setServiceBus( S aServiceBus );
	}

	/**
	 * Provides a {@link ServiceBus} property.
	 *
	 * @param <S> the generic type
	 */
	public interface ServiceBusProperty<S extends Service<?>> extends ServiceBusAccessor<S>, ServiceBusMutator<S> {}
}
