// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

import org.refcodes.component.Component;
import org.refcodes.mixin.MetaDataAccessor;

/**
 * Any {@link Service} to be made available by the service bus must implement
 * this interface. Adding methods to this interface forces any service to
 * implement this method which might be useful for later extensions.
 * <p>
 * To identify a {@link Service} via lookup, we need criteria for identifying
 * that service. One criteria might by the type of the {@link Service}, others
 * may be implementation or configuration specific. At least the configuration
 * specific criteria is found in the service's Meta-Data provided by the
 * {@link MetaDataAccessor} which each {@link Service} is to provide.
 *
 * @param <SMD> the generic type
 */
public interface Service<SMD> extends MetaDataAccessor<SMD>, Component {}
