// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

/**
 * Provides an accessor for a name ID property.
 */
public interface NameIdAccessor {

	/**
	 * Retrieves the name ID from the name ID property.
	 * 
	 * @return The name ID stored by the name ID property.
	 */
	String getNameId();

	/**
	 * Provides a mutator for a name ID property.
	 */
	public interface NameIdMutator {

		/**
		 * Sets the name ID for the name ID property.
		 * 
		 * @param aNameId The name ID to be stored by the name ID property.
		 */
		void setNameId( String aNameId );
	}

	/**
	 * Provides a name ID property.
	 */
	public interface NameIdProperty extends NameIdAccessor, NameIdMutator {}
}
