// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.servicebus;

import org.refcodes.servicebus.ServiceBusRuntimeException.ServiceBusServiceRuntimeException;

/**
 * This exception is thrown whenever a service, which cannot be distinguished
 * from another service, is added to the service bus. In such a case, no matcher
 * would be able to match exactly one of them services, we would end up with a
 * non deterministic system.
 */
public class DuplicateServiceRuntimeException extends ServiceBusServiceRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new duplicate service runtime exception.
	 *
	 * @param aService the service
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public DuplicateServiceRuntimeException( Service<?> aService, String aMessage, String aErrorCode ) {
		super( aService, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new duplicate service runtime exception.
	 *
	 * @param aService the service
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public DuplicateServiceRuntimeException( Service<?> aService, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aService, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new duplicate service runtime exception.
	 *
	 * @param aService the service
	 * @param message the message
	 * @param cause the cause
	 */
	public DuplicateServiceRuntimeException( Service<?> aService, String message, Throwable cause ) {
		super( aService, message, cause );
	}

	/**
	 * Instantiates a new duplicate service runtime exception.
	 *
	 * @param aService the service
	 * @param message the message
	 */
	public DuplicateServiceRuntimeException( Service<?> aService, String message ) {
		super( aService, message );
	}

	/**
	 * Instantiates a new duplicate service runtime exception.
	 *
	 * @param aService the service
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public DuplicateServiceRuntimeException( Service<?> aService, Throwable aCause, String aErrorCode ) {
		super( aService, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new duplicate service runtime exception.
	 *
	 * @param aService the service
	 * @param cause the cause
	 */
	public DuplicateServiceRuntimeException( Service<?> aService, Throwable cause ) {
		super( aService, cause );
	}

}
