package org.refcodes.servicebus;

import org.refcodes.servicebus.ServiceBusRuntimeException.ServiceBusServiceMatcherRuntimeException;

/**
 * This exception is thrown whenever a service cannot be unambiguously
 * distinguished from another service because a matcher was not strict enough to
 * identify just one service.
 */
public class AmbiguousServiceRuntimeException extends ServiceBusServiceMatcherRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, String aMessage, String aErrorCode ) {
		super( aServiceMatcher, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aServiceMatcher, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param message the message
	 * @param cause the cause
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, String message, Throwable cause ) {
		super( aServiceMatcher, message, cause );
	}

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param message the message
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, String message ) {
		super( aServiceMatcher, message );
	}

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, Throwable aCause, String aErrorCode ) {
		super( aServiceMatcher, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new ambiguous service runtime exception.
	 *
	 * @param aServiceMatcher the service matcher
	 * @param cause the cause
	 */
	public AmbiguousServiceRuntimeException( org.refcodes.servicebus.ServiceMatcher<?> aServiceMatcher, Throwable cause ) {
		super( aServiceMatcher, cause );
	}

}
