/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.redisson.client.RedisConnection;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServer;
import org.springframework.data.redis.connection.convert.Converters;

public class RedissonSentinelConnection
implements RedisSentinelConnection {
    private final RedisConnection connection;

    public RedissonSentinelConnection(RedisConnection connection) {
        this.connection = connection;
    }

    public void failover(NamedNode master) {
        this.connection.sync((RedisCommand)RedisCommands.SENTINEL_FAILOVER, new Object[]{master.getName()});
    }

    private static List<RedisServer> toRedisServersList(List<Map<String, String>> source) {
        ArrayList<RedisServer> servers = new ArrayList<RedisServer>(source.size());
        for (Map<String, String> info : source) {
            servers.add(RedisServer.newServerFrom((Properties)Converters.toProperties(info)));
        }
        return servers;
    }

    public Collection<RedisServer> masters() {
        List masters = (List)this.connection.sync((Codec)StringCodec.INSTANCE, RedisCommands.SENTINEL_MASTERS, new Object[0]);
        return RedissonSentinelConnection.toRedisServersList(masters);
    }

    public Collection<RedisServer> replicas(NamedNode master) {
        List slaves = (List)this.connection.sync((Codec)StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, new Object[]{master.getName()});
        return RedissonSentinelConnection.toRedisServersList(slaves);
    }

    public void remove(NamedNode master) {
        this.connection.sync((RedisCommand)RedisCommands.SENTINEL_REMOVE, new Object[]{master.getName()});
    }

    public void monitor(RedisServer master) {
        this.connection.sync((RedisCommand)RedisCommands.SENTINEL_MONITOR, new Object[]{master.getName(), master.getHost(), (int)master.getPort(), master.getQuorum().intValue()});
    }

    public void close() throws IOException {
        this.connection.closeAsync();
    }

    public boolean isOpen() {
        return !this.connection.isClosed();
    }
}

