/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.reflect.Field;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.redisson.client.codec.Codec;

public class RedissonCacheKeysFactory
extends DefaultCacheKeysFactory {
    private final Codec codec;

    public RedissonCacheKeysFactory(Codec codec) {
        this.codec = codec;
    }

    public Object createCollectionKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        try {
            String[] parts = persister.getRole().split("\\.");
            Field f = ReflectHelper.findField(id.getClass(), (String)parts[parts.length - 1]);
            Object prev = f.get(id);
            f.set(id, null);
            ByteBuf state = this.codec.getMapKeyEncoder().encode(id);
            Object newId = this.codec.getMapKeyDecoder().decode(state, null);
            state.release();
            f.set(id, prev);
            return super.createCollectionKey(newId, persister, factory, tenantIdentifier);
        }
        catch (PropertyNotFoundException e) {
            return super.createCollectionKey(id, persister, factory, tenantIdentifier);
        }
        catch (IOException | IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

