/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import java.util.Objects;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class CompositeCodec
implements Codec {
    private final Codec mapKeyCodec;
    private final Codec mapValueCodec;
    private final Codec valueCodec;

    public CompositeCodec(Codec mapKeyCodec, Codec mapValueCodec) {
        this(mapKeyCodec, mapValueCodec, null);
    }

    public CompositeCodec(Codec mapKeyCodec, Codec mapValueCodec, Codec valueCodec) {
        this.mapKeyCodec = mapKeyCodec;
        this.mapValueCodec = mapValueCodec;
        this.valueCodec = valueCodec;
    }

    public CompositeCodec(ClassLoader classLoader, CompositeCodec codec) throws ReflectiveOperationException {
        this.mapKeyCodec = BaseCodec.copy(classLoader, codec.mapKeyCodec);
        this.mapValueCodec = BaseCodec.copy(classLoader, codec.mapValueCodec);
        this.valueCodec = BaseCodec.copy(classLoader, codec.valueCodec);
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.mapValueCodec.getMapValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.mapValueCodec.getMapValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.mapKeyCodec.getMapKeyDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.mapKeyCodec.getMapKeyEncoder();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.valueCodec.getValueDecoder();
    }

    @Override
    public Encoder getValueEncoder() {
        return this.valueCodec.getValueEncoder();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeCodec that = (CompositeCodec)o;
        return Objects.equals(this.mapKeyCodec, that.mapKeyCodec) && Objects.equals(this.mapValueCodec, that.mapValueCodec) && Objects.equals(this.valueCodec, that.valueCodec);
    }

    public int hashCode() {
        return Objects.hash(this.mapKeyCodec, this.mapValueCodec, this.valueCodec);
    }
}

