/*
 * Decompiled with CFR 0.152.
 */
package org.red5.classloading;

import java.net.URL;
import java.net.URLClassLoader;

public final class ChildFirstClassLoader
extends URLClassLoader {
    private ClassLoader parent;
    private ClassLoader parentParent;
    private ClassLoader system;

    public ChildFirstClassLoader(URL[] urls) {
        super(urls);
        this.parent = super.getParent();
        this.system = ChildFirstClassLoader.getSystemClassLoader();
        this.parentParent = this.parent.getParent() != this.system ? this.parent.getParent() : null;
        this.dumpClassLoaderNames();
    }

    public ChildFirstClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.parent = parent;
        this.system = ChildFirstClassLoader.getSystemClassLoader();
        if (parent != null) {
            this.parentParent = this.parent.getParent() != this.system ? this.parent.getParent() : null;
        }
        this.dumpClassLoaderNames();
    }

    private void dumpClassLoaderNames() {
        System.out.printf("[ChildFirstClassLoader] Classloaders:\nSystem %s\nParents Parent %s\nParent %s\nThis class %s\nTCL %s\n\n", this.system, this.parentParent, this.parent, ChildFirstClassLoader.class.getClassLoader(), Thread.currentThread().getContextClassLoader());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null) {
            try {
                c = this.parent.loadClass(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (c == null && this.parentParent != null) {
                try {
                    c = this.parentParent.loadClass(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (c == null) {
                try {
                    c = this.system.loadClass(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.parent.getResource(name);
        }
        return url;
    }
}

