/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.IoBufferAllocator;
import org.apache.mina.core.buffer.SimpleBufferAllocator;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceStatistics;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.red5.server.jmx.mxbeans.RTMPMinaTransportMXBean;
import org.red5.server.net.rtmp.RTMPMinaIoHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPMinaTransport
implements RTMPMinaTransportMXBean {
    private static final Logger log = LoggerFactory.getLogger(RTMPMinaTransport.class);
    private ThreadPoolExecutor executor;
    protected SocketAcceptor acceptor;
    protected Set<String> addresses = new HashSet<String>();
    protected IoHandlerAdapter ioHandler;
    protected int ioThreads = Runtime.getRuntime().availableProcessors() * 2;
    protected ObjectName serviceManagerObjectName;
    protected IoServiceStatistics stats;
    protected boolean enableMinaLogFilter;
    protected boolean enableMinaMonitor;
    protected int minaPollInterval = 1000;
    protected boolean tcpNoDelay = true;
    protected boolean useHeapBuffers = true;
    protected int sendBufferSize = 65536;
    protected int receiveBufferSize = 65536;
    private int readerIdleTime = 2;
    private int trafficClass = 24;
    private int backlog = 32;
    private int thoughputCalcInterval = 1;
    private long executorKeepAliveTime = 60000L;
    private boolean enableDefaultAcceptor = true;
    private int initialPoolSize = 0;
    private int maxPoolSize = Runtime.getRuntime().availableProcessors() + 1;
    private int maxProcessorPoolSize = 16;
    private boolean keepAlive;

    private void initIOHandler() {
        if (this.ioHandler == null) {
            log.info("No RTMP IO Handler associated - using defaults");
            this.ioHandler = new RTMPMinaIoHandler();
        }
    }

    public void start() throws Exception {
        this.initIOHandler();
        IoBuffer.setUseDirectBuffer((!this.useHeapBuffers ? 1 : 0) != 0);
        if (this.useHeapBuffers) {
            IoBuffer.setAllocator((IoBufferAllocator)new SimpleBufferAllocator());
        }
        log.info("RTMP Mina Transport Settings\nAcceptor style: {} I/O threads: {}\nTCP no-delay: {} keep-alive: {}", new Object[]{this.enableDefaultAcceptor ? "default" : "blocking-queue", this.ioThreads, this.tcpNoDelay, this.keepAlive});
        if (this.enableDefaultAcceptor) {
            this.acceptor = new NioSocketAcceptor(this.ioThreads);
        } else {
            SimpleIoProcessorPool pool = new SimpleIoProcessorPool(NioProcessor.class, this.maxProcessorPoolSize);
            this.executor = new ThreadPoolExecutor(this.initialPoolSize, this.maxPoolSize, this.executorKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(Short.MAX_VALUE));
            this.acceptor = new NioSocketAcceptor((Executor)this.executor, (IoProcessor)pool);
        }
        if (this.enableMinaLogFilter) {
            DefaultIoFilterChainBuilder chain = this.acceptor.getFilterChain();
            LoggingFilter logFilter = new LoggingFilter(RTMPMinaTransport.class);
            chain.addLast("logger", (IoFilter)logFilter);
        }
        this.acceptor.setCloseOnDeactivation(true);
        this.acceptor.setHandler((IoHandler)this.ioHandler);
        this.acceptor.setBacklog(this.backlog);
        SocketSessionConfig sessionConf = this.acceptor.getSessionConfig();
        sessionConf.setReuseAddress(true);
        sessionConf.setTcpNoDelay(this.tcpNoDelay);
        sessionConf.setSendBufferSize(this.sendBufferSize);
        sessionConf.setReceiveBufferSize(this.receiveBufferSize);
        sessionConf.setMaxReadBufferSize(this.receiveBufferSize);
        sessionConf.setThroughputCalculationInterval(this.thoughputCalcInterval);
        sessionConf.setReaderIdleTime(this.readerIdleTime);
        sessionConf.setKeepAlive(this.keepAlive);
        if (this.trafficClass == -1) {
            log.info("Traffic class modification is disabled");
        } else {
            sessionConf.setTrafficClass(this.trafficClass);
        }
        log.info("Send buffer size: {} recv buffer size: {} so linger: {} traffic class: {}", new Object[]{sessionConf.getSendBufferSize(), sessionConf.getReceiveBufferSize(), sessionConf.getSoLinger(), sessionConf.getTrafficClass()});
        this.acceptor.setReuseAddress(true);
        try {
            HashSet<InetSocketAddress> socketAddresses = new HashSet<InetSocketAddress>();
            for (String addr : this.addresses) {
                if (addr.indexOf(58) != -1) {
                    String[] parts = addr.split(":");
                    socketAddresses.add(new InetSocketAddress(parts[0], (int)Integer.valueOf(parts[1])));
                    continue;
                }
                socketAddresses.add(new InetSocketAddress(addr, 1935));
            }
            log.debug("Binding to {}", (Object)((Object)socketAddresses).toString());
            this.acceptor.bind(socketAddresses);
            String cName = this.getClass().getName();
            if (cName.indexOf(46) != -1) {
                cName = cName.substring(cName.lastIndexOf(46)).replaceFirst("[\\.]", "");
            }
            if (this.enableMinaMonitor) {
                this.stats = new IoServiceStatistics((IoService)((AbstractIoService)this.acceptor));
                this.stats.setThroughputCalculationInterval(this.minaPollInterval);
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                try {
                    this.serviceManagerObjectName = new ObjectName("org.red5.server:type=RTMPMinaTransport");
                    mbs.registerMBean(new StandardMBean(this, RTMPMinaTransportMXBean.class, true), this.serviceManagerObjectName);
                }
                catch (Exception e) {
                    log.warn("Error on jmx registration", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("Exception occurred during resolve / bind", (Throwable)e);
        }
    }

    public void stop() {
        log.info("RTMP Mina Transport stop");
        this.acceptor.unbind();
        if (!this.enableDefaultAcceptor) {
            this.executor.shutdownNow();
        }
        this.acceptor.dispose(false);
        if (this.serviceManagerObjectName != null) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(this.serviceManagerObjectName);
            }
            catch (Exception e) {
                log.warn("Error on jmx unregistration", (Throwable)e);
            }
        }
    }

    public void setAddress(String address) {
        this.addresses.add(address);
        log.info("RTMP will be bound to {}", (Object)address);
    }

    public void setAddresses(List<String> addrs) {
        for (String addr : addrs) {
            this.addresses.add(addr);
        }
        log.info("RTMP will be bound to {}", this.addresses);
    }

    public void setIoHandler(IoHandlerAdapter rtmpIOHandler) {
        this.ioHandler = rtmpIOHandler;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setThoughputCalcInterval(int thoughputCalcInterval) {
        this.thoughputCalcInterval = thoughputCalcInterval;
    }

    public void setExecutorKeepAliveTime(long executorKeepAliveTime) {
        this.executorKeepAliveTime = executorKeepAliveTime;
    }

    public void setEnableDefaultAcceptor(boolean enableDefaultAcceptor) {
        this.enableDefaultAcceptor = enableDefaultAcceptor;
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMaxProcessorPoolSize(int maxProcessorPoolSize) {
        this.maxProcessorPoolSize = maxProcessorPoolSize;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setUseHeapBuffers(boolean useHeapBuffers) {
        this.useHeapBuffers = useHeapBuffers;
    }

    public boolean isEnableMinaLogFilter() {
        return this.enableMinaLogFilter;
    }

    public void setEnableMinaLogFilter(boolean enableMinaLogFilter) {
        this.enableMinaLogFilter = enableMinaLogFilter;
    }

    public void setEnableMinaMonitor(boolean enableMinaMonitor) {
        this.enableMinaMonitor = enableMinaMonitor;
    }

    public void setMinaPollInterval(int minaPollInterval) {
        this.minaPollInterval = minaPollInterval;
    }

    public void setReaderIdleTime(int readerIdleTime) {
        this.readerIdleTime = readerIdleTime;
    }

    public String getAddress() {
        return this.addresses.toString();
    }

    public String getStatistics() {
        StringBuilder json = new StringBuilder("[Statistics{");
        if (this.stats != null) {
            json.append("cumulativeManagedSessionCount=");
            json.append(this.stats.getCumulativeManagedSessionCount());
            json.append(',');
            json.append("largestManagedSessionCount=");
            json.append(this.stats.getLargestManagedSessionCount());
            json.append(',');
            json.append("largestReadBytesThroughput=");
            json.append(this.stats.getLargestReadBytesThroughput());
            json.append(',');
            json.append("largestReadMessagesThroughput=");
            json.append(this.stats.getLargestReadMessagesThroughput());
            json.append(',');
            json.append("largestWrittenBytesThroughput=");
            json.append(this.stats.getLargestWrittenBytesThroughput());
            json.append(',');
            json.append("largestWrittenMessagesThroughput=");
            json.append(this.stats.getLargestWrittenMessagesThroughput());
            json.append(',');
            json.append("lastIoTime=");
            json.append(this.stats.getLastIoTime());
            json.append(',');
            json.append("lastReadTime=");
            json.append(this.stats.getLastReadTime());
            json.append(',');
            json.append("lastWriteTime=");
            json.append(this.stats.getLastWriteTime());
            json.append(',');
            json.append("readBytes=");
            json.append(this.stats.getReadBytes());
            json.append(',');
            json.append("readBytesThroughput=");
            json.append(this.stats.getReadBytesThroughput());
            json.append(',');
            json.append("readMessages=");
            json.append(this.stats.getReadMessages());
            json.append(',');
            json.append("readMessagesThroughput=");
            json.append(this.stats.getReadMessagesThroughput());
            json.append(',');
            json.append("scheduledWriteBytes=");
            json.append(this.stats.getScheduledWriteBytes());
            json.append(',');
            json.append("scheduledWriteMessages=");
            json.append(this.stats.getScheduledWriteMessages());
            json.append(',');
            json.append("throughputCalculationInterval=");
            json.append(this.stats.getThroughputCalculationInterval());
            json.append(',');
            json.append("throughputCalculationIntervalInMillis=");
            json.append(this.stats.getThroughputCalculationIntervalInMillis());
            json.append(',');
            json.append("writtenBytes=");
            json.append(this.stats.getWrittenBytes());
            json.append(',');
            json.append("writtenBytesThroughput=");
            json.append(this.stats.getWrittenBytesThroughput());
            json.append(',');
            json.append("writtenMessages=");
            json.append(this.stats.getWrittenMessages());
            json.append(',');
            json.append("writtenMessagesThroughput=");
            json.append(this.stats.getWrittenMessagesThroughput());
            json.append("}]");
        }
        return json.toString();
    }

    public String toString() {
        return String.format("RTMP Mina Transport %s", this.addresses.toString());
    }
}

