/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.bandwidth;

import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.api.service.IServiceCapableConnection;
import org.red5.server.stream.bandwidth.IBandwidthDetection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerClientDetection
implements IPendingServiceCallback,
IBandwidthDetection {
    private static Logger log = LoggerFactory.getLogger(ServerClientDetection.class);
    private static final double LATENCY_MAX = 1000.0;
    private static final double LATENCY_MIN = 10.0;
    private IConnection conn;
    private volatile double latency;
    private volatile double cumLatency = 1.0;
    private double kbitDown;
    private double deltaDown;
    private double deltaTime;
    private long startBytesWritten;
    private long startTime;
    private long timePassed;
    private AtomicInteger packetsSent = new AtomicInteger(0);
    private AtomicInteger packetsReceived = new AtomicInteger(0);
    private byte[] payload = new byte[1024];
    private byte[] payload1 = new byte[32768];

    @Override
    public void checkBandwidth(IConnection conn) {
        this.calculateClientBw(conn);
    }

    @Override
    public void calculateClientBw(IConnection conn) {
        log.debug("calculateClientBw: {} ", (Object)conn);
        this.conn = conn;
        Random rnd = new Random();
        rnd.nextBytes(this.payload);
        rnd.nextBytes(this.payload1);
        this.startBytesWritten = conn.getWrittenBytes();
        this.startTime = System.nanoTime();
        log.debug("Starting bandwidth check at {} ns", (Object)this.startTime);
        this.callBWCheck("");
    }

    @Override
    public void resultReceived(IPendingServiceCall call) {
        if (32 != call.getStatus()) {
            long now = System.nanoTime();
            int received = this.packetsReceived.incrementAndGet();
            log.debug("Call time stamps - write: {} read: {}", (Object)call.getWriteTime(), (Object)call.getReadTime());
            this.timePassed = (now - this.startTime) / 1000000L;
            log.debug("Received count: {} sent: {} timePassed: {} ms", new Object[]{received, this.packetsSent.get(), this.timePassed});
            switch (received) {
                case 1: {
                    this.latency = Math.max(Math.min((double)this.timePassed, 1000.0), 10.0);
                    log.debug("Receive latency: {}", (Object)this.latency);
                    log.debug("Sending first payload at {} ns", (Object)now);
                    this.callBWCheck(this.payload);
                    break;
                }
                case 2: {
                    log.debug("Sending second payload at {} ns", (Object)now);
                    this.cumLatency += 1.0;
                    this.callBWCheck(this.payload1);
                    break;
                }
                default: {
                    log.debug("Doing calculations at {} ns", (Object)now);
                    this.cumLatency += 1.0;
                    this.deltaDown = (double)((this.conn.getWrittenBytes() - this.startBytesWritten) * 8L) / 1000.0;
                    log.debug("Delta kbits: {}", (Object)this.deltaDown);
                    this.deltaTime = (double)this.timePassed - this.latency * this.cumLatency;
                    if (this.deltaTime <= 0.0) {
                        this.deltaTime = (double)this.timePassed + this.latency;
                    }
                    log.debug("Delta time: {} ms", (Object)this.deltaTime);
                    this.kbitDown = Math.round(this.deltaDown / (this.deltaTime / 1000.0));
                    log.debug("onBWDone: kbitDown: {} deltaDown: {} deltaTime: {} latency: {} ", new Object[]{this.kbitDown, this.deltaDown, this.deltaTime, this.latency});
                    this.callBWDone();
                    break;
                }
            }
        } else {
            log.debug("Pending call skipped due to being no longer connected");
        }
    }

    private void callBWCheck(Object payload) {
        if (log.isTraceEnabled()) {
            log.trace("callBWCheck: {}", payload);
        } else {
            log.debug("callBWCheck");
        }
        IConnection conn = Red5.getConnectionLocal();
        HashMap<String, Object> statsValues = new HashMap<String, Object>();
        statsValues.put("count", this.packetsReceived.get());
        statsValues.put("sent", this.packetsSent.get());
        statsValues.put("timePassed", this.timePassed);
        statsValues.put("latency", this.latency);
        statsValues.put("cumLatency", this.cumLatency);
        statsValues.put("payload", payload);
        if (conn instanceof IServiceCapableConnection) {
            log.debug("Invoking onBWCheck on the client");
            this.packetsSent.incrementAndGet();
            ((IServiceCapableConnection)conn).invoke("onBWCheck", new Object[]{statsValues}, this);
        }
    }

    private void callBWDone() {
        log.debug("callBWDone");
        IConnection conn = Red5.getConnectionLocal();
        HashMap<String, Double> statsValues = new HashMap<String, Double>();
        statsValues.put("kbitDown", this.kbitDown);
        statsValues.put("deltaDown", this.deltaDown);
        statsValues.put("deltaTime", this.deltaTime);
        statsValues.put("latency", this.latency);
        if (conn instanceof IServiceCapableConnection) {
            log.debug("Invoking onBWDone on the client");
            ((IServiceCapableConnection)conn).invoke("onBWDone", new Object[]{statsValues});
            int mbits = (int)(this.kbitDown / 1000.0 * 1000000.0);
            log.debug("Setting bandwidth to {} mbit/s", (Object)mbits);
            conn.setBandwidth(mbits);
        }
    }

    public void onServerClientBWCheck() {
        log.debug("onServerClientBWCheck");
        this.calculateClientBw(Red5.getConnectionLocal());
    }
}

