/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.net.ICommand;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.SerializeUtils;
import org.red5.server.stream.IStreamData;

public class Notify
extends BaseEvent
implements ICommand,
IStreamData<Notify>,
IStreamPacket {
    private static final long serialVersionUID = -6085848257275156569L;
    protected IServiceCall call;
    protected IoBuffer data;
    protected byte dataType = (byte)18;
    protected int transactionId = 0;
    private Map<String, Object> connectionParams;
    private String action;

    public Notify() {
        super(IEvent.Type.SERVICE_CALL);
    }

    public Notify(IoBuffer data) {
        super(IEvent.Type.STREAM_DATA);
        this.data = data;
    }

    public Notify(IoBuffer data, String action) {
        super(IEvent.Type.STREAM_DATA);
        this.data = data;
        this.action = action;
    }

    public Notify(IServiceCall call) {
        super(IEvent.Type.SERVICE_CALL);
        this.call = call;
    }

    @Override
    public byte getDataType() {
        return this.dataType;
    }

    public void setData(IoBuffer data) {
        this.data = data;
    }

    public void setCall(IServiceCall call) {
        this.call = call;
    }

    @Override
    public IServiceCall getCall() {
        return this.call;
    }

    @Override
    public IoBuffer getData() {
        return this.data;
    }

    @Override
    public int getTransactionId() {
        return this.transactionId;
    }

    protected void doRelease() {
        this.call = null;
    }

    @Override
    public Map<String, Object> getConnectionParams() {
        return this.connectionParams;
    }

    public void setConnectionParams(Map<String, Object> connectionParams) {
        this.connectionParams = connectionParams;
    }

    public void setAction(String onCueOrOnMeta) {
        this.action = onCueOrOnMeta;
    }

    public String getAction() {
        return this.action;
    }

    public String toString() {
        return this.call != null ? String.format("%s: %s", this.getClass().getSimpleName(), this.call) : (this.action != null ? String.format("%s action: %s", this.getClass().getSimpleName(), this.action) : this.getClass().getSimpleName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notify)) {
            return false;
        }
        Notify other = (Notify)obj;
        if (this.getConnectionParams() == null && other.getConnectionParams() != null) {
            return false;
        }
        if (this.getConnectionParams() != null && other.getConnectionParams() == null) {
            return false;
        }
        if (this.getConnectionParams() != null && !this.getConnectionParams().equals(other.getConnectionParams())) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        if (this.getCall() == null && other.getCall() != null) {
            return false;
        }
        if (this.getCall() != null && other.getCall() == null) {
            return false;
        }
        return this.getCall() == null || this.getCall().equals(other.getCall());
    }

    @Override
    protected void releaseInternal() {
        if (this.data != null) {
            this.data.free();
            this.data = null;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.call = (IServiceCall)in.readObject();
        this.connectionParams = (Map)in.readObject();
        this.transactionId = in.readInt();
        byte[] byteBuf = (byte[])in.readObject();
        if (byteBuf != null) {
            this.data = IoBuffer.allocate((int)0);
            this.data.setAutoExpand(true);
            SerializeUtils.ByteArrayToByteBuffer(byteBuf, this.data);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("readExternal - transactionId: {} connectionParams: {} call: {}", new Object[]{this.transactionId, this.connectionParams, this.call});
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.log.isTraceEnabled()) {
            this.log.trace("writeExternal - transactionId: {} connectionParams: {} call: {}", new Object[]{this.transactionId, this.connectionParams, this.call});
        }
        out.writeObject(this.call);
        out.writeObject(this.connectionParams);
        out.writeInt(this.transactionId);
        if (this.data != null) {
            out.writeObject(SerializeUtils.ByteBufferToByteArray(this.data));
        } else {
            out.writeObject(null);
        }
    }

    public Notify duplicate() throws IOException, ClassNotFoundException {
        Notify result = new Notify();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        this.writeExternal(oos);
        oos.close();
        byte[] buf = baos.toByteArray();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bais);
        result.readExternal(ois);
        ois.close();
        bais.close();
        result.setAction(this.getAction());
        result.setSourceType(this.sourceType);
        result.setSource(this.source);
        result.setTimestamp(this.timestamp);
        return result;
    }
}

