/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.red5.server.api.IConnection;
import org.red5.server.api.IServer;
import org.red5.server.api.listeners.IConnectionListener;
import org.red5.server.api.listeners.IScopeListener;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.style.ToStringCreator;

public class Server
implements IServer,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    protected static Logger log = LoggerFactory.getLogger(Server.class);
    private static ISchedulingService schedulingService;
    protected ConcurrentMap<String, IGlobalScope> globals = new ConcurrentHashMap<String, IGlobalScope>(1, 0.9f, 1);
    protected ConcurrentMap<String, String> mapping = new ConcurrentHashMap<String, String>(32, 0.9f, 8);
    protected ApplicationContext applicationContext;
    protected static final String SLASH = "/";
    protected static final String EMPTY = "";
    public Set<IScopeListener> scopeListeners = new CopyOnWriteArraySet<IScopeListener>();
    public Set<IConnectionListener> connectionListeners = new CopyOnWriteArraySet<IConnectionListener>();
    public long notificationDelay = 5L;

    public void setApplicationContext(ApplicationContext applicationContext) {
        log.debug("Setting application context");
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        schedulingService = (ISchedulingService)this.applicationContext.getBean("schedulingService");
    }

    public void destroy() throws Exception {
    }

    protected String getKey(String hostName, String contextPath) {
        return String.format("%s/%s", hostName == null ? EMPTY : hostName, contextPath == null ? EMPTY : contextPath);
    }

    @Override
    public IGlobalScope lookupGlobal(String hostName, String contextPath) {
        String globalName;
        log.trace("{}", (Object)this);
        log.debug("Lookup global scope - host name: {} context path: {}", (Object)hostName, (Object)contextPath);
        String key = this.getKey(hostName, contextPath);
        while (contextPath.indexOf(SLASH) != -1) {
            key = this.getKey(hostName, contextPath);
            log.trace("Check: {}", (Object)key);
            globalName = (String)this.mapping.get(key);
            if (globalName != null) {
                return this.getGlobal(globalName);
            }
            int slashIndex = contextPath.lastIndexOf(SLASH);
            contextPath = contextPath.substring(0, slashIndex);
        }
        key = this.getKey(hostName, contextPath);
        log.trace("Check host and path: {}", (Object)key);
        globalName = (String)this.mapping.get(key);
        if (globalName != null) {
            return this.getGlobal(globalName);
        }
        key = this.getKey(EMPTY, contextPath);
        log.trace("Check wildcard host with path: {}", (Object)key);
        globalName = (String)this.mapping.get(key);
        if (globalName != null) {
            return this.getGlobal(globalName);
        }
        key = this.getKey(hostName, EMPTY);
        log.trace("Check host with no path: {}", (Object)key);
        globalName = (String)this.mapping.get(key);
        if (globalName != null) {
            return this.getGlobal(globalName);
        }
        key = this.getKey(EMPTY, EMPTY);
        log.trace("Check default host, default path: {}", (Object)key);
        return this.getGlobal((String)this.mapping.get(key));
    }

    @Override
    public IGlobalScope getGlobal(String name) {
        if (name == null) {
            return null;
        }
        return (IGlobalScope)this.globals.get(name);
    }

    @Override
    public void registerGlobal(IGlobalScope scope) {
        log.trace("Registering global scope: {}", (Object)scope.getName(), (Object)scope);
        this.globals.put(scope.getName(), scope);
    }

    @Override
    public boolean addMapping(String hostName, String contextPath, String globalName) {
        log.info("Add mapping global: {} host: {} context: {}", new Object[]{globalName, hostName, contextPath});
        String key = this.getKey(hostName, contextPath);
        log.debug("Add mapping: {} => {}", (Object)key, (Object)globalName);
        return this.mapping.putIfAbsent(key, globalName) == null;
    }

    @Override
    public boolean removeMapping(String hostName, String contextPath) {
        log.info("Remove mapping host: {} context: {}", (Object)hostName, (Object)contextPath);
        String key = this.getKey(hostName, contextPath);
        log.debug("Remove mapping: {}", (Object)key);
        return this.mapping.remove(key) != null;
    }

    public boolean removeMapping(String contextPath) {
        log.info("Remove mapping context: {}", (Object)contextPath);
        String key = this.getKey(EMPTY, contextPath);
        log.debug("Remove mapping: {}", (Object)key);
        return this.mapping.remove(key) != null;
    }

    @Override
    public Map<String, String> getMappingTable() {
        return this.mapping;
    }

    @Override
    public Iterator<String> getGlobalNames() {
        return this.globals.keySet().iterator();
    }

    @Override
    public Iterator<IGlobalScope> getGlobalScopes() {
        return this.globals.values().iterator();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append(this.mapping).toString();
    }

    @Override
    public void addListener(IScopeListener listener) {
        this.scopeListeners.add(listener);
    }

    @Override
    public void addListener(IConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    @Override
    public void removeListener(IScopeListener listener) {
        this.scopeListeners.remove(listener);
    }

    @Override
    public void removeListener(IConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void notifyScopeCreated(IScope scope) {
        schedulingService.addScheduledOnceJob(this.notificationDelay, (IScheduledJob)new ScheduledNotificationJob(JobAction.CREATED, scope));
    }

    public void notifyScopeRemoved(IScope scope) {
        schedulingService.addScheduledOnceJob(this.notificationDelay, (IScheduledJob)new ScheduledNotificationJob(JobAction.REMOVED, scope));
    }

    public void notifyBasicScopeAdded(IBasicScope scope) {
        schedulingService.addScheduledOnceJob(this.notificationDelay, (IScheduledJob)new ScheduledNotificationJob(JobAction.BASIC_ADD, scope));
    }

    public void notifyBasicScopeRemoved(IBasicScope scope) {
        schedulingService.addScheduledOnceJob(this.notificationDelay, (IScheduledJob)new ScheduledNotificationJob(JobAction.BASIC_REMOVE, scope));
    }

    public void notifyConnected(IConnection conn) {
        schedulingService.addScheduledOnceJob(this.notificationDelay, (IScheduledJob)new ScheduledNotificationJob(JobAction.CONNECTED, conn));
    }

    public void notifyDisconnected(IConnection conn) {
        schedulingService.addScheduledOnceJob(this.notificationDelay, (IScheduledJob)new ScheduledNotificationJob(JobAction.DISCONNECTED, conn));
    }

    private class ScheduledNotificationJob
    implements IScheduledJob {
        private final JobAction action;
        private final Object target;

        ScheduledNotificationJob(JobAction action, Object target) {
            this.action = action;
            this.target = target;
        }

        @Override
        public void execute(ISchedulingService service) {
            switch (this.action) {
                case CREATED: {
                    for (IScopeListener listener : Server.this.scopeListeners) {
                        listener.notifyScopeCreated((IScope)this.target);
                    }
                    break;
                }
                case REMOVED: {
                    for (IScopeListener listener : Server.this.scopeListeners) {
                        listener.notifyScopeRemoved((IScope)this.target);
                    }
                    break;
                }
                case BASIC_ADD: {
                    for (IScopeListener listener : Server.this.scopeListeners) {
                        listener.notifyBasicScopeAdded((IBasicScope)this.target);
                    }
                    break;
                }
                case BASIC_REMOVE: {
                    for (IScopeListener listener : Server.this.scopeListeners) {
                        listener.notifyBasicScopeRemoved((IBasicScope)this.target);
                    }
                    break;
                }
                case CONNECTED: {
                    for (IConnectionListener listener : Server.this.connectionListeners) {
                        listener.notifyConnected((IConnection)this.target);
                    }
                    break;
                }
                case DISCONNECTED: {
                    for (IConnectionListener listener : Server.this.connectionListeners) {
                        listener.notifyDisconnected((IConnection)this.target);
                    }
                    break;
                }
            }
        }
    }

    private static enum JobAction {
        CREATED,
        REMOVED,
        CONNECTED,
        DISCONNECTED,
        BASIC_ADD,
        BASIC_REMOVE;

    }
}

