/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.red5.server.api.service.IServiceCall;

public class Call
implements IServiceCall,
Externalizable {
    private static final long serialVersionUID = -3699712251588013875L;
    public static final byte STATUS_PENDING = 1;
    public static final byte STATUS_SUCCESS_RESULT = 2;
    public static final byte STATUS_SUCCESS_NULL = 3;
    public static final byte STATUS_SUCCESS_VOID = 4;
    public static final byte STATUS_SERVICE_NOT_FOUND = 16;
    public static final byte STATUS_METHOD_NOT_FOUND = 17;
    public static final byte STATUS_ACCESS_DENIED = 18;
    public static final byte STATUS_INVOCATION_EXCEPTION = 19;
    public static final byte STATUS_GENERAL_EXCEPTION = 20;
    public static final byte STATUS_APP_SHUTTING_DOWN = 21;
    public static final byte STATUS_NOT_CONNECTED = 32;
    protected String serviceName;
    protected String serviceMethodName;
    protected Object[] arguments = null;
    protected byte status = 1;
    protected Exception exception;
    private long readTime;
    private long writeTime;

    public Call() {
    }

    public Call(String method) {
        this.serviceMethodName = method;
    }

    public Call(String method, Object[] args) {
        this.serviceMethodName = method;
        this.arguments = args;
    }

    public Call(String name, String method, Object[] args) {
        this.serviceName = name;
        this.serviceMethodName = method;
        this.arguments = args;
    }

    @Override
    public boolean isSuccess() {
        return this.status == 2 || this.status == 3 || this.status == 4;
    }

    @Override
    public String getServiceMethodName() {
        return this.serviceMethodName;
    }

    public void setServiceMethodName(String serviceMethodName) {
        this.serviceMethodName = serviceMethodName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] args) {
        this.arguments = args;
    }

    @Override
    public byte getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(byte status) {
        this.status = status;
    }

    @Override
    public long getReadTime() {
        return this.readTime;
    }

    @Override
    public long getWriteTime() {
        return this.writeTime;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Service: ");
        sb.append(this.serviceName);
        sb.append(" Method: ");
        sb.append(this.serviceMethodName);
        if (this.arguments != null) {
            sb.append(" Num Params: ");
            sb.append(this.arguments.length);
            for (int i = 0; i < this.arguments.length; ++i) {
                sb.append(' ');
                sb.append(i);
                sb.append(": ");
                sb.append(this.arguments[i]);
            }
        } else {
            sb.append(" No params");
        }
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readTime = System.currentTimeMillis();
        this.serviceName = (String)in.readObject();
        this.serviceMethodName = (String)in.readObject();
        this.arguments = (Object[])in.readObject();
        this.status = in.readByte();
        this.exception = (Exception)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeTime = System.currentTimeMillis();
        out.writeObject(this.serviceName);
        out.writeObject(this.serviceMethodName);
        out.writeObject(this.arguments);
        out.writeByte(this.status);
        out.writeObject(this.exception);
    }
}

