/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.red5.server.api.Red5;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.message.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public final class ReceivedMessageTask
implements Callable<Packet> {
    private static final Logger log = LoggerFactory.getLogger(ReceivedMessageTask.class);
    private final RTMPConnection conn;
    private final IRTMPHandler handler;
    private final String sessionId;
    private Packet packet;
    private long packetNumber;
    private final AtomicBoolean processing = new AtomicBoolean(false);
    private Thread taskThread;
    private ScheduledFuture<Runnable> deadlockFuture;

    public ReceivedMessageTask(String sessionId, Packet packet, IRTMPHandler handler, RTMPConnection conn) {
        this.sessionId = sessionId;
        this.packet = packet;
        this.handler = handler;
        this.conn = conn;
    }

    @Override
    public Packet call() throws Exception {
        this.taskThread = Thread.currentThread();
        Red5.setConnectionLocal(this.conn);
        try {
            this.handler.messageReceived(this.conn, this.packet);
            this.packet.setProcessed(true);
        }
        finally {
            Red5.setConnectionLocal(null);
        }
        if (log.isDebugEnabled()) {
            log.debug("Processing message for {} is processed: {} packet #{}", new Object[]{this.sessionId, this.packet.isProcessed(), this.packetNumber});
        }
        return this.packet;
    }

    public void runDeadlockFuture(Runnable deadlockGuardTask) {
        if (this.deadlockFuture == null) {
            ThreadPoolTaskScheduler deadlockGuard = this.conn.getDeadlockGuardScheduler();
            if (deadlockGuard != null) {
                try {
                    this.deadlockFuture = deadlockGuard.schedule(deadlockGuardTask, new Date(this.packet.getExpirationTime()));
                }
                catch (TaskRejectedException e) {
                    log.warn("DeadlockGuard task is rejected for {}", (Object)this.sessionId, (Object)e);
                }
            } else {
                log.debug("Deadlock guard is null for {}", (Object)this.sessionId);
            }
        } else {
            log.warn("Deadlock future is already create for {}", (Object)this.sessionId);
        }
    }

    public void cancelDeadlockFuture() {
        if (this.deadlockFuture != null) {
            this.deadlockFuture.cancel(true);
        }
    }

    public boolean setProcessing() {
        return this.processing.compareAndSet(false, true);
    }

    public long getPacketNumber() {
        return this.packetNumber;
    }

    public void setPacketNumber(long packetNumber) {
        this.packetNumber = packetNumber;
    }

    public Packet getPacket() {
        return this.packet;
    }

    public Thread getTaskThread() {
        return this.taskThread;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        result = 31 * result + this.packet.getHeader().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReceivedMessageTask other = (ReceivedMessageTask)obj;
        if (this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId)) {
            return false;
        }
        return this.packet.getHeader().equals(other.packet.getHeader());
    }

    public String toString() {
        return "[sessionId: " + this.sessionId + "; packetNumber: " + this.packetNumber + "; processing: " + this.processing.get() + "]";
    }
}

