/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.Red5;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.ISingleItemSubscriberStream;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.OperationNotSupportedException;
import org.red5.server.api.stream.StreamState;
import org.red5.server.stream.AbstractClientStream;
import org.red5.server.stream.IConsumerService;
import org.red5.server.stream.IProviderService;
import org.red5.server.stream.PlayEngine;
import org.red5.server.stream.StreamNotFoundException;
import org.slf4j.Logger;

public class SingleItemSubscriberStream
extends AbstractClientStream
implements ISingleItemSubscriberStream {
    private static final Logger log = Red5LoggerFactory.getLogger(SingleItemSubscriberStream.class);
    protected ISchedulingService schedulingService;
    protected Set<String> jobs = new HashSet<String>(1);
    protected int bufferCheckInterval = 0;
    protected int underrunTrigger = 10;
    protected long creationTime = System.currentTimeMillis();
    private volatile IPlayItem item;
    protected PlayEngine engine;

    @Override
    public void setPlayItem(IPlayItem item) {
        this.item = item;
    }

    @Override
    public void play() throws IOException {
        try {
            this.engine.play(this.item);
        }
        catch (StreamNotFoundException streamNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void pause(int position) {
        try {
            this.engine.pause(position);
        }
        catch (IllegalStateException e) {
            log.debug("pause caught an IllegalStateException");
        }
    }

    @Override
    public void resume(int position) {
        try {
            this.engine.resume(position);
        }
        catch (IllegalStateException e) {
            log.debug("resume caught an IllegalStateException");
        }
    }

    @Override
    public void stop() {
        try {
            this.engine.stop();
        }
        catch (IllegalStateException e) {
            log.debug("stop caught an IllegalStateException");
        }
    }

    @Override
    public void seek(int position) throws OperationNotSupportedException {
        try {
            this.engine.seek(position);
        }
        catch (IllegalStateException e) {
            log.debug("seek caught an IllegalStateException");
        }
    }

    @Override
    public boolean isPaused() {
        return this.state.get() == StreamState.PAUSED;
    }

    @Override
    public void receiveVideo(boolean receive) {
        boolean receiveVideo = this.engine.receiveVideo(receive);
        if (!receiveVideo && receive) {
            this.seekToCurrentPlayback();
        }
    }

    @Override
    public void receiveAudio(boolean receive) {
        boolean receiveAudio = this.engine.receiveAudio(receive);
        if (receiveAudio && !receive) {
            this.engine.sendBlankAudio(true);
        } else if (!receiveAudio && receive) {
            this.seekToCurrentPlayback();
        }
    }

    PlayEngine createEngine(ISchedulingService schedulingService, IConsumerService consumerService, IProviderService providerService) {
        this.engine = new PlayEngine.Builder(this, schedulingService, consumerService, providerService).build();
        return this.engine;
    }

    public void setBufferCheckInterval(int bufferCheckInterval) {
        this.bufferCheckInterval = bufferCheckInterval;
    }

    public void setUnderrunTrigger(int underrunTrigger) {
        this.underrunTrigger = underrunTrigger;
    }

    @Override
    public void start() {
        if (this.engine == null) {
            IScope scope = this.getScope();
            if (scope != null) {
                IContext ctx = scope.getContext();
                this.schedulingService = ctx.hasBean("schedulingService") ? (ISchedulingService)ctx.getBean("schedulingService") : (ISchedulingService)scope.getParent().getContext().getBean("schedulingService");
                IConsumerService consumerService = null;
                consumerService = ctx.hasBean("consumerService") ? (IConsumerService)ctx.getBean("consumerService") : (IConsumerService)scope.getParent().getContext().getBean("consumerService");
                IProviderService providerService = null;
                providerService = ctx.hasBean("providerService") ? (IProviderService)ctx.getBean("providerService") : (IProviderService)scope.getParent().getContext().getBean("providerService");
                this.engine = new PlayEngine.Builder(this, this.schedulingService, consumerService, providerService).build();
            } else {
                log.info("Scope was null on start");
            }
        }
        this.engine.setBufferCheckInterval(this.bufferCheckInterval);
        this.engine.setUnderrunTrigger(this.underrunTrigger);
        this.engine.start();
        this.onChange(StreamState.STARTED, new Object[0]);
    }

    @Override
    public void close() {
        this.engine.close();
        this.onChange(StreamState.CLOSED, new Object[0]);
        if (this.schedulingService != null && !this.jobs.isEmpty()) {
            for (String jobName : this.jobs) {
                this.schedulingService.removeScheduledJob(jobName);
            }
            this.jobs.clear();
        }
    }

    @Override
    public void onChange(StreamState state, final Object ... changed) {
        Notifier notifier = null;
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        switch (state) {
            case SEEK: {
                if (handler == null) break;
                notifier = new Notifier(this, this, handler){

                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        IPlayItem item = (IPlayItem)changed[0];
                        int position = (Integer)changed[1];
                        try {
                            this.handler.streamPlayItemSeek(this.stream, item, position);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamPlayItemSeek", t);
                        }
                        Red5.setConnectionLocal(null);
                    }
                };
                break;
            }
            case PAUSED: {
                this.setState(StreamState.PAUSED);
                if (handler == null) break;
                notifier = new Notifier(this, this, handler){

                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        IPlayItem item = (IPlayItem)changed[0];
                        int position = (Integer)changed[1];
                        try {
                            this.handler.streamPlayItemPause(this.stream, item, position);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamPlayItemPause", t);
                        }
                        Red5.setConnectionLocal(null);
                    }
                };
                break;
            }
            case RESUMED: {
                this.setState(StreamState.PLAYING);
                if (handler == null) break;
                notifier = new Notifier(this, this, handler){

                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        IPlayItem item = (IPlayItem)changed[0];
                        int position = (Integer)changed[1];
                        try {
                            this.handler.streamPlayItemResume(this.stream, item, position);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamPlayItemResume", t);
                        }
                        Red5.setConnectionLocal(null);
                    }
                };
                break;
            }
            case PLAYING: {
                if (handler == null) break;
                notifier = new Notifier(this, this, handler){

                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        IPlayItem item = (IPlayItem)changed[0];
                        boolean isLive = (Boolean)changed[1];
                        try {
                            this.handler.streamPlayItemPlay(this.stream, item, isLive);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamPlayItemPlay", t);
                        }
                        Red5.setConnectionLocal(null);
                    }
                };
                break;
            }
            case CLOSED: {
                if (handler == null) break;
                notifier = new Notifier(this, this, handler){

                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        try {
                            this.handler.streamSubscriberClose(this.stream);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamSubscriberClose", t);
                        }
                        Red5.setConnectionLocal(null);
                    }
                };
                break;
            }
            case STARTED: {
                if (handler == null) break;
                notifier = new Notifier(this, this, handler){

                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        try {
                            this.handler.streamSubscriberStart(this.stream);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamSubscriberStart", t);
                        }
                        Red5.setConnectionLocal(null);
                    }
                };
                break;
            }
            case STOPPED: {
                this.setState(StreamState.STOPPED);
                if (handler == null) break;
                notifier = new Notifier(this, this, handler){

                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        IPlayItem item = (IPlayItem)changed[0];
                        try {
                            this.handler.streamPlayItemStop(this.stream, item);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamPlaylistItemStop", t);
                        }
                        Red5.setConnectionLocal(null);
                    }
                };
                break;
            }
        }
        if (notifier != null) {
            notifier.setConnection(Red5.getConnectionLocal());
            this.scheduleOnceJob(notifier);
        }
    }

    private void seekToCurrentPlayback() {
        if (this.engine.isPullMode()) {
            try {
                long delta = System.currentTimeMillis() - this.engine.getPlaybackStart();
                this.engine.seek((int)delta);
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                // empty catch block
            }
        }
    }

    @Override
    public String scheduleOnceJob(IScheduledJob job) {
        String jobName = this.schedulingService.addScheduledOnceJob(10L, job);
        return jobName;
    }

    @Override
    public String scheduleWithFixedDelay(IScheduledJob job, int interval) {
        String jobName = this.schedulingService.addScheduledJob(interval, job);
        this.jobs.add(jobName);
        return jobName;
    }

    @Override
    public void cancelJob(String jobName) {
        this.schedulingService.removeScheduledJob(jobName);
    }

    public class Notifier
    implements IScheduledJob {
        ISingleItemSubscriberStream stream;
        IStreamAwareScopeHandler handler;
        IConnection conn;

        public Notifier(ISingleItemSubscriberStream stream, IStreamAwareScopeHandler handler) {
            log.trace("Notifier - stream: {} handler: {}", (Object)stream, (Object)handler);
            this.stream = stream;
            this.handler = handler;
        }

        public void setConnection(IConnection conn) {
            this.conn = conn;
        }

        @Override
        public void execute(ISchedulingService service) {
        }
    }
}

