/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.IKeyFrameMetaCache;
import org.red5.server.api.IConnection;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IStreamFilenameGenerator;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.net.rtmp.event.Aggregate;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.CachedEvent;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.stream.DefaultStreamFilenameGenerator;
import org.red5.server.stream.IRecordingListener;
import org.red5.server.stream.consumer.FileConsumer;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class RecordingListener
implements IRecordingListener {
    private static final Logger log = LoggerFactory.getLogger(RecordingListener.class);
    private ISchedulingService scheduler;
    private String eventQueueJobName;
    private AtomicBoolean recording = new AtomicBoolean(false);
    private boolean appending;
    private FileConsumer recordingConsumer;
    private String fileName;
    private final BlockingQueue<CachedEvent> queue = new LinkedBlockingQueue<CachedEvent>(8192);
    private EventQueueJob eqj;

    public static File getRecordFile(IScope scope, String name) {
        IStreamFilenameGenerator generator = (IStreamFilenameGenerator)ScopeUtils.getScopeService(scope, IStreamFilenameGenerator.class, DefaultStreamFilenameGenerator.class);
        String fileName = generator.generateFilename(scope, name, ".flv", IStreamFilenameGenerator.GenerationType.RECORD);
        File file = null;
        if (generator.resolvesToAbsolutePath()) {
            file = new File(fileName);
        } else {
            Resource resource = scope.getContext().getResource(fileName);
            if (resource.exists()) {
                try {
                    file = resource.getFile();
                    log.debug("File exists: {} writable: {}", (Object)file.exists(), (Object)file.canWrite());
                }
                catch (IOException ioe) {
                    log.error("File error: {}", (Throwable)ioe);
                }
            } else {
                String appScopeName = ScopeUtils.findApplication(scope).getName();
                file = new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, fileName));
            }
        }
        return file;
    }

    @Override
    public boolean init(IConnection conn, String name, boolean isAppend) {
        return this.init(conn.getScope(), name, isAppend);
    }

    @Override
    public boolean init(IScope scope, String name, boolean isAppend) {
        File file = RecordingListener.getRecordFile(scope, name);
        if (file != null) {
            if (!isAppend) {
                if (file.exists() && !file.delete()) {
                    log.warn("Existing file: {} could not be deleted", (Object)file.getName());
                    return false;
                }
            } else if (file.exists()) {
                this.appending = true;
            } else {
                isAppend = false;
            }
            if (!file.exists()) {
                File tmp;
                String path = file.getAbsolutePath();
                int slashPos = path.lastIndexOf(File.separator);
                if (slashPos != -1) {
                    path = path.substring(0, slashPos);
                }
                if (!(tmp = new File(path)).isDirectory()) {
                    tmp.mkdirs();
                }
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    log.warn("New recording file could not be created for: {}", (Object)file.getName(), (Object)e);
                    return false;
                }
            }
            if (log.isDebugEnabled()) {
                try {
                    log.debug("Recording file: {}", (Object)file.getCanonicalPath());
                }
                catch (IOException e) {
                    log.warn("Exception getting file path", (Throwable)e);
                }
            }
            if (scope.getContext().hasBean("keyframe.cache")) {
                IKeyFrameMetaCache keyFrameCache = (IKeyFrameMetaCache)scope.getContext().getBean("keyframe.cache");
                keyFrameCache.removeKeyFrameMeta(file);
            }
            if (scope.getContext().hasBean("fileConsumer")) {
                log.debug("Context contains a file consumer");
                this.recordingConsumer = (FileConsumer)scope.getContext().getBean("fileConsumer");
                this.recordingConsumer.setScope(scope);
                this.recordingConsumer.setFile(file);
            } else {
                log.debug("Context does not contain a file consumer, using direct instance");
                this.recordingConsumer = new FileConsumer(scope, file);
            }
            if (isAppend) {
                this.recordingConsumer.setMode("append");
            } else {
                this.recordingConsumer.setMode("record");
            }
            this.setFileName(file.getName());
            this.scheduler = (ISchedulingService)scope.getParent().getContext().getBean("schedulingService");
            this.recording.set(true);
        } else {
            log.warn("Record file is null");
        }
        return this.recording.get();
    }

    @Override
    public void start() {
        this.eqj = new EventQueueJob();
        this.eventQueueJobName = this.scheduler.addScheduledJob(3000, this.eqj);
    }

    @Override
    public void stop() {
        if (this.recording.compareAndSet(true, false)) {
            this.scheduler.removeScheduledJob(this.eventQueueJobName);
            if (this.queue.isEmpty()) {
                log.debug("Event queue was empty on stop");
            } else {
                if (!this.eqj.processing.get()) {
                    log.debug("Event queue was not empty on stop and it's not processing, processing...");
                    do {
                        this.processQueue();
                    } while (!this.queue.isEmpty());
                } else {
                    log.debug("Event queue was not empty on stop but it's in processing, waiting...");
                    while (!this.queue.isEmpty()) {
                    }
                }
                log.debug("Processing done, event queue empty, moving on");
            }
            this.recordingConsumer.uninit();
        } else {
            log.debug("Recording listener was already stopped");
        }
    }

    @Override
    public void packetReceived(IBroadcastStream stream, IStreamPacket packet) {
        if (this.recording.get()) {
            CachedEvent event = new CachedEvent();
            event.setData(packet.getData().duplicate());
            event.setDataType(packet.getDataType());
            event.setReceivedTime(System.currentTimeMillis());
            event.setTimestamp(packet.getTimestamp());
            if (!this.queue.add(event)) {
                log.debug("Event packet not added to recording queue");
            }
        } else {
            log.info("A packet was received by recording listener, but it's not recording anymore. {}", (Object)stream.getPublishedName());
        }
    }

    private void processQueue() {
        try {
            BaseEvent event = null;
            RTMPMessage message = null;
            CachedEvent cachedEvent = (CachedEvent)this.queue.poll();
            if (cachedEvent != null) {
                byte dataType = cachedEvent.getDataType();
                IoBuffer buffer = cachedEvent.getData();
                int bufferLimit = buffer.limit();
                if (bufferLimit > 0) {
                    switch (dataType) {
                        case 22: {
                            event = new Aggregate(buffer);
                            event.setTimestamp(cachedEvent.getTimestamp());
                            message = RTMPMessage.build(event);
                            break;
                        }
                        case 8: {
                            event = new AudioData(buffer);
                            event.setTimestamp(cachedEvent.getTimestamp());
                            message = RTMPMessage.build(event);
                            break;
                        }
                        case 9: {
                            event = new VideoData(buffer);
                            event.setTimestamp(cachedEvent.getTimestamp());
                            message = RTMPMessage.build(event);
                            break;
                        }
                        default: {
                            event = new Notify(buffer);
                            event.setTimestamp(cachedEvent.getTimestamp());
                            message = RTMPMessage.build(event);
                        }
                    }
                    this.recordingConsumer.pushMessage(null, message);
                } else if (bufferLimit == 0 && dataType == 8) {
                    log.debug("Stream data size was 0, sending empty audio message");
                    event = new AudioData(IoBuffer.allocate((int)0));
                    event.setTimestamp(cachedEvent.getTimestamp());
                    message = RTMPMessage.build(event);
                    this.recordingConsumer.pushMessage(null, message);
                } else {
                    log.debug("Stream data size was 0, recording pipe will not be notified");
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception while pushing to consumer", (Throwable)e);
        }
    }

    @Override
    public boolean isRecording() {
        return this.recording.get();
    }

    @Override
    public boolean isAppending() {
        return this.appending;
    }

    @Override
    public FileConsumer getFileConsumer() {
        return this.recordingConsumer;
    }

    @Override
    public void setFileConsumer(FileConsumer recordingConsumer) {
        this.recordingConsumer = recordingConsumer;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        log.debug("File name: {}", (Object)fileName);
        this.fileName = fileName;
    }

    private class EventQueueJob
    implements IScheduledJob {
        public AtomicBoolean processing = new AtomicBoolean(false);

        private EventQueueJob() {
        }

        @Override
        public void execute(ISchedulingService service) {
            if (this.processing.compareAndSet(false, true)) {
                if (log.isTraceEnabled()) {
                    log.trace("Event queue size: {}", (Object)RecordingListener.this.queue.size());
                }
                try {
                    try {
                        if (!RecordingListener.this.queue.isEmpty()) {
                            while (!RecordingListener.this.queue.isEmpty()) {
                                if (log.isTraceEnabled()) {
                                    log.trace("Taking one more item from queue, size: {}", (Object)RecordingListener.this.queue.size());
                                }
                                RecordingListener.this.processQueue();
                            }
                        } else {
                            log.trace("Nothing to record");
                        }
                    }
                    catch (Exception e) {
                        log.error("Error processing queue", (Throwable)e);
                        this.processing.set(false);
                    }
                }
                finally {
                    this.processing.set(false);
                }
            }
        }
    }
}

