/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.codec;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.red5.server.api.Red5;
import org.red5.server.net.IConnectionManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMPProtocolEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPMinaProtocolEncoder
extends ProtocolEncoderAdapter {
    protected static Logger log = LoggerFactory.getLogger(RTMPMinaProtocolEncoder.class);
    private RTMPProtocolEncoder encoder = new RTMPProtocolEncoder();
    private int targetChunkSize = 2048;

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws ProtocolCodecException {
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        log.trace("Session id: {}", (Object)sessionId);
        if (!session.containsAttribute((Object)"rtmp.handshake")) {
            IConnectionManager connManager = (IConnectionManager)((WeakReference)session.getAttribute((Object)"rtmp.connection.manager")).get();
            RTMPConnection conn = (RTMPConnection)connManager.getConnectionBySessionId(sessionId);
            if (conn != null) {
                RTMPConnection localConn;
                block20: {
                    localConn = (RTMPConnection)Red5.getConnectionLocal();
                    if (!conn.equals(localConn)) {
                        if (localConn != null) {
                            log.debug("Connection local ({}) didn't match io session ({})", (Object)localConn.getSessionId(), (Object)sessionId);
                        }
                        Red5.setConnectionLocal(conn);
                    }
                    Boolean interrupted = false;
                    try {
                        IoBuffer buf;
                        IoBuffer ioBuffer = buf = message instanceof IoBuffer ? (IoBuffer)message : this.encoder.encode(message);
                        if (buf != null) {
                            int requestedWriteChunkSize = conn.getState().getWriteChunkSize();
                            log.trace("Requested chunk size: {} target chunk size: {}", (Object)requestedWriteChunkSize, (Object)this.targetChunkSize);
                            if (buf.remaining() <= this.targetChunkSize * 2) {
                                log.trace("Writing output data");
                                out.write((Object)buf);
                            } else {
                                int sentChunks = Chunker.chunkAndWrite(out, buf, requestedWriteChunkSize, this.targetChunkSize);
                                log.trace("Wrote {} chunks", (Object)sentChunks);
                            }
                        } else {
                            log.trace("Response buffer was null after encoding");
                        }
                    }
                    catch (InterruptedException ex) {
                        log.error("InterruptedException during encode", (Throwable)ex);
                        interrupted = true;
                        if (interrupted.booleanValue()) {
                            log.info("Released lock after interruption. session {}", (Object)conn.getSessionId());
                        }
                        break block20;
                    }
                    catch (Exception ex) {
                        try {
                            log.error("Exception during encode", (Throwable)ex);
                            break block20;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (interrupted.booleanValue()) {
                                log.info("Released lock after interruption. session {}", (Object)conn.getSessionId());
                            }
                        }
                    }
                    if (!interrupted.booleanValue()) break block20;
                    log.info("Released lock after interruption. session {}", (Object)conn.getSessionId());
                }
                if (localConn != null) {
                    Red5.setConnectionLocal(localConn);
                }
            } else {
                log.debug("Connection is no longer available for encoding, may have been closed already");
            }
        } else {
            log.debug("No-op due to handshake presence");
        }
    }

    public void setEncoder(RTMPProtocolEncoder encoder) {
        this.encoder = encoder;
    }

    public RTMPProtocolEncoder getEncoder() {
        return this.encoder;
    }

    public void setBaseTolerance(long baseTolerance) {
        this.encoder.setBaseTolerance(baseTolerance);
    }

    public void setDropLiveFuture(boolean dropLiveFuture) {
        this.encoder.setDropLiveFuture(dropLiveFuture);
    }

    public int getTargetChunkSize() {
        return this.targetChunkSize;
    }

    public void setTargetChunkSize(int targetChunkSize) {
        this.targetChunkSize = targetChunkSize;
    }

    private static final class Chunker {
        private Chunker() {
        }

        public static LinkedList<IoBuffer> chunk(IoBuffer message, int chunkSize, int desiredSize) {
            LinkedList<IoBuffer> chunks = new LinkedList<IoBuffer>();
            int targetSize = desiredSize > chunkSize ? desiredSize : chunkSize;
            int limit = message.limit();
            do {
                int length = 0;
                int pos = message.position();
                while (length < targetSize && pos < limit) {
                    byte basicHeader = message.get(pos);
                    pos += (length += Chunker.getDataSize(basicHeader) + chunkSize);
                }
                int remaining = message.remaining();
                log.trace("Length: {} remaining: {} pos+len: {} limit: {}", new Object[]{length, remaining, message.position() + length, limit});
                if (length > remaining) {
                    length = remaining;
                }
                chunks.add(message.getSlice(length));
            } while (message.hasRemaining());
            return chunks;
        }

        public static int chunkAndWrite(ProtocolEncoderOutput out, IoBuffer message, int chunkSize, int desiredSize) {
            int sentChunks = 0;
            int targetSize = desiredSize > chunkSize ? desiredSize : chunkSize;
            int limit = message.limit();
            do {
                int length = 0;
                int pos = message.position();
                while (length < targetSize && pos < limit) {
                    byte basicHeader = message.get(pos);
                    pos += (length += Chunker.getDataSize(basicHeader) + chunkSize);
                }
                int remaining = message.remaining();
                log.trace("Length: {} remaining: {} pos+len: {} limit: {}", new Object[]{length, remaining, message.position() + length, limit});
                if (length > remaining) {
                    length = remaining;
                }
                out.write((Object)message.getSlice(length));
                ++sentChunks;
            } while (message.hasRemaining());
            return sentChunks;
        }

        private static int getDataSize(byte basicHeader) {
            int streamId = basicHeader & 0x3F;
            int headerType = basicHeader >> 6 & 3;
            int size = 0;
            switch (headerType) {
                case 0: {
                    size = 12;
                    break;
                }
                case 1: {
                    size = 8;
                    break;
                }
                case 2: {
                    size = 4;
                    break;
                }
                default: {
                    size = 1;
                }
            }
            if (streamId == 0) {
                ++size;
            } else if (streamId == 1) {
                size += 2;
            }
            return size;
        }
    }
}

