/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.beans.ConstructorProperties;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.red5.server.BaseConnection;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.service.IServiceCapableConnection;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.api.stream.IPlaylistSubscriberStream;
import org.red5.server.api.stream.ISingleItemSubscriberStream;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.IStreamService;
import org.red5.server.exception.ClientRejectedException;
import org.red5.server.net.protocol.RTMPDecodeState;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.DeferredResult;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.IReceivedMessageTaskQueueListener;
import org.red5.server.net.rtmp.ReceivedMessageTask;
import org.red5.server.net.rtmp.ReceivedMessageTaskQueue;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.ClientBW;
import org.red5.server.net.rtmp.event.ClientInvokeEvent;
import org.red5.server.net.rtmp.event.ClientNotifyEvent;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.ServerBW;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.service.Call;
import org.red5.server.service.PendingCall;
import org.red5.server.so.FlexSharedObjectMessage;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.SharedObjectMessage;
import org.red5.server.stream.AbstractClientStream;
import org.red5.server.stream.ClientBroadcastStream;
import org.red5.server.stream.OutputStream;
import org.red5.server.stream.PlaylistSubscriberStream;
import org.red5.server.stream.SingleItemSubscriberStream;
import org.red5.server.stream.StreamService;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureTask;

public abstract class RTMPConnection
extends BaseConnection
implements IStreamCapableConnection,
IServiceCapableConnection,
IReceivedMessageTaskQueueListener {
    private static Logger log = LoggerFactory.getLogger(RTMPConnection.class);
    private static boolean isTrace = log.isTraceEnabled();
    private static boolean isDebug = log.isDebugEnabled();
    public static final String RTMP_SESSION_ID = "rtmp.sessionid";
    public static final String RTMP_HANDSHAKE = "rtmp.handshake";
    public static final String RTMP_BUFFER = "rtmp.buffer";
    public static final String RTMP_CONN_MANAGER = "rtmp.connection.manager";
    public static final Object RTMP_HANDLER = "rtmp.handler";
    public static final byte RTMP_NON_ENCRYPTED = 3;
    public static final byte RTMP_ENCRYPTED = 6;
    public static final byte RTMP_ENCRYPTED_XTEA = 8;
    public static final byte RTMP_ENCRYPTED_BLOWFISH = 9;
    public static final byte RTMP_ENCRYPTED_UNK = 10;
    public static final String RTMPE_CIPHER_IN = "rtmpe.cipher.in";
    public static final String RTMPE_CIPHER_OUT = "rtmpe.cipher.out";
    public static final double MAX_RESERVED_STREAMS = 320.0;
    private int channelsInitalCapacity = 3;
    private int channelsConcurrencyLevel = 1;
    private int streamsInitalCapacity = 1;
    private int streamsConcurrencyLevel = 1;
    private int pendingCallsInitalCapacity = 3;
    private int pendingCallsConcurrencyLevel = 1;
    private int reservedStreamsInitalCapacity = 1;
    private int reservedStreamsConcurrencyLevel = 1;
    protected transient ConcurrentMap<Integer, Channel> channels = new ConcurrentHashMap<Integer, Channel>(this.channelsInitalCapacity, 0.9f, this.channelsConcurrencyLevel);
    protected final transient ConcurrentMap<Integer, ReceivedMessageTaskQueue> tasksByStreams = new ConcurrentHashMap<Integer, ReceivedMessageTaskQueue>(this.streamsInitalCapacity, 0.9f, this.streamsConcurrencyLevel);
    protected transient ConcurrentMap<Number, IClientStream> streams = new ConcurrentHashMap<Number, IClientStream>(this.streamsInitalCapacity, 0.9f, this.streamsConcurrencyLevel);
    protected transient Set<Number> reservedStreams = Collections.newSetFromMap(new ConcurrentHashMap(this.reservedStreamsInitalCapacity, 0.9f, this.reservedStreamsConcurrencyLevel));
    protected AtomicInteger transactionId = new AtomicInteger(1);
    protected transient ConcurrentMap<Integer, IPendingServiceCall> pendingCalls = new ConcurrentHashMap<Integer, IPendingServiceCall>(this.pendingCallsInitalCapacity, 0.75f, this.pendingCallsConcurrencyLevel);
    protected transient CopyOnWriteArraySet<DeferredResult> deferredResults = new CopyOnWriteArraySet();
    protected AtomicInteger lastPingRoundTripTime = new AtomicInteger(-1);
    protected AtomicLong lastPingSentOn = new AtomicLong(0L);
    protected AtomicLong lastPongReceivedOn = new AtomicLong(0L);
    protected transient IRTMPHandler handler;
    protected volatile int pingInterval = 5000;
    protected volatile int maxInactivity = 60000;
    protected long bytesReadInterval = 0x100000L;
    protected long nextBytesRead = 0x100000L;
    protected AtomicLong clientBytesRead = new AtomicLong(0L);
    protected transient ConcurrentMap<Number, AtomicInteger> pendingVideos = new ConcurrentHashMap<Number, AtomicInteger>(1, 0.9f, 1);
    private AtomicInteger usedStreams = new AtomicInteger(0);
    private transient ConcurrentMap<Number, Integer> streamBuffers = new ConcurrentHashMap<Number, Integer>(1, 0.9f, 1);
    private int maxHandshakeTimeout = 10000;
    protected long maxHandlingTimeout = 500L;
    protected int limitType = 0;
    protected RTMP state = new RTMP();
    protected transient Semaphore decoderLock = new Semaphore(1, true);
    protected transient Semaphore encoderLock = new Semaphore(1, true);
    protected transient RTMPDecodeState decoderState;
    protected transient ThreadPoolTaskScheduler scheduler;
    protected transient ThreadPoolTaskExecutor executor;
    protected transient ThreadPoolTaskScheduler deadlockGuardScheduler;
    protected final AtomicBoolean running;
    protected final AtomicInteger timer = new AtomicInteger(0);
    protected final AtomicBoolean closing = new AtomicBoolean(false);
    protected final AtomicLong packetSequence = new AtomicLong();
    private Integer executorQueueSizeToDropAudioPackets = 0;
    private final AtomicInteger currentQueueSize = new AtomicInteger();
    protected ScheduledFuture<?> waitForHandshakeTask;
    protected ScheduledFuture<?> keepAliveTask;
    protected transient ExecutorService receivedPacketExecutor = Executors.newSingleThreadExecutor();
    protected transient Future<?> receivedPacketFuture;
    protected LinkedTransferQueue<Packet> receivedPacketQueue = new LinkedTransferQueue();

    @ConstructorProperties(value={"type"})
    public RTMPConnection(String type) {
        super(type);
        this.decoderState = new RTMPDecodeState(this.getSessionId());
        this.running = new AtomicBoolean(false);
    }

    public int getId() {
        return this.client != null ? this.client.getId().hashCode() : -1;
    }

    @Deprecated
    public void setId(int clientId) {
        log.warn("Setting of a client id is deprecated, use IClient to manipulate the id", (Throwable)new Exception("RTMPConnection.setId is deprecated"));
    }

    public void setHandler(IRTMPHandler handler) {
        this.handler = handler;
    }

    public IRTMPHandler getHandler() {
        return this.handler;
    }

    public RTMP getState() {
        return this.state;
    }

    public byte getStateCode() {
        return this.state.getState();
    }

    public void setStateCode(byte stateCode) {
        if (isTrace) {
            log.trace("setStateCode: {} - {}", (Object)stateCode, (Object)RTMP.states[stateCode]);
        }
        byte prevState = this.state.getState();
        this.state.setState(stateCode);
        if (stateCode > prevState) {
            this.notifyPropertyChanged(new PropertyChangeEvent(this, "ConnectionState", prevState, stateCode));
        }
    }

    public IoSession getIoSession() {
        return null;
    }

    public void setEncrypted(boolean encrypted) {
        this.state.setEncrypted(encrypted);
    }

    public boolean isEncrypted() {
        return this.state.isEncrypted();
    }

    public Semaphore getDecoderLock() {
        return this.decoderLock;
    }

    public Semaphore getEncoderLock() {
        return this.encoderLock;
    }

    public RTMPDecodeState getDecoderState() {
        return this.decoderState;
    }

    @Override
    public void setBandwidth(int mbits) {
        Optional<Channel> opt = Optional.ofNullable(this.getChannel(2));
        if (opt.isPresent()) {
            Channel channel = opt.get();
            channel.write(new ServerBW(mbits));
            channel.write(new ClientBW(mbits, (byte)this.limitType));
        }
    }

    public int getTimer() {
        return this.timer.incrementAndGet();
    }

    public void open() {
        if (isTrace) {
            log.trace("Memory at open - free: {}K total: {}K", (Object)(Runtime.getRuntime().freeMemory() / 1024L), (Object)(Runtime.getRuntime().totalMemory() / 1024L));
        }
    }

    @Override
    public boolean connect(IScope newScope, Object[] params) {
        if (isDebug) {
            log.debug("Connect scope: {}", (Object)newScope);
        }
        try {
            boolean success = super.connect(newScope, params);
            if (success) {
                this.stopWaitForHandshake();
                this.startRoundTripMeasurement();
            } else if (isDebug) {
                log.debug("Connect failed");
            }
            return success;
        }
        catch (ClientRejectedException e) {
            String reason = (String)e.getReason();
            log.info("Client rejected, reason: " + (reason != null ? reason : "None"));
            this.stopWaitForHandshake();
            throw e;
        }
    }

    public void startWaitForHandshake() {
        block4: {
            if (isDebug) {
                log.debug("startWaitForHandshake - {}", (Object)this.sessionId);
            }
            if (this.scheduler != null) {
                try {
                    this.waitForHandshakeTask = this.scheduler.schedule((Runnable)new WaitForHandshakeTask(), new Date(System.currentTimeMillis() + (long)this.maxHandshakeTimeout));
                }
                catch (TaskRejectedException e) {
                    if (!isDebug) break block4;
                    log.warn("WaitForHandshake task was rejected for {}", (Object)this.sessionId, (Object)e);
                }
            }
        }
    }

    private void stopWaitForHandshake() {
        if (this.waitForHandshakeTask != null) {
            boolean cancelled = this.waitForHandshakeTask.cancel(true);
            this.waitForHandshakeTask = null;
            if (cancelled && isDebug) {
                log.debug("waitForHandshake was cancelled for {}", (Object)this.sessionId);
            }
        }
    }

    private void startRoundTripMeasurement() {
        if (this.scheduler != null) {
            if (this.pingInterval > 0) {
                if (isDebug) {
                    log.debug("startRoundTripMeasurement - {}", (Object)this.sessionId);
                }
                try {
                    this.keepAliveTask = this.scheduler.scheduleWithFixedDelay((Runnable)new KeepAliveTask(), new Date(System.currentTimeMillis() + 2000L), (long)this.pingInterval);
                    if (isDebug) {
                        log.debug("Keep alive scheduled for {}", (Object)this.sessionId);
                    }
                }
                catch (Exception e) {
                    log.warn("Error creating keep alive job for {}", (Object)this.sessionId, (Object)e);
                }
            }
        } else {
            log.trace("startRoundTripMeasurement not enabled. If RTMP, can occur when lost before handshake is complete");
        }
    }

    private void stopRoundTripMeasurement() {
        if (this.keepAliveTask != null) {
            boolean cancelled = this.keepAliveTask.cancel(true);
            this.keepAliveTask = null;
            if (cancelled && isDebug) {
                log.debug("Keep alive was cancelled for {}", (Object)this.sessionId);
            }
        }
    }

    public void setup(String host, String path, Map<String, Object> params) {
        this.host = host;
        this.path = path;
        this.params = params;
        if (Integer.valueOf(3).equals(params.get("objectEncoding"))) {
            if (isDebug) {
                log.debug("Setting object encoding to AMF3");
            }
            this.state.setEncoding(IConnection.Encoding.AMF3);
        }
    }

    @Override
    public IConnection.Encoding getEncoding() {
        return this.state.getEncoding();
    }

    public int getNextAvailableChannelId() {
        int result = 4;
        while (this.isChannelUsed(result)) {
            ++result;
        }
        return result;
    }

    public boolean isChannelUsed(int channelId) {
        return this.channels.get(channelId) != null;
    }

    public Channel getChannel(int channelId) {
        Channel channel = null;
        if (this.state.getState() > 1) {
            channel = this.channels.putIfAbsent(channelId, new Channel(this, channelId));
            if (channel == null) {
                channel = (Channel)this.channels.get(channelId);
            }
        } else {
            log.warn("Channel {} requested before connected", (Object)channelId);
        }
        return channel;
    }

    public void closeChannel(int channelId) {
        if (isTrace) {
            log.trace("closeChannel: {}", (Object)channelId);
        }
        Channel chan = (Channel)this.channels.remove(channelId);
        if (isTrace) {
            log.trace("channel: {} for id: {}", (Object)chan, (Object)channelId);
            if (chan == null) {
                log.trace("Channels: {}", this.channels);
            }
        }
        chan = null;
    }

    protected Collection<IClientStream> getStreams() {
        return this.streams.values();
    }

    @Override
    public Map<Number, IClientStream> getStreamsMap() {
        return Collections.unmodifiableMap(this.streams);
    }

    @Override
    public Number reserveStreamId() {
        double d = 1.0;
        while (d < 320.0) {
            if (this.reservedStreams.add(d)) break;
            d += 1.0;
        }
        if (d == 320.0) {
            throw new IndexOutOfBoundsException("Unable to reserve new stream");
        }
        return d;
    }

    @Override
    public Number reserveStreamId(Number streamId) {
        if (isTrace) {
            log.trace("Reserve stream id: {}", (Object)streamId);
        }
        if (this.reservedStreams.add(streamId.doubleValue())) {
            return streamId;
        }
        return this.reserveStreamId();
    }

    public boolean isValidStreamId(Number streamId) {
        double d = streamId.doubleValue();
        if (isTrace) {
            log.trace("Checking validation for streamId {}; reservedStreams: {}; streams: {}, connection: {}", new Object[]{d, this.reservedStreams, this.streams, this.sessionId});
        }
        if (d <= 0.0 || !this.reservedStreams.contains(d)) {
            log.warn("Stream id: {} was not reserved in connection {}", (Object)d, (Object)this.sessionId);
            return false;
        }
        if (this.streams.get(d) != null) {
            log.warn("Another stream already exists with this id in streams {} in connection: {}", this.streams, (Object)this.sessionId);
            return false;
        }
        if (isTrace) {
            log.trace("Stream id: {} is valid for connection: {}", (Object)d, (Object)this.sessionId);
        }
        return true;
    }

    public boolean isIdle() {
        boolean idle;
        long lastPingTime = this.lastPingSentOn.get();
        long lastPongTime = this.lastPongReceivedOn.get();
        boolean bl = idle = lastPongTime > 0L && lastPingTime - lastPongTime > (long)this.maxInactivity;
        if (isTrace) {
            log.trace("Connection {} {} idle", (Object)this.getSessionId(), (Object)(idle ? "is" : "is not"));
        }
        return idle;
    }

    public boolean isDisconnected() {
        return this.state.getState() == 5;
    }

    @Override
    public IClientBroadcastStream newBroadcastStream(Number streamId) {
        if (this.isValidStreamId(streamId)) {
            ClientBroadcastStream cbs = (ClientBroadcastStream)this.scope.getContext().getBean("clientBroadcastStream");
            this.customizeStream(streamId, cbs);
            if (!this.registerStream(cbs)) {
                cbs = null;
            }
            return cbs;
        }
        return null;
    }

    @Override
    public ISingleItemSubscriberStream newSingleItemSubscriberStream(Number streamId) {
        if (this.isValidStreamId(streamId)) {
            SingleItemSubscriberStream siss = (SingleItemSubscriberStream)this.scope.getContext().getBean("singleItemSubscriberStream");
            this.customizeStream(streamId, siss);
            if (!this.registerStream(siss)) {
                siss = null;
            }
            return siss;
        }
        return null;
    }

    @Override
    public IPlaylistSubscriberStream newPlaylistSubscriberStream(Number streamId) {
        if (this.isValidStreamId(streamId)) {
            PlaylistSubscriberStream pss = (PlaylistSubscriberStream)this.scope.getContext().getBean("playlistSubscriberStream");
            this.customizeStream(streamId, pss);
            if (!this.registerStream(pss)) {
                log.trace("Stream: {} for stream id: {} failed to register", (Object)streamId);
                pss = null;
            }
            return pss;
        }
        return null;
    }

    public void addClientStream(IClientStream stream) {
        if (this.reservedStreams.add(stream.getStreamId().doubleValue())) {
            this.registerStream(stream);
        } else {
            log.warn("Failed adding stream: {} to reserved: {}", (Object)stream, this.reservedStreams);
        }
    }

    public void removeClientStream(Number streamId) {
        this.unreserveStreamId(streamId);
    }

    protected int getUsedStreamCount() {
        return this.usedStreams.get();
    }

    @Override
    public IClientStream getStreamById(Number streamId) {
        return (IClientStream)this.streams.get(streamId.doubleValue());
    }

    public Number getStreamIdForChannelId(int channelId) {
        if (channelId < 4) {
            return 0;
        }
        Double streamId = Math.floor((double)(channelId - 4) / 5.0 + 1.0);
        if (isTrace) {
            log.trace("Stream id: {} requested for channel id: {}", (Object)streamId, (Object)channelId);
        }
        return streamId;
    }

    public IClientStream getStreamByChannelId(int channelId) {
        if (channelId < 4) {
            return null;
        }
        Number streamId = this.getStreamIdForChannelId(channelId);
        if (isTrace) {
            log.trace("Stream requested for channel id: {} stream id: {} streams: {}", new Object[]{channelId, streamId, this.streams});
        }
        return this.getStreamById(streamId);
    }

    public int getChannelIdForStreamId(Number streamId) {
        int channelId = (int)(streamId.doubleValue() * 5.0) - 1;
        if (isTrace) {
            log.trace("Channel id: {} requested for stream id: {}", (Object)channelId, (Object)streamId);
        }
        return channelId;
    }

    public OutputStream createOutputStream(Number streamId) {
        int channelId = this.getChannelIdForStreamId(streamId);
        if (isTrace) {
            log.trace("Create output - stream id: {} channel id: {}", (Object)streamId, (Object)channelId);
        }
        Channel data = this.getChannel(channelId++);
        Channel video = this.getChannel(channelId++);
        Channel audio = this.getChannel(channelId++);
        if (isTrace) {
            log.trace("Output stream - data: {} video: {} audio: {}", new Object[]{data, video, audio});
        }
        return new OutputStream(video, audio, data);
    }

    private void customizeStream(Number streamId, AbstractClientStream stream) {
        Integer buffer = (Integer)this.streamBuffers.get(streamId.doubleValue());
        if (buffer != null) {
            stream.setClientBufferDuration(buffer);
        }
        stream.setName(this.createStreamName());
        stream.setConnection(this);
        stream.setScope(this.getScope());
        stream.setStreamId(streamId);
    }

    private boolean registerStream(IClientStream stream) {
        if (this.streams.putIfAbsent(stream.getStreamId().doubleValue(), stream) == null) {
            this.usedStreams.incrementAndGet();
            return true;
        }
        log.error("Unable to register stream {}, stream with id {} was already added", (Object)stream, (Object)stream.getStreamId());
        return false;
    }

    private void unregisterStream(IClientStream stream) {
        if (stream != null) {
            this.deleteStreamById(stream.getStreamId());
        }
    }

    @Override
    public void close() {
        if (this.closing.compareAndSet(false, true)) {
            if (isDebug) {
                log.debug("close: {}", (Object)this.sessionId);
            }
            this.stopWaitForHandshake();
            this.stopRoundTripMeasurement();
            if (this.state != null) {
                byte s = this.getStateCode();
                switch (s) {
                    case 5: {
                        if (isDebug) {
                            log.debug("Already disconnected");
                        }
                        return;
                    }
                }
                if (isDebug) {
                    log.debug("State: {}", (Object)RTMP.states[s]);
                }
                this.setStateCode((byte)4);
            }
            Red5.setConnectionLocal(this);
            IStreamService streamService = (IStreamService)ScopeUtils.getScopeService((IScope)this.scope, IStreamService.class, StreamService.class);
            if (streamService != null) {
                for (IClientStream stream : this.streams.values()) {
                    if (isDebug) {
                        log.debug("Closing stream: {}", (Object)stream.getStreamId());
                    }
                    streamService.deleteStream(this, stream.getStreamId());
                }
            } else if (isDebug) {
                log.debug("Stream service was not found for scope: {}", (Object)(this.scope != null ? this.scope.getName() : "null or non-existant"));
            }
            super.close();
            this.channels.clear();
            this.streams.clear();
            this.pendingCalls.clear();
            this.deferredResults.clear();
            this.pendingVideos.clear();
            this.streamBuffers.clear();
            if (isTrace) {
                log.trace("Memory at close - free: {}K total: {}K", (Object)(Runtime.getRuntime().freeMemory() / 1024L), (Object)(Runtime.getRuntime().totalMemory() / 1024L));
            }
            if (this.decoderState != null) {
                this.decoderState.stopDecoding();
            }
        } else if (isDebug) {
            log.debug("Already closing..");
        }
    }

    @Override
    public void dispatchEvent(IEvent event) {
        if (isDebug) {
            log.debug("Event notify: {}", (Object)event);
        }
        switch (event.getType()) {
            case CLIENT_INVOKE: {
                ClientInvokeEvent cie = (ClientInvokeEvent)event;
                this.invoke(cie.getMethod(), cie.getParams(), cie.getCallback());
                break;
            }
            case CLIENT_NOTIFY: {
                ClientNotifyEvent cne = (ClientNotifyEvent)event;
                this.notify(cne.getMethod(), cne.getParams());
                break;
            }
            default: {
                log.warn("Unhandled event: {}", (Object)event);
            }
        }
    }

    public void sendPendingServiceCallsCloseError() {
        if (this.pendingCalls != null && !this.pendingCalls.isEmpty()) {
            if (isDebug) {
                log.debug("Connection calls pending: {}", (Object)this.pendingCalls.size());
            }
            for (IPendingServiceCall call : this.pendingCalls.values()) {
                call.setStatus((byte)32);
                for (IPendingServiceCallback callback : call.getCallbacks()) {
                    callback.resultReceived(call);
                }
            }
        }
    }

    @Override
    public void unreserveStreamId(Number streamId) {
        double d;
        if (isTrace) {
            log.trace("Unreserve streamId: {}", (Object)streamId);
        }
        if ((d = streamId.doubleValue()) > 0.0) {
            if (this.reservedStreams.remove(d)) {
                this.deleteStreamById(d);
            } else if (isTrace) {
                log.trace("Failed to unreserve stream id: {} streams: {}", (Object)d, this.streams);
            }
        }
    }

    @Override
    public void deleteStreamById(Number streamId) {
        double d;
        if (isTrace) {
            log.trace("Delete streamId: {}", (Object)streamId);
        }
        if ((d = streamId.doubleValue()) > 0.0) {
            if (this.streams.remove(d) != null) {
                this.usedStreams.decrementAndGet();
                this.pendingVideos.remove(d);
                this.streamBuffers.remove(d);
            } else if (isTrace) {
                log.trace("Failed to remove stream id: {} streams: {}", (Object)d, this.streams);
            }
        }
    }

    public void ping(Ping ping) {
        Optional.ofNullable(this.getChannel(2)).ifPresent(channel -> channel.write(ping));
    }

    public abstract void write(Packet var1);

    public abstract void writeRaw(IoBuffer var1);

    protected void updateBytesRead() {
        long bytesRead = this.getReadBytes();
        if (bytesRead >= this.nextBytesRead) {
            BytesRead sbr = new BytesRead((int)(bytesRead % Integer.MAX_VALUE));
            this.getChannel(2).write(sbr);
            this.nextBytesRead += this.bytesReadInterval;
        }
    }

    public void receivedBytesRead(int bytes) {
        if (isDebug) {
            log.debug("Client received {} bytes, written {} bytes, {} messages pending", new Object[]{bytes, this.getWrittenBytes(), this.getPendingMessages()});
        }
        this.clientBytesRead.addAndGet(bytes);
    }

    @Override
    public long getClientBytesRead() {
        return this.clientBytesRead.get();
    }

    @Override
    public void invoke(IServiceCall call) {
        this.invoke(call, 3);
    }

    public int getTransactionId() {
        return this.transactionId.incrementAndGet();
    }

    public void registerPendingCall(int invokeId, IPendingServiceCall call) {
        this.pendingCalls.put(invokeId, call);
    }

    @Override
    public void invoke(IServiceCall call, int channel) {
        int chunkSize;
        if ("playpublish".contains(call.getServiceMethodName()) && (chunkSize = Red5.getTargetChunkSize()) > 128) {
            log.debug("Setting chunk sizes to {}", (Object)chunkSize);
            this.state.setReadChunkSize(chunkSize);
            this.state.setWriteChunkSize(chunkSize);
            ChunkSize chunkSizeMessage = new ChunkSize(chunkSize);
            log.debug("Sending chunksize: {}", (Object)chunkSizeMessage);
            Optional.ofNullable(this.getChannel(2)).ifPresent(c -> c.write(chunkSizeMessage));
        }
        Invoke invoke = new Invoke();
        invoke.setCall(call);
        invoke.setTransactionId(this.getTransactionId());
        if (call instanceof IPendingServiceCall) {
            this.registerPendingCall(invoke.getTransactionId(), (IPendingServiceCall)call);
        }
        this.getChannel(channel).write(invoke);
    }

    @Override
    public void invoke(String method) {
        this.invoke(method, null, null);
    }

    @Override
    public void invoke(String method, Object[] params) {
        this.invoke(method, params, null);
    }

    @Override
    public void invoke(String method, IPendingServiceCallback callback) {
        this.invoke(method, null, callback);
    }

    @Override
    public void invoke(String method, Object[] params, IPendingServiceCallback callback) {
        PendingCall call = new PendingCall(method, params);
        if (callback != null) {
            call.registerCallback(callback);
        }
        this.invoke(call);
    }

    @Override
    public void notify(IServiceCall call) {
        this.notify(call, 3);
    }

    @Override
    public void notify(IServiceCall call, int channel) {
        Notify notify = new Notify();
        notify.setCall(call);
        Optional.ofNullable(this.getChannel(channel)).ifPresent(c -> c.write(notify));
    }

    @Override
    public void notify(String method) {
        this.notify(method, null);
    }

    @Override
    public void notify(String method, Object[] params) {
        Call call = new Call(method, params);
        this.notify(call);
    }

    @Override
    public void status(Status status) {
        this.status(status, 3);
    }

    @Override
    public void status(Status status, int channel) {
        if (status != null) {
            this.getChannel(channel).sendStatus(status);
        }
    }

    @Override
    public long getReadBytes() {
        return 0L;
    }

    @Override
    public long getWrittenBytes() {
        return 0L;
    }

    public IPendingServiceCall getPendingCall(int invokeId) {
        return (IPendingServiceCall)this.pendingCalls.get(invokeId);
    }

    public IPendingServiceCall retrievePendingCall(int invokeId) {
        return (IPendingServiceCall)this.pendingCalls.remove(invokeId);
    }

    protected String createStreamName() {
        return UUID.randomUUID().toString();
    }

    protected void writingMessage(Packet message) {
        if (message.getMessage() instanceof VideoData) {
            Number streamId = message.getHeader().getStreamId();
            AtomicInteger value = new AtomicInteger();
            AtomicInteger old = this.pendingVideos.putIfAbsent(streamId.doubleValue(), value);
            if (old == null) {
                old = value;
            }
            old.incrementAndGet();
        }
        if (this.isEncrypted()) {
            this.writtenMessages.incrementAndGet();
        }
    }

    public void messageReceived() {
        this.readMessages.incrementAndGet();
        this.updateBytesRead();
    }

    private String getMessageType(Packet packet) {
        Header header = packet.getHeader();
        byte headerDataType = header.getDataType();
        return this.messageTypeToName(headerDataType);
    }

    public String messageTypeToName(byte headerDataType) {
        switch (headerDataType) {
            case 22: {
                return "TYPE_AGGREGATE";
            }
            case 8: {
                return "TYPE_AUDIO_DATA";
            }
            case 9: {
                return "TYPE_VIDEO_DATA";
            }
            case 16: {
                return "TYPE_FLEX_SHARED_OBJECT";
            }
            case 19: {
                return "TYPE_SHARED_OBJECT";
            }
            case 20: {
                return "TYPE_INVOKE";
            }
            case 17: {
                return "TYPE_FLEX_MESSAGE";
            }
            case 18: {
                return "TYPE_NOTIFY";
            }
            case 15: {
                return "TYPE_FLEX_STREAM_SEND";
            }
            case 4: {
                return "TYPE_PING";
            }
            case 3: {
                return "TYPE_BYTES_READ";
            }
            case 1: {
                return "TYPE_CHUNK_SIZE";
            }
            case 6: {
                return "TYPE_CLIENT_BANDWIDTH";
            }
            case 5: {
                return "TYPE_SERVER_BANDWIDTH";
            }
        }
        return "UNKNOWN [" + headerDataType + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessageReceived(Packet packet) {
        if (this.maxHandlingTimeout > 0L) {
            packet.setExpirationTime(System.currentTimeMillis() + this.maxHandlingTimeout);
        }
        if (this.executor != null) {
            byte dataType = packet.getHeader().getDataType();
            switch (dataType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    try {
                        this.handler.messageReceived(this, packet);
                        return;
                    }
                    catch (Exception e) {
                        log.error("Error processing received message {}", (Object)this.sessionId, (Object)e);
                    }
                    return;
                }
                default: {
                    String messageType = this.getMessageType(packet);
                    try {
                        long packetNumber = this.packetSequence.incrementAndGet();
                        if (this.executorQueueSizeToDropAudioPackets > 0 && this.currentQueueSize.get() >= this.executorQueueSizeToDropAudioPackets && packet.getHeader().getDataType() == 8) {
                            log.info("Queue threshold reached. Discarding packet: session=[{}], msgType=[{}], packetNum=[{}]", new Object[]{this.sessionId, messageType, packetNumber});
                            return;
                        }
                        int streamId = packet.getHeader().getStreamId().intValue();
                        if (isTrace) {
                            log.trace("Handling message for streamId: {}, channelId: {} Channels: {}", new Object[]{streamId, packet.getHeader().getChannelId(), this.channels});
                        }
                        ReceivedMessageTask task = new ReceivedMessageTask(this.sessionId, packet, this.handler, this);
                        task.setPacketNumber(packetNumber);
                        ReceivedMessageTaskQueue newStreamTasks = new ReceivedMessageTaskQueue(streamId, this);
                        ReceivedMessageTaskQueue currentStreamTasks = this.tasksByStreams.putIfAbsent(streamId, newStreamTasks);
                        if (currentStreamTasks != null) {
                            currentStreamTasks.addTask(task);
                            return;
                        }
                        newStreamTasks.addTask(task);
                        return;
                    }
                    catch (Exception e) {
                        log.error("Incoming message handling failed on session=[" + this.sessionId + "], messageType=[" + messageType + "]", (Throwable)e);
                        if (!isDebug) return;
                        log.debug("Execution rejected on {} - {}", (Object)this.sessionId, (Object)RTMP.states[this.getStateCode()]);
                        log.debug("Lock permits - decode: {} encode: {}", (Object)this.decoderLock.availablePermits(), (Object)this.encoderLock.availablePermits());
                    }
                    return;
                }
            }
        } else {
            this.receivedPacketQueue.offer(packet);
            if (this.receivedPacketFuture != null) return;
            RTMPConnection conn = this;
            this.receivedPacketFuture = this.receivedPacketExecutor.submit(() -> {
                Thread.currentThread().setName(String.format("RTMPRecv@%s", this.sessionId));
                do {
                    try {
                        Packet p = this.receivedPacketQueue.take();
                        if (p == null) continue;
                        if (isTrace) {
                            log.trace("Handle received packet: {}", (Object)p);
                        }
                        this.handler.messageReceived(conn, p);
                    }
                    catch (Exception e) {
                        log.error("Error processing received message {} state: {}", new Object[]{this.sessionId, RTMP.states[this.getStateCode()], e});
                    }
                } while (!this.isClosed());
                this.receivedPacketFuture = null;
                this.receivedPacketQueue.clear();
            });
        }
    }

    @Override
    public void onTaskAdded(ReceivedMessageTaskQueue queue) {
        this.currentQueueSize.incrementAndGet();
        this.processTasksQueue(queue);
    }

    @Override
    public void onTaskRemoved(ReceivedMessageTaskQueue queue) {
        this.currentQueueSize.decrementAndGet();
        this.processTasksQueue(queue);
    }

    /*
     * Unable to fully structure code
     */
    private void processTasksQueue(final ReceivedMessageTaskQueue currentStreamTasks) {
        block8: {
            block7: {
                streamId = currentStreamTasks.getStreamId();
                if (RTMPConnection.isTrace) {
                    RTMPConnection.log.trace("Process tasks for streamId {}", (Object)streamId);
                }
                if ((task = currentStreamTasks.getTaskToProcess()) == null) break block7;
                packet = task.getPacket();
                try {
                    messageType = this.getMessageType(packet);
                    future = this.executor.submitListenable((Runnable)new ListenableFutureTask((Callable)task));
                    future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<Packet>(){
                        final long startTime = System.currentTimeMillis();

                        int getProcessingTime() {
                            return (int)(System.currentTimeMillis() - this.startTime);
                        }

                        public void onFailure(Throwable t) {
                            log.debug("ReceivedMessageTask failure: {}", t);
                            if (log.isWarnEnabled()) {
                                log.warn("onFailure - session: {}, msgtype: {}, processingTime: {}, packetNum: {}", new Object[]{RTMPConnection.this.sessionId, messageType, this.getProcessingTime(), task.getPacketNumber()});
                            }
                            currentStreamTasks.removeTask(task);
                        }

                        public void onSuccess(Packet packet) {
                            log.debug("ReceivedMessageTask success");
                            if (isDebug) {
                                log.debug("onSuccess - session: {}, msgType: {}, processingTime: {}, packetNum: {}", new Object[]{RTMPConnection.this.sessionId, messageType, this.getProcessingTime(), task.getPacketNumber()});
                            }
                            currentStreamTasks.removeTask(task);
                        }
                    });
                }
                catch (TaskRejectedException tre) {
                    var10_10 = suppressed = tre.getSuppressed();
                    var9_11 = suppressed.length;
                    var8_12 = 0;
                    ** while (var8_12 < var9_11)
                }
lbl-1000:
                // 1 sources

                {
                    t = var10_10[var8_12];
                    RTMPConnection.log.warn("Suppressed exception on {}", (Object)this.sessionId, (Object)t);
                    ++var8_12;
                    continue;
                }
lbl20:
                // 1 sources

                RTMPConnection.log.info("Rejected message: {} on {}", (Object)packet, (Object)this.sessionId);
                currentStreamTasks.removeTask(task);
                break block8;
                catch (Throwable e) {
                    RTMPConnection.log.error("Incoming message handling failed on session=[" + this.sessionId + "]", e);
                    if (RTMPConnection.isDebug) {
                        RTMPConnection.log.debug("Execution rejected on {} - {}", (Object)this.getSessionId(), (Object)RTMP.states[this.getStateCode()]);
                        RTMPConnection.log.debug("Lock permits - decode: {} encode: {}", (Object)this.decoderLock.availablePermits(), (Object)this.encoderLock.availablePermits());
                    }
                    currentStreamTasks.removeTask(task);
                }
                break block8;
            }
            if (RTMPConnection.isTrace) {
                RTMPConnection.log.trace("Channel {} task queue is empty", (Object)streamId);
            }
        }
    }

    public void messageSent(Packet message) {
        IRTMPEvent event = message.getMessage();
        if (event instanceof VideoData) {
            log.debug("Video message sent");
            Number streamId = message.getHeader().getStreamId();
            AtomicInteger pending = (AtomicInteger)this.pendingVideos.get(streamId.doubleValue());
            if (isTrace) {
                log.trace("Stream id: {} pending: {} total pending videos: {}", new Object[]{streamId, pending, this.pendingVideos.size()});
            }
            if (pending != null) {
                pending.decrementAndGet();
            }
        } else if (event instanceof AudioData) {
            log.debug("Audio message sent");
        } else if (event instanceof Notify) {
            log.debug("Notify message sent");
        } else {
            log.debug("Message sent: {} data type: {}", (Object)event.getType(), (Object)event.getDataType());
        }
        this.writtenMessages.incrementAndGet();
    }

    protected void messageDropped() {
        this.droppedMessages.incrementAndGet();
    }

    protected int currentQueueSize() {
        return this.currentQueueSize.get();
    }

    @Override
    public long getPendingVideoMessages(Number streamId) {
        AtomicInteger pendingCount = (AtomicInteger)this.pendingVideos.get(streamId.doubleValue());
        if (isTrace) {
            log.trace("Stream id: {} pendingCount: {} total pending videos: {}", new Object[]{streamId, pendingCount, this.pendingVideos.size()});
        }
        return pendingCount != null ? pendingCount.intValue() : 0;
    }

    public void sendSharedObjectMessage(String name, int currentVersion, boolean persistent, Set<ISharedObjectEvent> events) {
        SharedObjectMessage syncMessage = this.state.getEncoding() == IConnection.Encoding.AMF3 ? new FlexSharedObjectMessage(null, name, currentVersion, persistent) : new SharedObjectMessage(null, name, currentVersion, persistent);
        syncMessage.addEvents(events);
        try {
            Optional.ofNullable(this.getChannel(3)).ifPresent(c -> c.write(syncMessage));
        }
        catch (Exception e) {
            log.warn("Exception sending shared object", (Throwable)e);
        }
    }

    @Override
    public void ping() {
        long newPingTime = System.currentTimeMillis();
        if (isDebug) {
            log.debug("Send Ping: session=[{}], currentTime=[{}], lastPingTime=[{}]", new Object[]{this.getSessionId(), newPingTime, this.lastPingSentOn.get()});
        }
        if (this.lastPingSentOn.get() == 0L) {
            this.lastPongReceivedOn.set(newPingTime);
        }
        Ping pingRequest = new Ping();
        pingRequest.setEventType((short)6);
        this.lastPingSentOn.set(newPingTime);
        int now = (int)(newPingTime & 0xFFFFFFFFL);
        pingRequest.setValue2(now);
        this.ping(pingRequest);
    }

    public void pingReceived(Ping pong) {
        long now = System.currentTimeMillis();
        long previousPingTime = this.lastPingSentOn.get();
        int previousPingValue = (int)(previousPingTime & 0xFFFFFFFFL);
        int pongValue = pong.getValue2().intValue();
        if (isDebug) {
            log.debug("Pong received: session=[{}] at {} with value {}, previous received at {}", new Object[]{this.getSessionId(), now, pongValue, previousPingValue});
        }
        if (pongValue == previousPingValue) {
            this.lastPingRoundTripTime.set((int)(now - previousPingTime & 0xFFFFFFFFL));
            if (isDebug) {
                log.debug("Ping response session=[{}], RTT=[{} ms]", new Object[]{this.getSessionId(), this.lastPingRoundTripTime.get()});
            }
        } else if (this.getPendingMessages() > 4L) {
            int pingRtt = (int)(now & 0xFFFFFFFFL) - pongValue;
            log.info("Pong delayed: session=[{}], ping response took [{} ms] to arrive. Connection may be congested, or loopback", new Object[]{this.getSessionId(), pingRtt});
        }
        this.lastPongReceivedOn.set(now);
    }

    public int getLastPingSentAndLastPongReceivedInterval() {
        return (int)(this.lastPingSentOn.get() - this.lastPongReceivedOn.get());
    }

    @Override
    public int getLastPingTime() {
        return this.lastPingRoundTripTime.get();
    }

    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void setMaxInactivity(int maxInactivity) {
        this.maxInactivity = maxInactivity;
    }

    protected abstract void onInactive();

    public void setScheduler(ThreadPoolTaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public ThreadPoolTaskScheduler getScheduler() {
        return this.scheduler;
    }

    public ThreadPoolTaskExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
    }

    public ThreadPoolTaskScheduler getDeadlockGuardScheduler() {
        return this.deadlockGuardScheduler;
    }

    public void setDeadlockGuardScheduler(ThreadPoolTaskScheduler deadlockGuardScheduler) {
        this.deadlockGuardScheduler = deadlockGuardScheduler;
    }

    public void registerDeferredResult(DeferredResult result) {
        this.deferredResults.add(result);
    }

    public void unregisterDeferredResult(DeferredResult result) {
        this.deferredResults.remove(result);
    }

    public void rememberStreamBufferDuration(int streamId, int bufferDuration) {
        this.streamBuffers.put(streamId, bufferDuration);
    }

    public void setMaxHandshakeTimeout(int maxHandshakeTimeout) {
        this.maxHandshakeTimeout = maxHandshakeTimeout;
    }

    public long getMaxHandlingTimeout() {
        return this.maxHandlingTimeout;
    }

    public void setMaxHandlingTimeout(long maxHandlingTimeout) {
        this.maxHandlingTimeout = maxHandlingTimeout;
    }

    public int getChannelsInitalCapacity() {
        return this.channelsInitalCapacity;
    }

    public void setChannelsInitalCapacity(int channelsInitalCapacity) {
        this.channelsInitalCapacity = channelsInitalCapacity;
    }

    public int getChannelsConcurrencyLevel() {
        return this.channelsConcurrencyLevel;
    }

    public void setChannelsConcurrencyLevel(int channelsConcurrencyLevel) {
        this.channelsConcurrencyLevel = channelsConcurrencyLevel;
    }

    public int getStreamsInitalCapacity() {
        return this.streamsInitalCapacity;
    }

    public void setStreamsInitalCapacity(int streamsInitalCapacity) {
        this.streamsInitalCapacity = streamsInitalCapacity;
    }

    public int getStreamsConcurrencyLevel() {
        return this.streamsConcurrencyLevel;
    }

    public void setStreamsConcurrencyLevel(int streamsConcurrencyLevel) {
        this.streamsConcurrencyLevel = streamsConcurrencyLevel;
    }

    public int getPendingCallsInitalCapacity() {
        return this.pendingCallsInitalCapacity;
    }

    public void setPendingCallsInitalCapacity(int pendingCallsInitalCapacity) {
        this.pendingCallsInitalCapacity = pendingCallsInitalCapacity;
    }

    public int getPendingCallsConcurrencyLevel() {
        return this.pendingCallsConcurrencyLevel;
    }

    public void setPendingCallsConcurrencyLevel(int pendingCallsConcurrencyLevel) {
        this.pendingCallsConcurrencyLevel = pendingCallsConcurrencyLevel;
    }

    public int getReservedStreamsInitalCapacity() {
        return this.reservedStreamsInitalCapacity;
    }

    public void setReservedStreamsInitalCapacity(int reservedStreamsInitalCapacity) {
        this.reservedStreamsInitalCapacity = reservedStreamsInitalCapacity;
    }

    public int getReservedStreamsConcurrencyLevel() {
        return this.reservedStreamsConcurrencyLevel;
    }

    public void setReservedStreamsConcurrencyLevel(int reservedStreamsConcurrencyLevel) {
        this.reservedStreamsConcurrencyLevel = reservedStreamsConcurrencyLevel;
    }

    public void setExecutorQueueSizeToDropAudioPackets(Integer executorQueueSizeToDropAudioPackets) {
        this.executorQueueSizeToDropAudioPackets = executorQueueSizeToDropAudioPackets;
    }

    @Override
    public String getProtocol() {
        return "rtmp";
    }

    public String toString() {
        if (isDebug) {
            String id = this.getClient() != null ? this.getClient().getId() : null;
            return String.format("%1$s %2$s:%3$s to %4$s client: %5$s session: %6$s state: %7$s", this.getClass().getSimpleName(), this.getRemoteAddress(), this.getRemotePort(), this.getHost(), id, this.getSessionId(), RTMP.states[this.getStateCode()]);
        }
        Object[] args = new Object[]{this.getClass().getSimpleName(), this.getRemoteAddress(), this.getReadBytes(), this.getWrittenBytes(), this.getSessionId(), RTMP.states[this.getStateCode()]};
        return String.format("%1$s from %2$s (in: %3$s out: %4$s) session: %5$s state: %6$s", args);
    }

    private class KeepAliveTask
    implements Runnable {
        private final AtomicLong lastBytesRead = new AtomicLong(0L);
        private volatile long lastBytesReadTime = 0L;

        private KeepAliveTask() {
        }

        @Override
        public void run() {
            block16: {
                if (RTMPConnection.this.state.getState() == 2 && RTMPConnection.this.running.compareAndSet(false, true)) {
                    if (isTrace) {
                        log.trace("Running keep-alive for {}", (Object)RTMPConnection.this.getSessionId());
                    }
                    try {
                        try {
                            if (RTMPConnection.this.isConnected()) {
                                long now = System.currentTimeMillis();
                                long currentReadBytes = RTMPConnection.this.getReadBytes();
                                long previousReadBytes = this.lastBytesRead.get();
                                if (isTrace) {
                                    log.trace("Time now: {} current read count: {} last read count: {}", new Object[]{now, currentReadBytes, previousReadBytes});
                                }
                                if (currentReadBytes > previousReadBytes) {
                                    if (isTrace) {
                                        log.trace("Client is still alive, no ping needed");
                                    }
                                    if (this.lastBytesRead.compareAndSet(previousReadBytes, currentReadBytes)) {
                                        this.lastBytesReadTime = now;
                                    }
                                } else {
                                    long lastPingTime = RTMPConnection.this.lastPingSentOn.get();
                                    long lastPongTime = RTMPConnection.this.lastPongReceivedOn.get();
                                    if (lastPongTime > 0L && lastPingTime - lastPongTime > (long)RTMPConnection.this.maxInactivity && now - this.lastBytesReadTime > (long)RTMPConnection.this.maxInactivity) {
                                        log.warn("Closing connection - inactivity timeout: session=[{}], lastPongReceived=[{} ms ago], lastPingSent=[{} ms ago], lastDataRx=[{} ms ago]", new Object[]{RTMPConnection.this.getSessionId(), lastPingTime - lastPongTime, now - lastPingTime, now - this.lastBytesReadTime});
                                        log.warn("Client on session=[{}] has not responded to our ping for [{} ms] and we haven't received data for [{} ms]", new Object[]{RTMPConnection.this.getSessionId(), lastPingTime - lastPongTime, now - this.lastBytesReadTime});
                                        RTMPConnection.this.onInactive();
                                    } else {
                                        RTMPConnection.this.ping();
                                    }
                                }
                                break block16;
                            }
                            if (isDebug) {
                                log.debug("No longer connected, clean up connection. Connection state: {}", (Object)RTMP.states[RTMPConnection.this.state.getState()]);
                            }
                            RTMPConnection.this.onInactive();
                        }
                        catch (Exception e) {
                            log.warn("Exception in keepalive for {}", (Object)RTMPConnection.this.getSessionId(), (Object)e);
                            RTMPConnection.this.running.compareAndSet(true, false);
                        }
                    }
                    finally {
                        RTMPConnection.this.running.compareAndSet(true, false);
                    }
                }
            }
        }
    }

    private class WaitForHandshakeTask
    implements Runnable {
        public WaitForHandshakeTask() {
            if (isTrace) {
                log.trace("WaitForHandshakeTask created on scheduler: {} for session: {}", (Object)RTMPConnection.this.scheduler, (Object)RTMPConnection.this.getSessionId());
            }
        }

        @Override
        public void run() {
            if (isTrace) {
                log.trace("WaitForHandshakeTask started for {}", (Object)RTMPConnection.this.getSessionId());
            }
            if (RTMPConnection.this.state.getState() != 2) {
                log.warn("Closing {}, due to long handshake. State: {}", (Object)RTMPConnection.this.getSessionId(), (Object)RTMP.states[RTMPConnection.this.getStateCode()]);
                RTMPConnection.this.onInactive();
            }
        }
    }
}

