/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.remoting;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.client.IRemotingClient;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Input;
import org.red5.io.object.Output;
import org.red5.io.object.RecordSet;
import org.red5.io.object.Serializer;
import org.red5.server.net.remoting.IRemotingCallback;
import org.red5.server.net.remoting.RemotingHeader;
import org.red5.server.util.HttpConnectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingClient
implements IRemotingClient {
    protected static Logger log = LoggerFactory.getLogger(RemotingClient.class);
    public static final int DEFAULT_TIMEOUT = 30000;
    protected static final String CONTENT_TYPE = "application/x-amf";
    protected HttpClient client;
    protected String url;
    protected String appendToUrl = "";
    protected Map<String, RemotingHeader> headers = new ConcurrentHashMap<String, RemotingHeader>();
    protected static ExecutorService executor;
    protected int poolSize = 1;

    public RemotingClient() {
        log.debug("RemotingClient created");
    }

    public RemotingClient(String url) {
        this(url, 30000);
        log.debug("RemotingClient created  - url: {}", (Object)url);
    }

    public RemotingClient(String url, int timeout) {
        this.client = HttpConnectionUtil.getClient(timeout);
        this.url = url;
        log.debug("RemotingClient created  - url: {} timeout: {}", (Object)url, (Object)timeout);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        executor = Executors.newFixedThreadPool(poolSize);
    }

    private IoBuffer encodeInvoke(String method, Object[] params) {
        log.debug("RemotingClient encodeInvoke - method: {} params: {}", (Object)method, (Object)params);
        IoBuffer result = IoBuffer.allocate((int)1024);
        result.setAutoExpand(true);
        result.putShort((short)0);
        Collection<RemotingHeader> hdr = this.headers.values();
        result.putShort((short)hdr.size());
        for (RemotingHeader header : hdr) {
            org.red5.io.amf.Output.putString((IoBuffer)result, (String)header.name);
            result.put(header.required ? (byte)1 : 0);
            IoBuffer tmp = IoBuffer.allocate((int)1024);
            tmp.setAutoExpand(true);
            org.red5.io.amf.Output tmpOut = new org.red5.io.amf.Output(tmp);
            Serializer.serialize((Output)tmpOut, (Object)header.data);
            tmp.flip();
            result.putInt(tmp.limit());
            result.put(tmp);
            tmp.free();
            tmp = null;
        }
        result.putShort((short)1);
        org.red5.io.amf.Output.putString((IoBuffer)result, (String)method);
        org.red5.io.amf.Output.putString((IoBuffer)result, (String)"");
        IoBuffer tmp = IoBuffer.allocate((int)1024);
        tmp.setAutoExpand(true);
        org.red5.io.amf.Output tmpOut = new org.red5.io.amf.Output(tmp);
        if (params == null) {
            tmpOut.writeNull();
        } else {
            tmpOut.writeArray(params);
        }
        tmp.flip();
        result.putInt(tmp.limit());
        result.put(tmp);
        tmp.free();
        tmp = null;
        result.flip();
        return result;
    }

    protected void processHeaders(IoBuffer in) {
        log.debug("RemotingClient processHeaders - buffer limit: {}", (Object)(in != null ? in.limit() : 0));
        int version = in.getUnsignedShort();
        log.debug("Version: {}", (Object)version);
        int count = in.getUnsignedShort();
        log.debug("Count: {}", (Object)count);
        org.red5.io.amf.Input input = new org.red5.io.amf.Input(in);
        int i = 0;
        while (i < count) {
            String name = input.getString();
            log.debug("Name: {}", (Object)name);
            boolean required = in.get() == 1;
            log.debug("Required: {}", (Object)required);
            int len = in.getInt();
            log.debug("Length: {}", (Object)len);
            Object value = Deserializer.deserialize((Input)input, Object.class);
            log.debug("Value: {}", value);
            if ("AppendToGatewayUrl".equals(name)) {
                this.appendToUrl = (String)value;
            } else if ("ReplaceGatewayUrl".equals(name)) {
                this.url = (String)value;
            } else if ("RequestPersistentHeader".equals(name)) {
                if (value instanceof Map) {
                    Map valueMap = (Map)value;
                    RemotingHeader header = new RemotingHeader((String)valueMap.get("name"), (Boolean)valueMap.get("mustUnderstand"), valueMap.get("data"));
                    this.headers.put(header.name, header);
                } else {
                    log.error("Expected Map but received {}", value);
                }
            } else {
                log.warn("Unsupported remoting header \"{}\" received with value \"{}\"", (Object)name, value);
            }
            ++i;
        }
    }

    private Object decodeResult(IoBuffer data) {
        log.debug("decodeResult - data limit: {}", (Object)(data != null ? data.limit() : 0));
        this.processHeaders(data);
        int count = data.getUnsignedShort();
        if (count != 1) {
            throw new RuntimeException("Expected exactly one result but got " + count);
        }
        org.red5.io.amf.Input input = new org.red5.io.amf.Input(data);
        String target = input.getString();
        log.debug("Target: {}", (Object)target);
        String nullString = input.getString();
        log.debug("Null string: {}", (Object)nullString);
        return Deserializer.deserialize((Input)input, Object.class);
    }

    public void setCredentials(String userid, String password) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userid", userid);
        data.put("password", password);
        RemotingHeader header = new RemotingHeader("Credentials", true, data);
        this.headers.put("Credentials", header);
    }

    public void resetCredentials() {
        this.removeHeader("Credentials");
    }

    public void addHeader(String name, boolean required, Object value) {
        RemotingHeader header = new RemotingHeader(name, required, value);
        this.headers.put(name, header);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public Object invokeMethod(String method, Object[] params) {
        log.debug("invokeMethod url: {}", (Object)(String.valueOf(this.url) + this.appendToUrl));
        IoBuffer resultBuffer = null;
        IoBuffer data = this.encodeInvoke(method, params);
        HttpPost post = null;
        try {
            post = new HttpPost(String.valueOf(this.url) + this.appendToUrl);
            post.addHeader("Content-Type", CONTENT_TYPE);
            post.setEntity((HttpEntity)new InputStreamEntity(data.asInputStream(), (long)data.limit()));
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            int code = response.getStatusLine().getStatusCode();
            log.debug("HTTP response code: {}", (Object)code);
            if (code / 100 != 2) {
                throw new RuntimeException("Didn't receive success from remoting server");
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                byte[] bytes;
                Object result;
                int contentLength = (int)entity.getContentLength();
                if (contentLength < 1) {
                    contentLength = 16;
                }
                if ((result = this.decodeResult(resultBuffer = IoBuffer.wrap((byte[])(bytes = EntityUtils.toByteArray((HttpEntity)entity))))) instanceof RecordSet) {
                    ((RecordSet)result).setRemotingClient((IRemotingClient)this);
                }
                Object object = result;
                return object;
            }
        }
        catch (Exception ex) {
            log.error("Error while invoking remoting method: {}", (Object)method, (Object)ex);
            post.abort();
        }
        finally {
            if (resultBuffer != null) {
                resultBuffer.free();
                resultBuffer = null;
            }
            data.free();
            data = null;
        }
        return null;
    }

    public void invokeMethod(String method, Object[] methodParams, IRemotingCallback callback) {
        try {
            RemotingWorker worker = new RemotingWorker(this, method, methodParams, callback);
            executor.execute(worker);
        }
        catch (Exception err) {
            log.warn("Exception invoking method: {}", (Object)method, (Object)err);
        }
    }

    public static final class RemotingWorker
    implements Runnable {
        private final RemotingClient client;
        private final String method;
        private final Object[] params;
        private final IRemotingCallback callback;

        public RemotingWorker(RemotingClient client, String method, Object[] params, IRemotingCallback callback) {
            this.client = client;
            this.method = method;
            this.params = params;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                Object result = this.client.invokeMethod(this.method, this.params);
                this.callback.resultReceived(this.client, this.method, this.params, result);
            }
            catch (Exception err) {
                this.callback.errorReceived(this.client, this.method, this.params, err);
            }
        }
    }
}

