/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.Red5;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.statistics.IPlaylistSubscriberStreamStatistics;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IPlaylistController;
import org.red5.server.api.stream.IPlaylistSubscriberStream;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.OperationNotSupportedException;
import org.red5.server.api.stream.StreamState;
import org.red5.server.stream.AbstractClientStream;
import org.red5.server.stream.IConsumerService;
import org.red5.server.stream.IProviderService;
import org.red5.server.stream.PlayEngine;
import org.red5.server.stream.SimplePlaylistController;
import org.red5.server.stream.StreamNotFoundException;
import org.slf4j.Logger;

public class PlaylistSubscriberStream
extends AbstractClientStream
implements IPlaylistSubscriberStream,
IPlaylistSubscriberStreamStatistics {
    private static final Logger log = Red5LoggerFactory.getLogger(PlaylistSubscriberStream.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    private IPlaylistController controller;
    private IPlaylistController defaultController;
    private final LinkedList<IPlayItem> items;
    private int currentItemIndex = 0;
    protected PlayEngine engine;
    protected boolean rewind;
    protected boolean random;
    protected boolean repeat;
    protected ISchedulingService schedulingService;
    protected CopyOnWriteArraySet<String> jobs = new CopyOnWriteArraySet();
    protected int bufferCheckInterval = 0;
    protected int underrunTrigger = 10;
    protected long creationTime = System.currentTimeMillis();
    protected long bytesSent = 0L;
    private int maxPendingVideoFrames = 10;
    private int maxSequentialPendingVideoFrames = 10;

    public PlaylistSubscriberStream() {
        this.defaultController = new SimplePlaylistController();
        this.items = new LinkedList();
    }

    PlayEngine createEngine(ISchedulingService schedulingService, IConsumerService consumerService, IProviderService providerService) {
        this.engine = new PlayEngine.Builder(this, schedulingService, consumerService, providerService).build();
        this.engine.setMaxPendingVideoFrames(this.maxPendingVideoFrames);
        this.engine.setMaxSequentialPendingVideoFrames(this.maxSequentialPendingVideoFrames);
        return this.engine;
    }

    public void setBufferCheckInterval(int bufferCheckInterval) {
        this.bufferCheckInterval = bufferCheckInterval;
    }

    public void setUnderrunTrigger(int underrunTrigger) {
        this.underrunTrigger = underrunTrigger;
    }

    @Override
    public void start() {
        if (this.engine == null) {
            IScope scope = this.getScope();
            if (scope != null) {
                IContext ctx = scope.getContext();
                this.schedulingService = ctx.hasBean("schedulingService") ? (ISchedulingService)ctx.getBean("schedulingService") : (ISchedulingService)scope.getParent().getContext().getBean("schedulingService");
                IConsumerService consumerService = null;
                consumerService = ctx.hasBean("consumerService") ? (IConsumerService)ctx.getBean("consumerService") : (IConsumerService)scope.getParent().getContext().getBean("consumerService");
                IProviderService providerService = null;
                providerService = ctx.hasBean("providerService") ? (IProviderService)ctx.getBean("providerService") : (IProviderService)scope.getParent().getContext().getBean("providerService");
                this.engine = new PlayEngine.Builder(this, this.schedulingService, consumerService, providerService).build();
            } else {
                throw new IllegalStateException("Scope was null on start playing");
            }
        }
        this.engine.setBufferCheckInterval(this.bufferCheckInterval);
        this.engine.setUnderrunTrigger(this.underrunTrigger);
        this.engine.setMaxPendingVideoFrames(this.maxPendingVideoFrames);
        this.engine.setMaxSequentialPendingVideoFrames(this.maxSequentialPendingVideoFrames);
        this.engine.start();
        this.onChange(StreamState.STARTED, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play() throws IOException {
        int count = this.items.size();
        if (count > 0) {
            if (this.currentItemIndex == -1) {
                this.moveToNext();
            }
            while (count-- > 0) {
                IPlayItem item = null;
                this.read.lock();
                try {
                    item = this.items.get(this.currentItemIndex);
                    this.engine.play(item);
                    break;
                }
                catch (StreamNotFoundException e) {
                    this.moveToNext();
                    if (this.currentItemIndex == -1) break;
                    item = this.items.get(this.currentItemIndex);
                }
                catch (IllegalStateException e) {
                    break;
                }
                finally {
                    this.read.unlock();
                }
            }
        }
    }

    @Override
    public void pause(int position) {
        try {
            this.engine.pause(position);
        }
        catch (IllegalStateException e) {
            log.debug("pause caught an IllegalStateException");
        }
    }

    @Override
    public void resume(int position) {
        try {
            this.engine.resume(position);
        }
        catch (IllegalStateException e) {
            log.debug("resume caught an IllegalStateException");
        }
    }

    @Override
    public void stop() {
        block4: {
            if (log.isDebugEnabled()) {
                log.debug("stop");
            }
            try {
                this.engine.stop();
            }
            catch (IllegalStateException e) {
                if (log.isTraceEnabled()) {
                    log.warn("stop caught an IllegalStateException", (Throwable)e);
                }
                if (!log.isDebugEnabled()) break block4;
                log.debug("stop caught an IllegalStateException");
            }
        }
    }

    @Override
    public void seek(int position) throws OperationNotSupportedException {
        try {
            this.engine.seek(position);
        }
        catch (IllegalStateException e) {
            log.debug("seek caught an IllegalStateException");
        }
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("close");
        }
        if (this.engine != null) {
            this.engine.close();
            this.onChange(StreamState.CLOSED, new Object[0]);
            this.items.clear();
            if (this.schedulingService != null && !this.jobs.isEmpty()) {
                for (String jobName : this.jobs) {
                    this.schedulingService.removeScheduledJob(jobName);
                }
                this.jobs.clear();
            }
        }
    }

    @Override
    public boolean isPaused() {
        return this.state.get() == StreamState.PAUSED;
    }

    @Override
    public void addItem(IPlayItem item) {
        this.write.lock();
        try {
            this.items.add(item);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void addItem(IPlayItem item, int index) {
        this.write.lock();
        try {
            this.items.add(index, item);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void removeItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        int originSize = this.items.size();
        this.write.lock();
        try {
            this.items.remove(index);
        }
        finally {
            this.write.unlock();
        }
        if (this.currentItemIndex == index && index == originSize - 1) {
            this.currentItemIndex = index - 1;
        }
    }

    @Override
    public void removeAllItems() {
        this.stop();
        this.write.lock();
        try {
            this.items.clear();
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void previousItem() {
        this.stop();
        this.moveToPrevious();
        if (this.currentItemIndex == -1) {
            return;
        }
        IPlayItem item = null;
        int count = this.items.size();
        while (count-- > 0) {
            this.read.lock();
            try {
                item = this.items.get(this.currentItemIndex);
                this.engine.play(item);
                break;
            }
            catch (IOException err) {
                log.error("Error while starting to play item, moving to previous.", (Throwable)err);
                this.moveToPrevious();
                if (this.currentItemIndex != -1) continue;
                break;
            }
            catch (StreamNotFoundException e) {
                this.moveToPrevious();
                if (this.currentItemIndex != -1) continue;
                break;
            }
            catch (IllegalStateException e) {
                break;
            }
            finally {
                this.read.unlock();
            }
        }
    }

    @Override
    public boolean hasMoreItems() {
        int nextItem = this.currentItemIndex + 1;
        return nextItem < this.items.size() || this.repeat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextItem() {
        this.moveToNext();
        if (this.currentItemIndex == -1) {
            return;
        }
        IPlayItem item = null;
        int count = this.items.size();
        while (count-- > 0) {
            this.read.lock();
            try {
                item = this.items.get(this.currentItemIndex);
                this.engine.play(item, false);
                break;
            }
            catch (IOException err) {
                log.error("Error while starting to play item, moving to next", (Throwable)err);
                this.moveToNext();
                if (this.currentItemIndex != -1) continue;
                break;
            }
            catch (StreamNotFoundException e) {
                this.moveToNext();
                if (this.currentItemIndex != -1) continue;
                break;
            }
            catch (IllegalStateException e) {
                break;
            }
            finally {
                this.read.unlock();
            }
        }
    }

    @Override
    public void setItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        this.stop();
        this.currentItemIndex = index;
        this.read.lock();
        try {
            IPlayItem item = this.items.get(this.currentItemIndex);
            this.engine.play(item);
        }
        catch (IOException e) {
            log.error("setItem caught a IOException", (Throwable)e);
        }
        catch (StreamNotFoundException e) {
            log.debug("setItem caught a StreamNotFoundException");
        }
        catch (IllegalStateException e) {
            log.error("Illegal state exception on playlist item setup", (Throwable)e);
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public boolean isRandom() {
        return this.random;
    }

    @Override
    public void setRandom(boolean random) {
        this.random = random;
    }

    @Override
    public boolean isRewind() {
        return this.rewind;
    }

    @Override
    public void setRewind(boolean rewind) {
        this.rewind = rewind;
    }

    @Override
    public boolean isRepeat() {
        return this.repeat;
    }

    @Override
    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    private void seekToCurrentPlayback() {
        if (this.engine.isPullMode()) {
            try {
                long delta = System.currentTimeMillis() - this.engine.getPlaybackStart();
                this.engine.seek((int)delta);
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void receiveVideo(boolean receive) {
        if (this.engine != null) {
            boolean receiveVideo = this.engine.receiveVideo(receive);
            if (!receiveVideo && receive) {
                this.seekToCurrentPlayback();
            }
        } else {
            log.debug("PlayEngine was null, receiveVideo cannot be modified");
        }
    }

    @Override
    public void receiveAudio(boolean receive) {
        if (this.engine != null) {
            boolean receiveAudio = this.engine.receiveAudio(receive);
            if (receiveAudio && !receive) {
                this.engine.sendBlankAudio(true);
            } else if (!receiveAudio && receive) {
                this.seekToCurrentPlayback();
            }
        } else {
            log.debug("PlayEngine was null, receiveAudio cannot be modified");
        }
    }

    @Override
    public void setPlaylistController(IPlaylistController controller) {
        this.controller = controller;
    }

    @Override
    public int getItemSize() {
        return this.items.size();
    }

    @Override
    public int getCurrentItemIndex() {
        return this.currentItemIndex;
    }

    @Override
    public IPlayItem getCurrentItem() {
        return this.getItem(this.getCurrentItemIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlayItem getItem(int index) {
        this.read.lock();
        try {
            IPlayItem iPlayItem = this.items.get(index);
            return iPlayItem;
        }
        catch (IndexOutOfBoundsException e) {
            IPlayItem iPlayItem = null;
            return iPlayItem;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(IPlayItem oldItem, IPlayItem newItem) {
        boolean result = false;
        this.read.lock();
        try {
            int index = this.items.indexOf(oldItem);
            this.items.remove(index);
            this.items.set(index, newItem);
            result = true;
        }
        catch (Exception exception) {
        }
        finally {
            this.read.unlock();
        }
        return result;
    }

    private void moveToNext() {
        this.currentItemIndex = this.controller != null ? this.controller.nextItem(this, this.currentItemIndex) : this.defaultController.nextItem(this, this.currentItemIndex);
    }

    private void moveToPrevious() {
        this.currentItemIndex = this.controller != null ? this.controller.previousItem(this, this.currentItemIndex) : this.defaultController.previousItem(this, this.currentItemIndex);
    }

    @Override
    public void onChange(StreamState state, final Object ... changed) {
        IConnection conn = Red5.getConnectionLocal();
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        Notifier notifier = null;
        switch (state) {
            case SEEK: {
                if (handler == null) break;
                notifier = new Notifier(this, handler, conn){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        IPlayItem item = (IPlayItem)changed[0];
                        int position = (Integer)changed[1];
                        try {
                            this.handler.streamPlayItemSeek(this.stream, item, position);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamPlayItemSeek", t);
                        }
                        finally {
                            Red5.setConnectionLocal(null);
                        }
                    }
                };
                break;
            }
            case PAUSED: {
                this.setState(StreamState.PAUSED);
                if (handler == null) break;
                notifier = new Notifier(this, handler, conn){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        IPlayItem item = (IPlayItem)changed[0];
                        int position = (Integer)changed[1];
                        try {
                            this.handler.streamPlayItemPause(this.stream, item, position);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamPlayItemPause", t);
                        }
                        finally {
                            Red5.setConnectionLocal(null);
                        }
                    }
                };
                break;
            }
            case RESUMED: {
                this.setState(StreamState.PLAYING);
                if (handler == null) break;
                notifier = new Notifier(this, handler, conn){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        IPlayItem item = (IPlayItem)changed[0];
                        int position = (Integer)changed[1];
                        try {
                            this.handler.streamPlayItemResume(this.stream, item, position);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamPlayItemResume", t);
                        }
                        finally {
                            Red5.setConnectionLocal(null);
                        }
                    }
                };
                break;
            }
            case PLAYING: {
                if (handler == null) break;
                notifier = new Notifier(this, handler, conn){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        IPlayItem item = (IPlayItem)changed[0];
                        boolean isLive = (Boolean)changed[1];
                        try {
                            this.handler.streamPlayItemPlay(this.stream, item, isLive);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamPlayItemPlay", t);
                        }
                        finally {
                            Red5.setConnectionLocal(null);
                        }
                    }
                };
                break;
            }
            case CLOSED: {
                if (handler == null) break;
                notifier = new Notifier(this, handler, conn){

                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        try {
                            this.handler.streamSubscriberClose(this.stream);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamSubscriberClose", t);
                        }
                        finally {
                            Red5.setConnectionLocal(null);
                        }
                    }
                };
                break;
            }
            case STARTED: {
                if (handler == null) break;
                notifier = new Notifier(this, handler, conn){

                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        try {
                            this.handler.streamSubscriberStart(this.stream);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamSubscriberStart", t);
                        }
                        finally {
                            Red5.setConnectionLocal(null);
                        }
                    }
                };
                break;
            }
            case STOPPED: {
                this.setState(StreamState.STOPPED);
                if (handler == null) break;
                notifier = new Notifier(this, handler, conn){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(ISchedulingService service) {
                        Red5.setConnectionLocal(this.conn);
                        IPlayItem item = (IPlayItem)changed[0];
                        try {
                            this.handler.streamPlayItemStop(this.stream, item);
                        }
                        catch (Throwable t) {
                            log.error("error notify streamPlaylistItemStop", t);
                        }
                        finally {
                            Red5.setConnectionLocal(null);
                        }
                    }
                };
                break;
            }
            case END: {
                this.nextItem();
                break;
            }
            default: {
                log.warn("Unhandled change: {}", (Object)state);
            }
        }
        if (notifier != null) {
            this.scheduleOnceJob(notifier);
        }
    }

    @Override
    public IPlaylistSubscriberStreamStatistics getStatistics() {
        return this;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getCurrentTimestamp() {
        int lastMessageTs = this.engine.getLastMessageTimestamp();
        if (lastMessageTs >= 0) {
            return 0;
        }
        return lastMessageTs;
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public double getEstimatedBufferFill() {
        int lastMessageTs = this.engine.getLastMessageTimestamp();
        if (lastMessageTs < 0) {
            return 0.0;
        }
        long buffer = this.getClientBufferDuration();
        if (buffer == 0L) {
            return 100.0;
        }
        long delta = System.currentTimeMillis() - this.engine.getPlaybackStart();
        long buffered = (long)lastMessageTs - delta;
        return (double)buffered * 100.0 / (double)buffer;
    }

    public void setMaxPendingVideoFrames(int maxPendingVideoFrames) {
        this.maxPendingVideoFrames = maxPendingVideoFrames;
    }

    public void setMaxSequentialPendingVideoFrames(int maxSequentialPendingVideoFrames) {
        this.maxSequentialPendingVideoFrames = maxSequentialPendingVideoFrames;
    }

    @Override
    public String scheduleOnceJob(IScheduledJob job) {
        String jobName = this.schedulingService.addScheduledOnceJob(10L, job);
        return jobName;
    }

    @Override
    public String scheduleWithFixedDelay(IScheduledJob job, int interval) {
        String jobName = this.schedulingService.addScheduledJob(interval, job);
        this.jobs.add(jobName);
        return jobName;
    }

    @Override
    public void cancelJob(String jobName) {
        this.schedulingService.removeScheduledJob(jobName);
    }

    public class Notifier
    implements IScheduledJob {
        final IPlaylistSubscriberStream stream;
        final IStreamAwareScopeHandler handler;
        final IConnection conn;

        public Notifier(IPlaylistSubscriberStream stream, IStreamAwareScopeHandler handler, IConnection conn) {
            log.trace("Notifier - stream: {} handler: {}", (Object)stream, (Object)handler);
            this.conn = conn;
            this.stream = stream;
            this.handler = handler;
        }

        @Override
        public void execute(ISchedulingService service) {
        }
    }
}

