/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.IAudioStreamCodec;
import org.red5.codec.IStreamCodecInfo;
import org.red5.codec.IVideoStreamCodec;
import org.red5.codec.StreamCodecInfo;
import org.red5.io.amf.Output;
import org.red5.io.utils.ObjectMap;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IPlaylistSubscriberStream;
import org.red5.server.api.stream.ISubscriberStream;
import org.red5.server.api.stream.OperationNotSupportedException;
import org.red5.server.api.stream.StreamState;
import org.red5.server.api.stream.support.DynamicPlayItem;
import org.red5.server.messaging.AbstractMessage;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IFilter;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IMessageInput;
import org.red5.server.messaging.IMessageOutput;
import org.red5.server.messaging.IPassive;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.InMemoryPushPushPipe;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.event.Aggregate;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.stream.IConsumerService;
import org.red5.server.stream.IFrameDropper;
import org.red5.server.stream.IProviderService;
import org.red5.server.stream.ISeekableProvider;
import org.red5.server.stream.IStreamData;
import org.red5.server.stream.IStreamTypeAwareProvider;
import org.red5.server.stream.StreamNotFoundException;
import org.red5.server.stream.StreamService;
import org.red5.server.stream.VideoFrameDropper;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.stream.message.ResetMessage;
import org.red5.server.stream.message.StatusMessage;
import org.slf4j.Logger;

public final class PlayEngine
implements IFilter,
IPushableConsumer,
IPipeConnectionListener {
    private static final Logger log = Red5LoggerFactory.getLogger(PlayEngine.class);
    private final AtomicReference<IMessageInput> msgInReference = new AtomicReference();
    private final AtomicReference<IMessageOutput> msgOutReference = new AtomicReference();
    private final ISubscriberStream subscriberStream;
    private ISchedulingService schedulingService;
    private IConsumerService consumerService;
    private IProviderService providerService;
    private Number streamId;
    private boolean receiveVideo = true;
    private boolean receiveAudio = true;
    private boolean pullMode;
    private String waitLiveJob;
    private AtomicInteger streamStartTS = new AtomicInteger(-1);
    private IPlayItem currentItem;
    private RTMPMessage pendingMessage;
    private int bufferCheckInterval = 0;
    private int underrunTrigger = 10;
    private int maxPendingVideoFrames = 10;
    private int maxSequentialPendingVideoFrames = 10;
    private int numSequentialPendingVideoFrames = 0;
    private IFrameDropper videoFrameDropper = new VideoFrameDropper();
    private int timestampOffset = 0;
    private int lastMessageTs = -1;
    private AtomicLong bytesSent = new AtomicLong(0L);
    private volatile long playbackStart;
    private volatile String pullAndPush;
    private volatile String deferredStop;
    private final AtomicBoolean pushPullRunning = new AtomicBoolean(false);
    private int streamOffset;
    private long nextCheckBufferUnderrun;
    private boolean sendBlankAudio;
    private int playDecision = 3;
    private int bufferedInterframeIdx = -1;
    private ConcurrentLinkedQueue<Runnable> pendingOperations = new ConcurrentLinkedQueue();
    private long droppedPacketsCount;
    private long droppedPacketsCountLastLogTimestamp = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    private long droppedPacketsCountLogInterval = 60000L;

    private PlayEngine(Builder builder) {
        this.subscriberStream = builder.subscriberStream;
        this.schedulingService = builder.schedulingService;
        this.consumerService = builder.consumerService;
        this.providerService = builder.providerService;
        this.streamId = this.subscriberStream.getStreamId();
    }

    public void setBufferCheckInterval(int bufferCheckInterval) {
        this.bufferCheckInterval = bufferCheckInterval;
    }

    public void setUnderrunTrigger(int underrunTrigger) {
        this.underrunTrigger = underrunTrigger;
    }

    void setMessageOut(IMessageOutput msgOut) {
        this.msgOutReference.set(msgOut);
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug("start - subscriber stream state: {}", this.subscriberStream != null ? this.subscriberStream.getState() : null);
        }
        switch (this.subscriberStream.getState()) {
            case UNINIT: {
                this.subscriberStream.setState(StreamState.STOPPED);
                IMessageOutput out = this.consumerService.getConsumerOutput(this.subscriberStream);
                if (this.msgOutReference.compareAndSet(null, out)) {
                    out.subscribe(this, null);
                    break;
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Message output was already set for stream: {}", (Object)this.subscriberStream);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot start in current state: %s", new Object[]{this.subscriberStream.getState()}));
            }
        }
    }

    public void play(IPlayItem item) throws StreamNotFoundException, IllegalStateException, IOException {
        this.play(item, true);
    }

    public void play(IPlayItem item, boolean withReset) throws StreamNotFoundException, IllegalStateException, IOException {
        IMessageInput in = null;
        switch (this.subscriberStream.getState()) {
            case STOPPED: {
                in = this.msgInReference.get();
                if (in == null) break;
                in.unsubscribe(this);
                this.msgInReference.set(null);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot play from non-stopped state");
            }
        }
        int type = (int)(item.getStart() / 1000L);
        log.debug("Type {}", (Object)type);
        IScope thisScope = this.subscriberStream.getScope();
        final String itemName = item.getName();
        IProviderService.INPUT_TYPE sourceType = this.providerService.lookupProviderInput(thisScope, itemName, type);
        boolean isPublishedStream = sourceType == IProviderService.INPUT_TYPE.LIVE;
        boolean isPublishedStreamWait = sourceType == IProviderService.INPUT_TYPE.LIVE_WAIT;
        boolean isFileStream = sourceType == IProviderService.INPUT_TYPE.VOD;
        boolean sendNotifications = true;
        switch (type) {
            case -2: {
                if (isPublishedStream) {
                    this.playDecision = 0;
                    break;
                }
                if (isFileStream) {
                    this.playDecision = 1;
                    break;
                }
                if (!isPublishedStreamWait) break;
                this.playDecision = 2;
                break;
            }
            case -1: {
                if (isPublishedStream) {
                    this.playDecision = 0;
                    break;
                }
                this.playDecision = 2;
                break;
            }
            default: {
                if (!isFileStream) break;
                this.playDecision = 1;
            }
        }
        IMessage msg = null;
        this.currentItem = item;
        long itemLength = item.getLength();
        if (log.isDebugEnabled()) {
            log.debug("Play decision is {} (0=Live, 1=File, 2=Wait, 3=N/A) item length: {}", (Object)this.playDecision, (Object)itemLength);
        }
        switch (this.playDecision) {
            case 0: {
                in = this.providerService.getLiveProviderInput(thisScope, itemName, false);
                if (this.msgInReference.compareAndSet(null, in)) {
                    IVideoStreamCodec videoCodec;
                    IClientBroadcastStream stream;
                    this.videoFrameDropper.reset(3);
                    if (in instanceof IBroadcastScope && (stream = ((IBroadcastScope)in).getClientBroadcastStream()) != null && stream.getCodecInfo() != null && (videoCodec = stream.getCodecInfo().getVideoCodec()) != null) {
                        if (withReset) {
                            this.sendReset();
                            this.sendResetStatus(item);
                            this.sendStartStatus(item);
                        }
                        sendNotifications = false;
                        if (videoCodec.getNumInterframes() > 0 || videoCodec.getKeyframe() != null) {
                            this.bufferedInterframeIdx = 0;
                            this.videoFrameDropper.reset(0);
                        }
                    }
                    in.subscribe(this, null);
                    this.playLive();
                    break;
                }
                this.sendStreamNotFoundStatus(this.currentItem);
                throw new StreamNotFoundException(itemName);
            }
            case 2: {
                in = this.providerService.getLiveProviderInput(thisScope, itemName, true);
                if (this.msgInReference.compareAndSet(null, in)) {
                    if (type == -1 && itemLength >= 0L) {
                        if (log.isDebugEnabled()) {
                            log.debug("Creating wait job for {}", (Object)itemLength);
                        }
                        this.waitLiveJob = this.schedulingService.addScheduledOnceJob(itemLength, new IScheduledJob(){

                            @Override
                            public void execute(ISchedulingService service) {
                                PlayEngine.this.connectToProvider(itemName);
                                PlayEngine.this.waitLiveJob = null;
                                PlayEngine.this.subscriberStream.onChange(StreamState.END, new Object[0]);
                            }
                        });
                        break;
                    }
                    if (type == -2) {
                        if (log.isDebugEnabled()) {
                            log.debug("Creating wait job");
                        }
                        this.waitLiveJob = this.schedulingService.addScheduledOnceJob(15000L, new IScheduledJob(){

                            @Override
                            public void execute(ISchedulingService service) {
                                PlayEngine.this.connectToProvider(itemName);
                                PlayEngine.this.waitLiveJob = null;
                            }
                        });
                        break;
                    }
                    this.connectToProvider(itemName);
                    break;
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Message input already set for {}", (Object)itemName);
                break;
            }
            case 1: {
                in = this.providerService.getVODProviderInput(thisScope, itemName);
                if (this.msgInReference.compareAndSet(null, in)) {
                    if (in.subscribe(this, null)) {
                        msg = this.playVOD(withReset, itemLength);
                        break;
                    }
                    log.error("Input source subscribe failed");
                    throw new IOException(String.format("Subscribe to %s failed", itemName));
                }
                this.sendStreamNotFoundStatus(this.currentItem);
                throw new StreamNotFoundException(itemName);
            }
            default: {
                this.sendStreamNotFoundStatus(this.currentItem);
                throw new StreamNotFoundException(itemName);
            }
        }
        if (sendNotifications) {
            if (withReset) {
                this.sendReset();
                this.sendResetStatus(item);
            }
            this.sendStartStatus(item);
            if (!withReset) {
                this.sendSwitchStatus();
            }
            if (item instanceof DynamicPlayItem) {
                this.sendTransitionStatus();
            }
        }
        if (msg != null) {
            this.sendMessage((RTMPMessage)msg);
        }
        this.subscriberStream.onChange(StreamState.PLAYING, this.currentItem, !this.pullMode);
        if (withReset) {
            log.debug("Resetting times");
            long currentTime = System.currentTimeMillis();
            this.playbackStart = currentTime - (long)this.streamOffset;
            this.nextCheckBufferUnderrun = currentTime + (long)this.bufferCheckInterval;
            if (this.currentItem.getLength() != 0L) {
                this.ensurePullAndPushRunning();
            }
        }
    }

    private final void playLive() throws IOException {
        this.subscriberStream.setState(StreamState.PLAYING);
        IMessageInput in = this.msgInReference.get();
        IMessageOutput out = this.msgOutReference.get();
        if (in != null && out != null) {
            IClientBroadcastStream stream = ((IBroadcastScope)in).getClientBroadcastStream();
            if (stream != null) {
                Notify metaData = stream.getMetaData();
                if (metaData != null) {
                    log.debug("Metadata is available");
                    RTMPMessage metaMsg = RTMPMessage.build(metaData, metaData.getTimestamp());
                    this.sendMessage(metaMsg);
                } else {
                    log.debug("No metadata available");
                }
                IStreamCodecInfo codecInfo = stream.getCodecInfo();
                log.debug("Codec info: {}", (Object)codecInfo);
                if (codecInfo instanceof StreamCodecInfo) {
                    StreamCodecInfo info = (StreamCodecInfo)codecInfo;
                    IVideoStreamCodec videoCodec = info.getVideoCodec();
                    log.debug("Video codec: {}", (Object)videoCodec);
                    if (videoCodec != null) {
                        IVideoStreamCodec.FrameData[] keyFrames;
                        IoBuffer config = videoCodec.getDecoderConfiguration();
                        if (config != null) {
                            log.debug("Decoder configuration is available for {}", (Object)videoCodec.getName());
                            VideoData conf = new VideoData(config, true);
                            log.debug("Pushing video decoder configuration");
                            this.sendMessage(RTMPMessage.build(conf, conf.getTimestamp()));
                        }
                        for (IVideoStreamCodec.FrameData keyframe : keyFrames = videoCodec.getKeyframes()) {
                            log.debug("Keyframe is available");
                            VideoData video = new VideoData(keyframe.getFrame(), true);
                            log.debug("Pushing keyframe");
                            this.sendMessage(RTMPMessage.build(video, video.getTimestamp()));
                        }
                    } else {
                        log.debug("No video decoder configuration available");
                    }
                    IAudioStreamCodec audioCodec = info.getAudioCodec();
                    log.debug("Audio codec: {}", (Object)audioCodec);
                    if (audioCodec != null) {
                        IoBuffer config = audioCodec.getDecoderConfiguration();
                        if (config != null) {
                            log.debug("Decoder configuration is available for {}", (Object)audioCodec.getName());
                            AudioData conf = new AudioData(config.asReadOnlyBuffer());
                            log.debug("Pushing audio decoder configuration");
                            this.sendMessage(RTMPMessage.build(conf, conf.getTimestamp()));
                        }
                    } else {
                        log.debug("No audio decoder configuration available");
                    }
                }
            }
        } else {
            throw new IOException(String.format("A message pipe is null - in: %b out: %b", this.msgInReference == null, this.msgOutReference == null));
        }
    }

    private final IMessage playVOD(boolean withReset, long itemLength) throws IOException {
        IMessageInput in;
        IMessage msg = null;
        this.subscriberStream.setState(StreamState.PLAYING);
        if (withReset) {
            this.releasePendingMessage();
        }
        this.sendVODInitCM(this.currentItem);
        if (this.currentItem.getStart() > 0L) {
            this.streamOffset = this.sendVODSeekCM((int)this.currentItem.getStart());
            if (this.streamOffset == -1) {
                this.streamOffset = (int)this.currentItem.getStart();
            }
        }
        if ((msg = (in = this.msgInReference.get()).pullMessage()) instanceof RTMPMessage) {
            IRTMPEvent body = ((RTMPMessage)msg).getBody();
            if (itemLength == 0L) {
                while (body != null && !(body instanceof VideoData) && (msg = in.pullMessage()) != null && msg instanceof RTMPMessage) {
                    body = ((RTMPMessage)msg).getBody();
                }
            }
            if (body != null) {
                body.setTimestamp(body.getTimestamp() + this.timestampOffset);
            }
        }
        return msg;
    }

    private final void connectToProvider(String itemName) {
        log.debug("Attempting connection to {}", (Object)itemName);
        IMessageInput in = this.msgInReference.get();
        if (in == null) {
            in = this.providerService.getLiveProviderInput(this.subscriberStream.getScope(), itemName, true);
            this.msgInReference.set(in);
        }
        if (in != null) {
            log.debug("Provider: {}", (Object)this.msgInReference.get());
            if (in.subscribe(this, null)) {
                log.debug("Subscribed to {} provider", (Object)itemName);
                try {
                    this.playLive();
                }
                catch (IOException e) {
                    log.warn("Could not play live stream: {}", (Object)itemName, (Object)e);
                }
            } else {
                log.warn("Subscribe to {} provider failed", (Object)itemName);
            }
        } else {
            log.warn("Provider was not found for {}", (Object)itemName);
            StreamService.sendNetStreamStatus(this.subscriberStream.getConnection(), "NetStream.Play.StreamNotFound", "Stream was not found", itemName, "error", this.streamId);
        }
    }

    public void pause(int position) throws IllegalStateException {
        switch (this.subscriberStream.getState()) {
            case STOPPED: 
            case PLAYING: {
                this.subscriberStream.setState(StreamState.PAUSED);
                this.clearWaitJobs();
                this.sendPauseStatus(this.currentItem);
                this.sendClearPing();
                this.subscriberStream.onChange(StreamState.PAUSED, this.currentItem, position);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot pause in current state");
            }
        }
    }

    public void resume(int position) throws IllegalStateException {
        switch (this.subscriberStream.getState()) {
            case PAUSED: {
                this.subscriberStream.setState(StreamState.PLAYING);
                this.sendReset();
                this.sendResumeStatus(this.currentItem);
                if (this.pullMode) {
                    this.sendVODSeekCM(position);
                    this.subscriberStream.onChange(StreamState.RESUMED, this.currentItem, position);
                    this.playbackStart = System.currentTimeMillis() - (long)position;
                    if (this.currentItem.getLength() >= 0L && (long)(position - this.streamOffset) >= this.currentItem.getLength()) {
                        this.stop();
                        break;
                    }
                    this.ensurePullAndPushRunning();
                    break;
                }
                this.subscriberStream.onChange(StreamState.RESUMED, this.currentItem, position);
                this.videoFrameDropper.reset(3);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot resume from non-paused state");
            }
        }
    }

    public void seek(int position) throws IllegalStateException, OperationNotSupportedException {
        this.pendingOperations.add(new SeekRunnable(position));
        this.cancelDeferredStop();
        this.ensurePullAndPushRunning();
    }

    public void stop() throws IllegalStateException {
        if (log.isDebugEnabled()) {
            log.debug("stop - subscriber stream state: {}", this.subscriberStream != null ? this.subscriberStream.getState() : null);
        }
        switch (this.subscriberStream.getState()) {
            case PLAYING: 
            case PAUSED: {
                this.subscriberStream.setState(StreamState.STOPPED);
                IMessageInput in = this.msgInReference.get();
                if (in != null && !this.pullMode) {
                    in.unsubscribe(this);
                    this.msgInReference.set(null);
                }
                this.subscriberStream.onChange(StreamState.STOPPED, this.currentItem);
                this.clearWaitJobs();
                this.cancelDeferredStop();
                if (!(this.subscriberStream instanceof IPlaylistSubscriberStream)) break;
                IPlaylistSubscriberStream pss = (IPlaylistSubscriberStream)this.subscriberStream;
                if (!pss.hasMoreItems()) {
                    this.releasePendingMessage();
                    this.sendCompleteStatus();
                    this.bytesSent.set(0L);
                    this.sendStopStatus(this.currentItem);
                    this.sendClearPing();
                    break;
                }
                if (this.lastMessageTs > 0) {
                    this.timestampOffset = this.lastMessageTs;
                }
                pss.nextItem();
                break;
            }
            case CLOSED: {
                this.clearWaitJobs();
                this.cancelDeferredStop();
                break;
            }
            case STOPPED: {
                log.trace("Already in stopped state");
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot stop in current state: %s", new Object[]{this.subscriberStream.getState()}));
            }
        }
    }

    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("close");
        }
        if (!this.subscriberStream.getState().equals((Object)StreamState.CLOSED)) {
            IMessageInput in = this.msgInReference.get();
            if (in != null) {
                in.unsubscribe(this);
                this.msgInReference.set(null);
            }
            this.subscriberStream.setState(StreamState.CLOSED);
            this.clearWaitJobs();
            this.releasePendingMessage();
            this.lastMessageTs = 0;
            InMemoryPushPushPipe out = (InMemoryPushPushPipe)this.msgOutReference.get();
            if (out != null) {
                List<IConsumer> consumers = out.getConsumers();
                if (log.isDebugEnabled()) {
                    log.debug("Message out consumers: {}", (Object)consumers.size());
                }
                if (!consumers.isEmpty()) {
                    for (IConsumer consumer : consumers) {
                        out.unsubscribe(consumer);
                    }
                }
                this.msgOutReference.set(null);
            }
        } else {
            log.debug("Stream is already in closed state");
        }
    }

    private boolean okayToSendMessage(IRTMPEvent message) {
        if (message instanceof IStreamData) {
            long now = System.currentTimeMillis();
            if (this.isClientBufferFull(now)) {
                return false;
            }
            long pending = this.pendingMessages();
            if (this.bufferCheckInterval > 0 && now >= this.nextCheckBufferUnderrun) {
                if (pending > (long)this.underrunTrigger) {
                    this.sendInsufficientBandwidthStatus(this.currentItem);
                }
                this.nextCheckBufferUnderrun = now + (long)this.bufferCheckInterval;
            }
            return pending <= (long)this.underrunTrigger;
        }
        String itemName = "Undefined";
        if (this.currentItem != null) {
            itemName = this.currentItem.getName();
        }
        Object[] errorItems = new Object[]{message.getClass(), message.getDataType(), itemName};
        throw new RuntimeException(String.format("Expected IStreamData but got %s (type %s) for %s", errorItems));
    }

    private boolean isClientBufferFull(long now) {
        if (this.lastMessageTs > 0) {
            long delta = now - this.playbackStart;
            long buffer = this.subscriberStream.getClientBufferDuration();
            long buffered = (long)this.lastMessageTs - delta;
            log.trace("isClientBufferFull: timestamp {} delta {} buffered {} buffer duration {}", new Object[]{this.lastMessageTs, delta, buffered, buffer});
            if (buffer > 0L && buffered > buffer * 2L) {
                return true;
            }
        }
        return false;
    }

    private boolean isClientBufferEmpty() {
        if (this.lastMessageTs >= 0) {
            long delta = System.currentTimeMillis() - this.playbackStart;
            long buffered = (long)this.lastMessageTs - delta;
            log.trace("isClientBufferEmpty: timestamp {} delta {} buffered {}", new Object[]{this.lastMessageTs, delta, buffered});
            if (buffered < 0L) {
                return true;
            }
        }
        return false;
    }

    private void ensurePullAndPushRunning() {
        log.trace("State should be PLAYING to running this task: {}", (Object)this.subscriberStream.getState());
        if (this.pullMode && this.pullAndPush == null && this.subscriberStream.getState() == StreamState.PLAYING) {
            this.pullAndPush = this.subscriberStream.scheduleWithFixedDelay(new PullAndPushRunnable(), 10);
        }
    }

    private void clearWaitJobs() {
        log.debug("Clear wait jobs");
        if (this.pullAndPush != null) {
            this.subscriberStream.cancelJob(this.pullAndPush);
            this.releasePendingMessage();
            this.pullAndPush = null;
        }
        if (this.waitLiveJob != null) {
            this.schedulingService.removeScheduledJob(this.waitLiveJob);
            this.waitLiveJob = null;
        }
    }

    private void doPushMessage(Status status) {
        StatusMessage message = new StatusMessage();
        message.setBody(status);
        this.doPushMessage(message);
    }

    private void doPushMessage(AbstractMessage message) {
        block6: {
            IMessageOutput out;
            if (log.isTraceEnabled()) {
                String msgType = message.getMessageType();
                log.trace("doPushMessage: {}", (Object)msgType);
            }
            if ((out = this.msgOutReference.get()) != null) {
                try {
                    out.pushMessage(message);
                    if (!(message instanceof RTMPMessage)) break block6;
                    IRTMPEvent body = ((RTMPMessage)message).getBody();
                    this.lastMessageTs = body.getTimestamp();
                    IoBuffer streamData = null;
                    if (body instanceof IStreamData && (streamData = ((IStreamData)((Object)body)).getData()) != null) {
                        this.bytesSent.addAndGet(streamData.limit());
                    }
                }
                catch (IOException err) {
                    log.error("Error while pushing message", (Throwable)err);
                }
            } else {
                log.warn("Push message failed due to null output pipe");
            }
        }
    }

    private void sendMessage(RTMPMessage messageIn) {
        BaseEvent event;
        IRTMPEvent eventIn = messageIn.getBody();
        switch (eventIn.getDataType()) {
            case 22: {
                event = new Aggregate(((Aggregate)eventIn).getData());
                break;
            }
            case 8: {
                event = new AudioData(((AudioData)eventIn).getData());
                break;
            }
            case 9: {
                event = new VideoData(((VideoData)eventIn).getData());
                break;
            }
            default: {
                event = new Notify(((Notify)eventIn).getData());
            }
        }
        int eventTime = eventIn.getTimestamp();
        event.setSourceType(eventIn.getSourceType());
        RTMPMessage messageOut = RTMPMessage.build(event, eventTime);
        if (log.isTraceEnabled()) {
            log.trace("Source type - in: {} out: {}", (Object)eventIn.getSourceType(), (Object)messageOut.getBody().getSourceType());
            long delta = System.currentTimeMillis() - this.playbackStart;
            log.trace("sendMessage: streamStartTS {}, length {}, streamOffset {}, timestamp {} last timestamp {} delta {} buffered {}", new Object[]{this.streamStartTS.get(), this.currentItem.getLength(), this.streamOffset, eventTime, this.lastMessageTs, delta, (long)this.lastMessageTs - delta});
        }
        if (this.playDecision == 1) {
            if (eventTime > 0 && this.streamStartTS.compareAndSet(-1, eventTime)) {
                log.debug("sendMessage: set streamStartTS");
                messageOut.getBody().setTimestamp(0);
            }
            if (this.currentItem.getLength() >= 0L) {
                int duration = eventTime - this.streamStartTS.get();
                if (log.isTraceEnabled()) {
                    log.trace("sendMessage duration={} length={}", (Object)duration, (Object)this.currentItem.getLength());
                }
                if ((long)(duration - this.streamOffset) >= this.currentItem.getLength()) {
                    this.stop();
                    return;
                }
            }
        } else {
            int startTs;
            if (eventTime > 0 && this.streamStartTS.compareAndSet(-1, eventTime)) {
                log.debug("sendMessage: set streamStartTS");
            }
            if ((startTs = this.streamStartTS.get()) > 0) {
                messageOut.getBody().setTimestamp(eventTime -= startTs);
                if (log.isTraceEnabled()) {
                    log.trace("sendMessage (updated): streamStartTS={}, length={}, streamOffset={}, timestamp={}", new Object[]{startTs, this.currentItem.getLength(), this.streamOffset, eventTime});
                }
            }
        }
        this.doPushMessage(messageOut);
    }

    private void sendClearPing() {
        Ping eof = new Ping();
        eof.setEventType((short)1);
        eof.setValue2(this.streamId);
        RTMPMessage eofMsg = RTMPMessage.build(eof);
        this.doPushMessage(eofMsg);
    }

    private void sendReset() {
        if (this.pullMode) {
            Ping recorded = new Ping();
            recorded.setEventType((short)4);
            recorded.setValue2(this.streamId);
            RTMPMessage recordedMsg = RTMPMessage.build(recorded);
            this.doPushMessage(recordedMsg);
        }
        Ping begin = new Ping();
        begin.setEventType((short)0);
        begin.setValue2(this.streamId);
        RTMPMessage beginMsg = RTMPMessage.build(begin);
        this.doPushMessage(beginMsg);
        ResetMessage reset = new ResetMessage();
        this.doPushMessage(reset);
    }

    private void sendResetStatus(IPlayItem item) {
        Status reset = new Status("NetStream.Play.Reset");
        reset.setClientid(this.streamId);
        reset.setDetails(item.getName());
        reset.setDesciption(String.format("Playing and resetting %s.", item.getName()));
        this.doPushMessage(reset);
    }

    private void sendStartStatus(IPlayItem item) {
        Status start = new Status("NetStream.Play.Start");
        start.setClientid(this.streamId);
        start.setDetails(item.getName());
        start.setDesciption(String.format("Started playing %s.", item.getName()));
        this.doPushMessage(start);
    }

    private void sendStopStatus(IPlayItem item) {
        Status stop = new Status("NetStream.Play.Stop");
        stop.setClientid(this.streamId);
        stop.setDesciption(String.format("Stopped playing %s.", item.getName()));
        stop.setDetails(item.getName());
        this.doPushMessage(stop);
    }

    private void sendOnPlayStatus(String code, int duration, long bytes) {
        if (log.isDebugEnabled()) {
            log.debug("Sending onPlayStatus - code: {} duration: {} bytes: {}", new Object[]{code, duration, bytes});
        }
        IoBuffer buf = IoBuffer.allocate((int)102);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onPlayStatus");
        ObjectMap args = new ObjectMap();
        args.put((Object)"code", (Object)code);
        args.put((Object)"level", (Object)"status");
        args.put((Object)"duration", (Object)duration);
        args.put((Object)"bytes", (Object)bytes);
        if ("NetStream.Play.TransitionComplete".equals(code)) {
            args.put((Object)"clientId", (Object)this.streamId);
            args.put((Object)"details", (Object)this.currentItem.getName());
            args.put((Object)"description", (Object)String.format("Transitioned to %s", this.currentItem.getName()));
            args.put((Object)"isFastPlay", (Object)false);
        }
        out.writeObject((Map)args);
        buf.flip();
        Notify event = new Notify(buf, "onPlayStatus");
        if (this.lastMessageTs > 0) {
            event.setTimestamp(this.lastMessageTs);
        } else {
            event.setTimestamp(0);
        }
        RTMPMessage msg = RTMPMessage.build(event);
        this.doPushMessage(msg);
    }

    private void sendSwitchStatus() {
        this.sendOnPlayStatus("NetStream.Play.Switch", 1, this.bytesSent.get());
    }

    private void sendTransitionStatus() {
        this.sendOnPlayStatus("NetStream.Play.TransitionComplete", 0, this.bytesSent.get());
    }

    private void sendCompleteStatus() {
        int duration;
        int n = duration = this.lastMessageTs > 0 ? Math.max(0, this.lastMessageTs - this.streamStartTS.get()) : 0;
        if (log.isDebugEnabled()) {
            log.debug("sendCompleteStatus - duration: {} bytes sent: {}", (Object)duration, (Object)this.bytesSent.get());
        }
        this.sendOnPlayStatus("NetStream.Play.Complete", duration, this.bytesSent.get());
    }

    private void sendSeekStatus(IPlayItem item, int position) {
        Status seek = new Status("NetStream.Seek.Notify");
        seek.setClientid(this.streamId);
        seek.setDetails(item.getName());
        seek.setDesciption(String.format("Seeking %d (stream ID: %d).", position, this.streamId));
        this.doPushMessage(seek);
    }

    private void sendPauseStatus(IPlayItem item) {
        Status pause = new Status("NetStream.Pause.Notify");
        pause.setClientid(this.streamId);
        pause.setDetails(item.getName());
        this.doPushMessage(pause);
    }

    private void sendResumeStatus(IPlayItem item) {
        Status resume = new Status("NetStream.Unpause.Notify");
        resume.setClientid(this.streamId);
        resume.setDetails(item.getName());
        this.doPushMessage(resume);
    }

    private void sendPublishedStatus(IPlayItem item) {
        Status published = new Status("NetStream.Play.PublishNotify");
        published.setClientid(this.streamId);
        published.setDetails(item.getName());
        this.doPushMessage(published);
    }

    private void sendUnpublishedStatus(IPlayItem item) {
        Status unpublished = new Status("NetStream.Play.UnpublishNotify");
        unpublished.setClientid(this.streamId);
        unpublished.setDetails(item.getName());
        this.doPushMessage(unpublished);
    }

    private void sendStreamNotFoundStatus(IPlayItem item) {
        Status notFound = new Status("NetStream.Play.StreamNotFound");
        notFound.setClientid(this.streamId);
        notFound.setLevel("error");
        notFound.setDetails(item.getName());
        this.doPushMessage(notFound);
    }

    private void sendInsufficientBandwidthStatus(IPlayItem item) {
        Status insufficientBW = new Status("NetStream.Play.InsufficientBW");
        insufficientBW.setClientid(this.streamId);
        insufficientBW.setLevel("warning");
        insufficientBW.setDetails(item.getName());
        insufficientBW.setDesciption("Data is playing behind the normal speed.");
        this.doPushMessage(insufficientBW);
    }

    private void sendVODInitCM(IPlayItem item) {
        OOBControlMessage oobCtrlMsg = new OOBControlMessage();
        oobCtrlMsg.setTarget(IPassive.KEY);
        oobCtrlMsg.setServiceName("init");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("startTS", (int)item.getStart());
        oobCtrlMsg.setServiceParamMap(paramMap);
        this.msgInReference.get().sendOOBControlMessage(this, oobCtrlMsg);
    }

    private int sendVODSeekCM(int position) {
        OOBControlMessage oobCtrlMsg = new OOBControlMessage();
        oobCtrlMsg.setTarget(ISeekableProvider.KEY);
        oobCtrlMsg.setServiceName("seek");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("position", position);
        oobCtrlMsg.setServiceParamMap(paramMap);
        this.msgInReference.get().sendOOBControlMessage(this, oobCtrlMsg);
        if (oobCtrlMsg.getResult() instanceof Integer) {
            return (Integer)oobCtrlMsg.getResult();
        }
        return -1;
    }

    private boolean sendCheckVideoCM() {
        OOBControlMessage oobCtrlMsg = new OOBControlMessage();
        oobCtrlMsg.setTarget(IStreamTypeAwareProvider.KEY);
        oobCtrlMsg.setServiceName("hasVideo");
        this.msgInReference.get().sendOOBControlMessage(this, oobCtrlMsg);
        if (oobCtrlMsg.getResult() instanceof Boolean) {
            return (Boolean)oobCtrlMsg.getResult();
        }
        return false;
    }

    @Override
    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
        if ("ConnectionConsumer".equals(oobCtrlMsg.getTarget()) && source instanceof IProvider) {
            IMessageOutput out = this.msgOutReference.get();
            if (out != null) {
                out.sendOOBControlMessage((IProvider)source, oobCtrlMsg);
            } else {
                log.warn("Output is not available, message cannot be sent");
                this.close();
            }
        }
    }

    @Override
    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case PROVIDER_CONNECT_PUSH: {
                if (event.getProvider() == this) break;
                if (this.waitLiveJob != null) {
                    this.schedulingService.removeScheduledJob(this.waitLiveJob);
                    this.waitLiveJob = null;
                }
                this.sendPublishedStatus(this.currentItem);
                break;
            }
            case PROVIDER_DISCONNECT: {
                if (this.pullMode) {
                    this.sendStopStatus(this.currentItem);
                    break;
                }
                this.sendUnpublishedStatus(this.currentItem);
                break;
            }
            case CONSUMER_CONNECT_PULL: {
                if (event.getConsumer() != this) break;
                this.pullMode = true;
                break;
            }
            case CONSUMER_CONNECT_PUSH: {
                if (event.getConsumer() != this) break;
                this.pullMode = false;
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug("Unhandled pipe event: {}", (Object)event);
            }
        }
    }

    private boolean shouldLogPacketDrop() {
        long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        if (now - this.droppedPacketsCountLastLogTimestamp > this.droppedPacketsCountLogInterval) {
            this.droppedPacketsCountLastLogTimestamp = now;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void pushMessage(IPipe pipe, IMessage message) throws IOException {
        String sessionId = this.subscriberStream.getConnection().getSessionId();
        if (message instanceof RTMPMessage) {
            IMessageInput msgIn = this.msgInReference.get();
            RTMPMessage rtmpMessage = (RTMPMessage)message;
            IRTMPEvent body = rtmpMessage.getBody();
            if (!(body instanceof IStreamData)) throw new RuntimeException(String.format("Expected IStreamData but got %s (type %s)", body.getClass(), body.getDataType()));
            if (this.subscriberStream.getState() == StreamState.PAUSED) {
                if (log.isInfoEnabled() && this.shouldLogPacketDrop()) {
                    log.info("Dropping packet because we are paused. sessionId={} stream={} count={}", new Object[]{sessionId, this.subscriberStream.getBroadcastStreamPublishName(), this.droppedPacketsCount});
                }
                this.videoFrameDropper.dropPacket(rtmpMessage);
                return;
            }
            if (body instanceof VideoData && body.getSourceType() == 1) {
                IVideoStreamCodec videoCodec;
                IClientBroadcastStream stream;
                if (msgIn instanceof IBroadcastScope && (stream = ((IBroadcastScope)msgIn).getClientBroadcastStream()) != null && stream.getCodecInfo() != null && (videoCodec = stream.getCodecInfo().getVideoCodec()) != null && videoCodec.canDropFrames()) {
                    if (!this.receiveVideo) {
                        this.videoFrameDropper.dropPacket(rtmpMessage);
                        ++this.droppedPacketsCount;
                        if (!log.isInfoEnabled() || !this.shouldLogPacketDrop()) return;
                        log.info("Drop packet. Failed to acquire token or no video. sessionId={} stream={} count={}", new Object[]{sessionId, this.subscriberStream.getBroadcastStreamPublishName(), this.droppedPacketsCount});
                        return;
                    }
                    long pendingVideos = this.pendingVideoMessages();
                    if (log.isTraceEnabled()) {
                        log.trace("Pending messages sessionId={} pending={} threshold={} sequential={} stream={}, count={}", new Object[]{sessionId, pendingVideos, this.maxPendingVideoFrames, this.numSequentialPendingVideoFrames, this.subscriberStream.getBroadcastStreamPublishName(), this.droppedPacketsCount});
                    }
                    if (!this.videoFrameDropper.canSendPacket(rtmpMessage, pendingVideos)) {
                        ++this.droppedPacketsCount;
                        if (!log.isInfoEnabled() || !this.shouldLogPacketDrop()) return;
                        log.info("Frame dropper says to drop packet. sessionId={} stream={} count={}", new Object[]{sessionId, this.subscriberStream.getBroadcastStreamPublishName(), this.droppedPacketsCount});
                        return;
                    }
                    this.numSequentialPendingVideoFrames = pendingVideos > 1L ? ++this.numSequentialPendingVideoFrames : 0;
                    if (pendingVideos > (long)this.maxPendingVideoFrames || this.numSequentialPendingVideoFrames > this.maxSequentialPendingVideoFrames) {
                        ++this.droppedPacketsCount;
                        if (log.isInfoEnabled() && this.shouldLogPacketDrop()) {
                            log.info("Drop packet. Pending above threshold. sessionId={} pending={} threshold={} sequential={} stream={} count={}", new Object[]{sessionId, pendingVideos, this.maxPendingVideoFrames, this.numSequentialPendingVideoFrames, this.subscriberStream.getBroadcastStreamPublishName(), this.droppedPacketsCount});
                        }
                        long now = System.currentTimeMillis();
                        if (this.bufferCheckInterval > 0 && now >= this.nextCheckBufferUnderrun) {
                            this.sendInsufficientBandwidthStatus(this.currentItem);
                            this.nextCheckBufferUnderrun = now + (long)this.bufferCheckInterval;
                        }
                        this.videoFrameDropper.dropPacket(rtmpMessage);
                        return;
                    }
                    if (this.bufferedInterframeIdx > -1) {
                        IVideoStreamCodec.FrameData fd;
                        if ((fd = videoCodec.getInterframe(this.bufferedInterframeIdx++)) != null) {
                            VideoData interframe = new VideoData(fd.getFrame());
                            interframe.setTimestamp(body.getTimestamp());
                            rtmpMessage = RTMPMessage.build(interframe);
                        } else {
                            this.bufferedInterframeIdx = -1;
                        }
                    }
                }
            } else if (body instanceof AudioData) {
                if (!this.receiveAudio && this.sendBlankAudio) {
                    this.sendBlankAudio = false;
                    body = new AudioData();
                    if (this.lastMessageTs > 0) {
                        body.setTimestamp(this.lastMessageTs);
                    } else {
                        body.setTimestamp(0);
                    }
                    rtmpMessage = RTMPMessage.build(body);
                } else if (!this.receiveAudio) {
                    return;
                }
            }
            this.sendMessage(rtmpMessage);
            return;
        } else if (message instanceof ResetMessage) {
            this.sendReset();
            return;
        } else {
            this.msgOutReference.get().pushMessage(message);
        }
    }

    private long pendingVideoMessages() {
        IMessageOutput out = this.msgOutReference.get();
        if (out != null) {
            OOBControlMessage pendingRequest = new OOBControlMessage();
            pendingRequest.setTarget("ConnectionConsumer");
            pendingRequest.setServiceName("pendingVideoCount");
            out.sendOOBControlMessage(this, pendingRequest);
            if (pendingRequest.getResult() != null) {
                return (Long)pendingRequest.getResult();
            }
        }
        return 0L;
    }

    private long pendingMessages() {
        return this.subscriberStream.getConnection().getPendingMessages();
    }

    public boolean isPullMode() {
        return this.pullMode;
    }

    public boolean isPaused() {
        return this.subscriberStream.isPaused();
    }

    public int getLastMessageTimestamp() {
        return this.lastMessageTs;
    }

    public long getPlaybackStart() {
        return this.playbackStart;
    }

    public void sendBlankAudio(boolean sendBlankAudio) {
        this.sendBlankAudio = sendBlankAudio;
    }

    public boolean receiveAudio() {
        return this.receiveAudio;
    }

    public boolean receiveAudio(boolean receive) {
        boolean oldValue = this.receiveAudio;
        if (this.receiveAudio != receive) {
            this.receiveAudio = receive;
        }
        return oldValue;
    }

    public boolean receiveVideo() {
        return this.receiveVideo;
    }

    public boolean receiveVideo(boolean receive) {
        boolean oldValue = this.receiveVideo;
        if (this.receiveVideo != receive) {
            this.receiveVideo = receive;
        }
        return oldValue;
    }

    private void releasePendingMessage() {
        if (this.pendingMessage != null) {
            IRTMPEvent body = this.pendingMessage.getBody();
            if (body instanceof IStreamData && ((IStreamData)((Object)body)).getData() != null) {
                ((IStreamData)((Object)body)).getData().free();
            }
            this.pendingMessage = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkSendMessageEnabled(RTMPMessage message) {
        IRTMPEvent body = message.getBody();
        if (!this.receiveAudio && body instanceof AudioData) {
            ((IStreamData)((Object)body)).getData().free();
            if (!this.sendBlankAudio) return false;
            this.sendBlankAudio = false;
            body = new AudioData();
            if (this.lastMessageTs >= 0) {
                body.setTimestamp(this.lastMessageTs - this.timestampOffset);
            } else {
                body.setTimestamp(-this.timestampOffset);
            }
            message = RTMPMessage.build(body);
            return true;
        } else {
            if (this.receiveVideo || !(body instanceof VideoData)) return true;
            ((IStreamData)((Object)body)).getData().free();
            return false;
        }
    }

    private void runDeferredStop() {
        this.clearWaitJobs();
        log.trace("Ran deferred stop");
        if (this.deferredStop == null) {
            this.deferredStop = this.subscriberStream.scheduleWithFixedDelay(new DeferredStopRunnable(), 100);
        }
    }

    private void cancelDeferredStop() {
        log.debug("Cancel deferred stop");
        if (this.deferredStop != null) {
            this.subscriberStream.cancelJob(this.deferredStop);
            this.deferredStop = null;
        }
    }

    public void setMaxPendingVideoFrames(int maxPendingVideoFrames) {
        this.maxPendingVideoFrames = maxPendingVideoFrames;
    }

    public void setMaxSequentialPendingVideoFrames(int maxSequentialPendingVideoFrames) {
        this.maxSequentialPendingVideoFrames = maxSequentialPendingVideoFrames;
    }

    private class DeferredStopRunnable
    implements IScheduledJob {
        private DeferredStopRunnable() {
        }

        @Override
        public void execute(ISchedulingService service) {
            if (PlayEngine.this.isClientBufferEmpty()) {
                log.trace("Buffer is empty, stop will proceed");
                PlayEngine.this.stop();
            }
        }
    }

    private final class PullAndPushRunnable
    implements IScheduledJob {
        private PullAndPushRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void execute(ISchedulingService svc) {
            if (PlayEngine.this.pushPullRunning.compareAndSet(false, true)) {
                try {
                    Runnable worker = null;
                    while (!PlayEngine.this.pendingOperations.isEmpty()) {
                        Runnable tmp;
                        log.debug("Pending operations: {}", (Object)PlayEngine.this.pendingOperations.size());
                        worker = (Runnable)PlayEngine.this.pendingOperations.remove();
                        log.debug("Worker: {}", (Object)worker);
                        while (worker instanceof SeekRunnable && (tmp = (Runnable)PlayEngine.this.pendingOperations.peek()) != null && tmp instanceof SeekRunnable) {
                            worker = (Runnable)PlayEngine.this.pendingOperations.remove();
                        }
                        if (worker == null) continue;
                        log.debug("Executing pending operation");
                        worker.run();
                    }
                    if (PlayEngine.this.subscriberStream.getState() != StreamState.PLAYING || !PlayEngine.this.pullMode) return;
                    if (PlayEngine.this.pendingMessage != null) {
                        IRTMPEvent body = PlayEngine.this.pendingMessage.getBody();
                        if (!PlayEngine.this.okayToSendMessage(body)) {
                            return;
                        }
                        PlayEngine.this.sendMessage(PlayEngine.this.pendingMessage);
                        PlayEngine.this.releasePendingMessage();
                        return;
                    }
                    IMessage msg = null;
                    IMessageInput in = (IMessageInput)PlayEngine.this.msgInReference.get();
                    do {
                        if ((msg = in.pullMessage()) != null) {
                            RTMPMessage rtmpMessage;
                            if (!(msg instanceof RTMPMessage) || !PlayEngine.this.checkSendMessageEnabled(rtmpMessage = (RTMPMessage)msg)) continue;
                            IRTMPEvent body = rtmpMessage.getBody();
                            body.setTimestamp(body.getTimestamp() + PlayEngine.this.timestampOffset);
                            if (PlayEngine.this.okayToSendMessage(body)) {
                                log.trace("ts: {}", (Object)rtmpMessage.getBody().getTimestamp());
                                PlayEngine.this.sendMessage(rtmpMessage);
                                IoBuffer data = ((IStreamData)((Object)body)).getData();
                                if (data != null) {
                                    data.free();
                                }
                            } else {
                                PlayEngine.this.pendingMessage = rtmpMessage;
                            }
                            PlayEngine.this.ensurePullAndPushRunning();
                            return;
                        }
                        log.debug("Ran out of packets");
                        PlayEngine.this.runDeferredStop();
                    } while (msg != null);
                    return;
                }
                catch (IOException err) {
                    log.error("Error while getting message", (Throwable)err);
                    PlayEngine.this.runDeferredStop();
                    return;
                }
                finally {
                    PlayEngine.this.pushPullRunning.compareAndSet(true, false);
                }
            } else {
                log.debug("Push / pull already running");
            }
        }
    }

    private final class SeekRunnable
    implements Runnable {
        private final int position;

        SeekRunnable(int position) {
            this.position = position;
        }

        @Override
        public void run() {
            log.trace("Seek: {}", (Object)this.position);
            boolean startPullPushThread = false;
            switch (PlayEngine.this.subscriberStream.getState()) {
                case PLAYING: {
                    startPullPushThread = true;
                }
                case STOPPED: 
                case PAUSED: {
                    if (!PlayEngine.this.pullMode) {
                        throw new RuntimeException();
                    }
                    PlayEngine.this.releasePendingMessage();
                    PlayEngine.this.clearWaitJobs();
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot seek in current state");
                }
            }
            PlayEngine.this.sendClearPing();
            PlayEngine.this.sendReset();
            PlayEngine.this.sendSeekStatus(PlayEngine.this.currentItem, this.position);
            PlayEngine.this.sendStartStatus(PlayEngine.this.currentItem);
            int seekPos = PlayEngine.this.sendVODSeekCM(this.position);
            if (seekPos == -1) {
                seekPos = this.position;
            }
            log.trace("Current playback start: {}", (Object)PlayEngine.this.playbackStart);
            PlayEngine.this.playbackStart = System.currentTimeMillis() - (long)seekPos;
            log.trace("Playback start: {} seek pos: {}", (Object)PlayEngine.this.playbackStart, (Object)seekPos);
            PlayEngine.this.subscriberStream.onChange(StreamState.SEEK, PlayEngine.this.currentItem, seekPos);
            boolean messageSent = false;
            block6 : switch (PlayEngine.this.subscriberStream.getState()) {
                case STOPPED: 
                case PAUSED: {
                    if (!PlayEngine.this.sendCheckVideoCM()) break;
                    IMessage msg = null;
                    IMessageInput in = (IMessageInput)PlayEngine.this.msgInReference.get();
                    do {
                        RTMPMessage rtmpMessage;
                        IRTMPEvent body;
                        try {
                            msg = in.pullMessage();
                        }
                        catch (Throwable err) {
                            log.error("Error while pulling message", err);
                            break block6;
                        }
                        if (!(msg instanceof RTMPMessage) || !((body = (rtmpMessage = (RTMPMessage)msg).getBody()) instanceof VideoData) || ((VideoData)body).getFrameType() != VideoData.FrameType.KEYFRAME) continue;
                        PlayEngine.this.doPushMessage(rtmpMessage);
                        rtmpMessage.getBody().release();
                        messageSent = true;
                        PlayEngine.this.lastMessageTs = body.getTimestamp();
                        break block6;
                    } while (msg != null);
                }
            }
            if (PlayEngine.this.currentItem.getLength() >= 0L && (long)(this.position - PlayEngine.this.streamOffset) >= PlayEngine.this.currentItem.getLength()) {
                PlayEngine.this.stop();
            }
            if (!messageSent) {
                log.debug("Sending blank audio packet");
                AudioData audio = new AudioData();
                audio.setTimestamp(seekPos);
                audio.setHeader(new Header());
                audio.getHeader().setTimer(seekPos);
                RTMPMessage audioMessage = RTMPMessage.build(audio);
                PlayEngine.this.lastMessageTs = seekPos;
                PlayEngine.this.doPushMessage(audioMessage);
                audioMessage.getBody().release();
            }
            if (!messageSent && PlayEngine.this.subscriberStream.getState() == StreamState.PLAYING) {
                boolean isRTMPTPlayback = PlayEngine.this.subscriberStream.getConnection().getProtocol().equals("rtmpt");
                if (PlayEngine.this.sendCheckVideoCM()) {
                    long clientBuffer = PlayEngine.this.subscriberStream.getClientBufferDuration();
                    IMessage msg = null;
                    IMessageInput in = (IMessageInput)PlayEngine.this.msgInReference.get();
                    int msgSent = 0;
                    do {
                        try {
                            msg = in.pullMessage();
                            if (!(msg instanceof RTMPMessage)) continue;
                            RTMPMessage rtmpMessage = (RTMPMessage)msg;
                            IRTMPEvent body = rtmpMessage.getBody();
                            if ((long)body.getTimestamp() >= (long)this.position + clientBuffer * 2L) {
                                PlayEngine.this.releasePendingMessage();
                                if (!PlayEngine.this.checkSendMessageEnabled(rtmpMessage)) break;
                                PlayEngine.this.pendingMessage = rtmpMessage;
                                break;
                            }
                            if (!PlayEngine.this.checkSendMessageEnabled(rtmpMessage)) continue;
                            ++msgSent;
                            PlayEngine.this.sendMessage(rtmpMessage);
                        }
                        catch (Throwable err) {
                            log.error("Error while pulling message", err);
                            break;
                        }
                    } while (!isRTMPTPlayback && msg != null);
                    log.trace("msgSent: {}", (Object)msgSent);
                    PlayEngine.this.playbackStart = System.currentTimeMillis() - (long)PlayEngine.this.lastMessageTs;
                }
            }
            if (startPullPushThread) {
                PlayEngine.this.ensurePullAndPushRunning();
            }
        }
    }

    public static final class Builder {
        private ISubscriberStream subscriberStream;
        private ISchedulingService schedulingService;
        private IConsumerService consumerService;
        private IProviderService providerService;

        public Builder(ISubscriberStream subscriberStream, ISchedulingService schedulingService, IConsumerService consumerService, IProviderService providerService) {
            this.subscriberStream = subscriberStream;
            this.schedulingService = schedulingService;
            this.consumerService = consumerService;
            this.providerService = providerService;
        }

        public PlayEngine build() {
            return new PlayEngine(this);
        }
    }
}

