/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Input;
import org.red5.io.object.Output;
import org.red5.io.object.Serializer;
import org.red5.server.AttributeStore;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.Red5;
import org.red5.server.api.event.IEventListener;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.api.statistics.ISharedObjectStatistics;
import org.red5.server.api.statistics.support.StatisticsCounter;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.SharedObjectEvent;
import org.red5.server.so.SharedObjectMessage;
import org.red5.server.so.SharedObjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedObject
extends AttributeStore
implements ISharedObjectStatistics,
IPersistable,
Constants {
    protected static Logger log = LoggerFactory.getLogger(SharedObject.class);
    protected String name = "";
    protected String path = "";
    protected boolean persistent;
    protected IPersistenceStore storage;
    protected AtomicInteger version = new AtomicInteger(1);
    protected AtomicInteger updateCounter = new AtomicInteger();
    protected AtomicBoolean modified = new AtomicBoolean();
    protected long lastModified = -1L;
    protected SharedObjectMessage ownerMessage;
    protected volatile transient ConcurrentSkipListSet<ISharedObjectEvent> syncEvents = new ConcurrentSkipListSet();
    protected volatile transient CopyOnWriteArraySet<IEventListener> listeners = new CopyOnWriteArraySet();
    protected IEventListener source;
    protected AtomicInteger acquireCount = new AtomicInteger();
    private long creationTime;
    protected transient StatisticsCounter listenerStats = new StatisticsCounter();
    protected AtomicInteger changeStats = new AtomicInteger();
    protected AtomicInteger deleteStats = new AtomicInteger();
    protected AtomicInteger sendStats = new AtomicInteger();
    protected AtomicBoolean closed = new AtomicBoolean(false);

    public SharedObject() {
        this.ownerMessage = new SharedObjectMessage(null, null, -1, false);
        this.creationTime = System.currentTimeMillis();
    }

    public SharedObject(Input input) throws IOException {
        this();
        this.deserialize(input);
    }

    public SharedObject(String name, String path, boolean persistent) {
        this.name = name;
        this.path = path;
        this.persistent = persistent;
        this.ownerMessage = new SharedObjectMessage(null, name, 0, persistent);
        this.creationTime = System.currentTimeMillis();
    }

    public SharedObject(String name, String path, boolean persistent, IPersistenceStore storage) {
        this(name, path, persistent);
        this.setStore(storage);
    }

    public SharedObject(Map<String, Object> data, String name, String path, boolean persistent) {
        this(name, path, persistent);
        this.attributes.putAll(data);
    }

    public SharedObject(Map<String, Object> data, String name, String path, boolean persistent, IPersistenceStore storage) {
        this(data, name, path, persistent);
        this.setStore(storage);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException(String.format("Name change not supported; current name: %s", this.getName()));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getType() {
        return ScopeType.SHARED_OBJECT.toString();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void setPersistent(boolean persistent) {
        log.debug("setPersistent: {}", (Object)persistent);
        this.persistent = persistent;
    }

    protected synchronized void sendUpdates() {
        TreeSet<ISharedObjectEvent> events;
        log.debug("sendUpdates");
        int currentVersion = this.getVersion();
        log.debug("Current version: {}", (Object)currentVersion);
        String name = this.getName();
        Set<ISharedObjectEvent> ownerEvents = this.ownerMessage.getEvents();
        if (!ownerEvents.isEmpty()) {
            events = new TreeSet<ISharedObjectEvent>(ownerEvents);
            ownerEvents.removeAll(events);
            if (this.source != null) {
                RTMPConnection con = (RTMPConnection)this.source;
                SharedObjectService.submitTask(() -> {
                    Red5.setConnectionLocal(con);
                    con.sendSharedObjectMessage(name, currentVersion, this.persistent, events);
                    Red5.setConnectionLocal(null);
                });
            }
        } else if (log.isTraceEnabled()) {
            log.trace("No owner events to send");
        }
        if (!this.syncEvents.isEmpty()) {
            events = new TreeSet<ISharedObjectEvent>((SortedSet<ISharedObjectEvent>)this.syncEvents);
            this.syncEvents.removeAll(events);
            Set<IEventListener> listeners = this.getListeners();
            if (log.isDebugEnabled()) {
                log.debug("Listeners: {}", listeners);
            }
            listeners.stream().filter(listener -> listener != this.source).forEach(listener -> {
                RTMPConnection con = (RTMPConnection)listener;
                if (con.isConnected()) {
                    SharedObjectService.submitTask(() -> {
                        Red5.setConnectionLocal(con);
                        con.sendSharedObjectMessage(name, currentVersion, this.persistent, events);
                        Red5.setConnectionLocal(null);
                    });
                } else {
                    log.debug("Skipping {} connection: {}", (Object)RTMP.states[con.getStateCode()], (Object)con.getId());
                    if (con.isDisconnected()) {
                        this.unregister(con);
                    }
                }
            });
        } else if (log.isTraceEnabled()) {
            log.trace("No sync events to send");
        }
    }

    protected void notifyModified() {
        log.debug("notifyModified - modified: {} update counter: {}", (Object)this.modified.get(), (Object)this.updateCounter.get());
        if (this.updateCounter.get() == 0) {
            if (this.modified.get()) {
                this.updateVersion();
                this.lastModified = System.currentTimeMillis();
                if (this.storage == null || !this.storage.save(this)) {
                    log.warn("Could not store shared object");
                }
            }
            this.sendUpdates();
            this.modified.compareAndSet(true, false);
        }
    }

    protected void returnError(String message) {
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_STATUS, "error", message);
    }

    protected void returnAttributeValue(String name) {
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_UPDATE_DATA, name, this.getAttribute(name));
    }

    @Override
    public Object getAttribute(String name, Object value) {
        log.debug("getAttribute - name: {} value: {}", (Object)name, value);
        Object result = null;
        if (name != null && (result = this.attributes.putIfAbsent(name, value)) == null) {
            this.modified.set(true);
            SharedObjectEvent event = new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_UPDATE_DATA, name, value);
            if (this.ownerMessage.addEvent(event) && this.syncEvents.add(event)) {
                this.notifyModified();
                this.changeStats.incrementAndGet();
            }
            result = value;
        }
        return result;
    }

    @Override
    public boolean setAttribute(String name, Object value) {
        log.debug("setAttribute - name: {} value: {}", (Object)name, value);
        boolean result = true;
        if (this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_UPDATE_ATTRIBUTE, name, null)) {
            if (value == null && super.removeAttribute(name)) {
                this.modified.set(true);
                this.syncEvents.add(new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_DELETE_DATA, name, null));
                this.deleteStats.incrementAndGet();
            } else if (value != null) {
                boolean setAttr = super.setAttribute(name, value);
                log.debug("Set attribute?: {} modified: {}", (Object)setAttr, (Object)this.modified.get());
                this.modified.set(true);
                this.syncEvents.add(new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_UPDATE_DATA, name, value));
                this.changeStats.incrementAndGet();
            } else {
                result = false;
            }
            this.notifyModified();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAttributes(Map<String, Object> values) {
        int successes = 0;
        if (values != null) {
            this.beginUpdate();
            try {
                for (Map.Entry<String, Object> entry : values.entrySet()) {
                    if (!this.setAttribute(entry.getKey(), entry.getValue())) continue;
                    ++successes;
                }
            }
            finally {
                this.endUpdate();
            }
        }
        return successes == values.size();
    }

    @Override
    public boolean setAttributes(IAttributeStore values) {
        if (values != null) {
            return this.setAttributes(values.getAttributes());
        }
        return false;
    }

    @Override
    public boolean removeAttribute(String name) {
        boolean result = true;
        SharedObjectEvent event = new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_DELETE_DATA, name, null);
        if (this.ownerMessage.addEvent(event)) {
            if (super.removeAttribute(name)) {
                this.modified.set(true);
                this.syncEvents.add(event);
                this.deleteStats.incrementAndGet();
            } else {
                result = false;
            }
            this.notifyModified();
        }
        return result;
    }

    protected void sendMessage(String handler, List<?> arguments) {
        SharedObjectEvent event = new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_SEND_MESSAGE, handler, arguments);
        if (this.ownerMessage.addEvent(event)) {
            this.syncEvents.add(event);
            this.sendStats.incrementAndGet();
            if (log.isTraceEnabled()) {
                log.trace("Send message: {}", arguments);
            }
        }
    }

    public Map<String, Object> getData() {
        return this.getAttributes();
    }

    @Override
    public int getVersion() {
        return this.version.get();
    }

    private void updateVersion() {
        this.version.incrementAndGet();
    }

    @Override
    public void removeAttributes() {
        Set<String> names = this.getAttributeNames();
        for (String key : names) {
            SharedObjectEvent event = new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_DELETE_DATA, key, null);
            this.ownerMessage.addEvent(event);
            this.syncEvents.add(event);
        }
        this.deleteStats.addAndGet(names.size());
        super.removeAttributes();
        this.modified.set(true);
        this.notifyModified();
    }

    protected boolean register(IEventListener listener) {
        log.debug("register - listener: {}", (Object)listener);
        boolean registered = this.listeners.add(listener);
        if (registered) {
            this.listenerStats.increment();
            this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_INITIAL_DATA, null, null);
            if (!this.isPersistent()) {
                this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_CLEAR_DATA, null, null);
            }
            if (!this.attributes.isEmpty()) {
                this.ownerMessage.addEvent(new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_UPDATE_DATA, null, this.getAttributes()));
            }
            this.notifyModified();
        }
        return registered;
    }

    protected void unregister(IEventListener listener) {
        log.debug("unregister - listener: {}", (Object)listener);
        if (this.listeners.remove(listener)) {
            this.listenerStats.decrement();
        }
    }

    protected void checkRelease() {
        if (!this.isPersistent() && this.listeners.isEmpty() && !this.isAcquired()) {
            log.info("Deleting shared object {} because all clients disconnected and it is no longer acquired", (Object)this.name);
            if (this.storage != null && !this.storage.remove(this)) {
                log.error("Could not remove shared object");
            }
            this.close();
        }
    }

    public Set<IEventListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    protected void beginUpdate() {
        log.debug("beginUpdate");
        this.beginUpdate(this.source);
    }

    protected void beginUpdate(IEventListener listener) {
        log.debug("beginUpdate - listener: {}", (Object)listener);
        this.source = listener;
        this.updateCounter.incrementAndGet();
    }

    protected void endUpdate() {
        log.debug("endUpdate");
        if (this.updateCounter.decrementAndGet() == 0) {
            this.notifyModified();
            this.source = null;
        }
    }

    @Override
    public void serialize(Output output) throws IOException {
        log.debug("serialize - name: {}", (Object)this.name);
        Serializer.serialize((Output)output, (Object)this.getName());
        Map<String, Object> map = this.getAttributes();
        if (log.isTraceEnabled()) {
            log.trace("Attributes: {}", map);
        }
        Serializer.serialize((Output)output, map);
    }

    @Override
    public void deserialize(Input input) throws IOException {
        log.debug("deserialize");
        this.name = (String)Deserializer.deserialize((Input)input, String.class);
        log.trace("Name: {}", (Object)this.name);
        this.persistent = true;
        Map map = (Map)Deserializer.deserialize((Input)input, Map.class);
        if (log.isTraceEnabled()) {
            log.trace("Attributes: {}", (Object)map);
        }
        super.setAttributes(map);
        this.ownerMessage.setName(this.name);
        this.ownerMessage.setPersistent(this.persistent);
    }

    @Override
    public void setStore(IPersistenceStore store) {
        this.storage = store;
    }

    @Override
    public IPersistenceStore getStore() {
        return this.storage;
    }

    protected boolean clear() {
        log.debug("clear");
        super.removeAttributes();
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_CLEAR_DATA, this.name, null);
        this.notifyModified();
        this.changeStats.incrementAndGet();
        return true;
    }

    protected void close() {
        log.debug("close");
        this.closed.compareAndSet(false, true);
        super.removeAttributes();
        this.listeners.clear();
        this.syncEvents.clear();
        this.ownerMessage.getEvents().clear();
    }

    public void acquire() {
        log.debug("acquire");
        this.acquireCount.incrementAndGet();
    }

    public boolean isAcquired() {
        return this.acquireCount.get() > 0;
    }

    public void release() {
        log.debug("release");
        if (this.acquireCount.get() == 0) {
            throw new RuntimeException("The shared object was not acquired before.");
        }
        if (this.acquireCount.decrementAndGet() == 0) {
            this.checkRelease();
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getTotalListeners() {
        return this.listenerStats.getTotal();
    }

    @Override
    @Deprecated
    public int getMaxListeners() {
        return this.listenerStats.getTotal();
    }

    @Override
    public int getActiveListeners() {
        return this.listenerStats.getCurrent();
    }

    @Override
    public int getTotalChanges() {
        return this.changeStats.intValue();
    }

    @Override
    public int getTotalDeletes() {
        return this.deleteStats.intValue();
    }

    @Override
    public int getTotalSends() {
        return this.sendStats.intValue();
    }

    public void setDirty(boolean dirty) {
        log.trace("setDirty: {}", (Object)dirty);
        this.modified.set(dirty);
    }
}

