/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.codec;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.red5.server.api.Red5;
import org.red5.server.net.IConnectionManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMPProtocolEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPMinaProtocolEncoder
extends ProtocolEncoderAdapter {
    protected static Logger log = LoggerFactory.getLogger(RTMPMinaProtocolEncoder.class);
    private RTMPProtocolEncoder encoder = new RTMPProtocolEncoder();
    private int targetChunkSize = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws ProtocolCodecException {
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        log.trace("Session id: {}", (Object)sessionId);
        IConnectionManager connManager = (IConnectionManager)((WeakReference)session.getAttribute((Object)"rtmp.connection.manager")).get();
        RTMPConnection conn = (RTMPConnection)connManager.getConnectionBySessionId(sessionId);
        if (conn != null) {
            RTMPConnection localConn = (RTMPConnection)Red5.getConnectionLocal();
            if (!conn.equals(localConn)) {
                if (localConn != null) {
                    log.debug("Connection local ({}) didn't match io session ({})", (Object)localConn.getSessionId(), (Object)sessionId);
                }
                Red5.setConnectionLocal(conn);
            }
            Boolean interrupted = false;
            Semaphore lock = conn.getEncoderLock();
            try {
                IoBuffer buf;
                lock.acquire();
                log.trace("Encoder lock acquired {}", (Object)conn.getSessionId());
                IoBuffer ioBuffer = buf = message instanceof IoBuffer ? (IoBuffer)message : this.encoder.encode(message);
                if (buf != null) {
                    int requestedWriteChunkSize = conn.getState().getWriteChunkSize();
                    log.trace("Requested chunk size: {} target chunk size: {}", (Object)requestedWriteChunkSize, (Object)this.targetChunkSize);
                    if (buf.remaining() <= this.targetChunkSize * 2) {
                        log.trace("Writing output data");
                        out.write((Object)buf);
                    } else {
                        int sentChunks = Chunker.chunkAndWrite(out, buf, requestedWriteChunkSize, this.targetChunkSize);
                        log.trace("Wrote {} chunks", (Object)sentChunks);
                    }
                } else {
                    log.trace("Response buffer was null after encoding");
                }
            }
            catch (InterruptedException ex) {
                log.error("InterruptedException during encode", (Throwable)ex);
                interrupted = true;
            }
            catch (Exception ex) {
                log.error("Exception during encode", (Throwable)ex);
            }
            finally {
                log.trace("Encoder lock releasing.. {}", (Object)conn.getSessionId());
                lock.release();
                if (interrupted.booleanValue() && log.isInfoEnabled()) {
                    log.info("Released lock after interruption. session {}, permits {}", (Object)conn.getSessionId(), (Object)lock.availablePermits());
                }
            }
            if (localConn != null) {
                Red5.setConnectionLocal(localConn);
            }
        } else {
            log.debug("Connection is no longer available for encoding, may have been closed already");
        }
    }

    public void setEncoder(RTMPProtocolEncoder encoder) {
        this.encoder = encoder;
    }

    public RTMPProtocolEncoder getEncoder() {
        return this.encoder;
    }

    public void setBaseTolerance(long baseTolerance) {
        this.encoder.setBaseTolerance(baseTolerance);
    }

    public void setDropLiveFuture(boolean dropLiveFuture) {
        this.encoder.setDropLiveFuture(dropLiveFuture);
    }

    public int getTargetChunkSize() {
        return this.targetChunkSize;
    }

    public void setTargetChunkSize(int targetChunkSize) {
        this.targetChunkSize = targetChunkSize;
    }

    private static final class Chunker {
        private Chunker() {
        }

        public static LinkedList<IoBuffer> chunk(IoBuffer message, int chunkSize, int desiredSize) {
            LinkedList<IoBuffer> chunks = new LinkedList<IoBuffer>();
            int targetSize = desiredSize > chunkSize ? desiredSize : chunkSize;
            int limit = message.limit();
            do {
                byte basicHeader;
                int length = 0;
                for (int pos = message.position(); length < targetSize && pos < limit; pos += (length += Chunker.getDataSize(basicHeader) + chunkSize)) {
                    basicHeader = message.get(pos);
                }
                int remaining = message.remaining();
                log.trace("Length: {} remaining: {} pos+len: {} limit: {}", new Object[]{length, remaining, message.position() + length, limit});
                if (length > remaining) {
                    length = remaining;
                }
                chunks.add(message.getSlice(length));
            } while (message.hasRemaining());
            return chunks;
        }

        public static int chunkAndWrite(ProtocolEncoderOutput out, IoBuffer message, int chunkSize, int desiredSize) {
            int sentChunks = 0;
            int targetSize = desiredSize > chunkSize ? desiredSize : chunkSize;
            int limit = message.limit();
            do {
                byte basicHeader;
                int length = 0;
                for (int pos = message.position(); length < targetSize && pos < limit; pos += (length += Chunker.getDataSize(basicHeader) + chunkSize)) {
                    basicHeader = message.get(pos);
                }
                int remaining = message.remaining();
                log.trace("Length: {} remaining: {} pos+len: {} limit: {}", new Object[]{length, remaining, message.position() + length, limit});
                if (length > remaining) {
                    length = remaining;
                }
                out.write((Object)message.getSlice(length));
                ++sentChunks;
            } while (message.hasRemaining());
            return sentChunks;
        }

        private static int getDataSize(byte basicHeader) {
            int streamId = basicHeader & 0x3F;
            int headerType = basicHeader >> 6 & 3;
            int size = 0;
            switch (headerType) {
                case 0: {
                    size = 12;
                    break;
                }
                case 1: {
                    size = 8;
                    break;
                }
                case 2: {
                    size = 4;
                    break;
                }
                default: {
                    size = 1;
                }
            }
            if (streamId == 0) {
                ++size;
            } else if (streamId == 1) {
                size += 2;
            }
            return size;
        }
    }
}

