/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.red5.server.net.rtmp.IReceivedMessageTaskQueueListener;
import org.red5.server.net.rtmp.ReceivedMessageTask;
import org.red5.server.net.rtmp.message.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivedMessageTaskQueue {
    private static final Logger log = LoggerFactory.getLogger(ReceivedMessageTaskQueue.class);
    private final int streamId;
    private final Queue<ReceivedMessageTask> tasks = new ConcurrentLinkedQueue<ReceivedMessageTask>();
    private final IReceivedMessageTaskQueueListener listener;

    public ReceivedMessageTaskQueue(int streamId, IReceivedMessageTaskQueueListener listener) {
        this.streamId = streamId;
        this.listener = listener;
    }

    public void addTask(ReceivedMessageTask task) {
        this.tasks.add(task);
        Packet packet = task.getPacket();
        if (packet.getExpirationTime() > 0L) {
            task.runDeadlockFuture(new DeadlockGuard(task));
        }
        if (this.listener != null) {
            this.listener.onTaskAdded(this);
        }
    }

    public void removeTask(ReceivedMessageTask task) {
        if (this.tasks.remove(task)) {
            task.cancelDeadlockFuture();
            if (this.listener != null) {
                this.listener.onTaskRemoved(this);
            }
        }
    }

    public ReceivedMessageTask getTaskToProcess() {
        ReceivedMessageTask task = this.tasks.peek();
        if (task != null && task.setProcessing()) {
            return task;
        }
        return null;
    }

    public void removeAllTasks() {
        for (ReceivedMessageTask task : this.tasks) {
            task.cancelDeadlockFuture();
        }
        this.tasks.clear();
    }

    public int getStreamId() {
        return this.streamId;
    }

    private class DeadlockGuard
    implements Runnable {
        private final ReceivedMessageTask task;

        private DeadlockGuard(ReceivedMessageTask task) {
            this.task = task;
            if (log.isTraceEnabled()) {
                log.trace("DeadlockGuard is created for {}", (Object)task);
            }
        }

        @Override
        public void run() {
            Packet packet = this.task.getPacket();
            if (log.isTraceEnabled()) {
                log.trace("DeadlockGuard is started for {}", (Object)this.task);
            }
            if (packet.isProcessed()) {
                log.debug("DeadlockGuard skipping task for processed packet {}", (Object)this.task);
            } else if (packet.isExpired()) {
                log.debug("DeadlockGuard skipping task for expired packet {}", (Object)this.task);
            } else {
                Thread taskThread = this.task.getTaskThread();
                if (taskThread == null) {
                    log.debug("Task has not start yet {}", (Object)this.task);
                } else if (!taskThread.isInterrupted() && taskThread.isAlive()) {
                    log.warn("Interrupting unfinished active task {}", (Object)this.task);
                    taskThread.interrupt();
                } else {
                    log.debug("Unfinished task {} already interrupted", (Object)this.task);
                }
            }
            ReceivedMessageTaskQueue.this.removeTask(this.task);
        }
    }
}

