/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.adapter;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.red5.server.adapter.AbstractScopeAdapter;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeAware;
import org.red5.server.plugin.PluginDescriptor;
import org.springframework.core.io.Resource;

public class StatefulScopeWrappingAdapter
extends AbstractScopeAdapter
implements IScopeAware,
IAttributeStore {
    protected IScope scope;
    protected List<PluginDescriptor> plugins;

    @Override
    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public IScope getScope() {
        return this.scope;
    }

    public List<PluginDescriptor> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<PluginDescriptor> plugins) {
        this.plugins = plugins;
    }

    @Override
    public Object getAttribute(String name) {
        return this.scope.getAttribute(name);
    }

    @Override
    public Object getAttribute(String name, Object defaultValue) {
        Object value = this.scope.getAttribute(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.scope.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.scope.getAttributes();
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.scope.hasAttribute(name);
    }

    @Override
    public boolean removeAttribute(String name) {
        return this.scope.removeAttribute(name);
    }

    @Override
    public void removeAttributes() {
        Set<String> names = this.scope.getAttributeNames();
        for (String name : names) {
            this.scope.removeAttribute(name);
        }
    }

    @Override
    public int size() {
        return this.scope != null ? this.scope.getAttributeNames().size() : 0;
    }

    @Override
    public boolean setAttribute(String name, Object value) {
        return this.scope.setAttribute(name, value);
    }

    @Override
    public boolean setAttributes(IAttributeStore attributes) {
        int successes = 0;
        for (Map.Entry<String, Object> entry : attributes.getAttributes().entrySet()) {
            if (!this.scope.setAttribute(entry.getKey(), entry.getValue())) continue;
            ++successes;
        }
        return successes == attributes.size();
    }

    @Override
    public boolean setAttributes(Map<String, Object> attributes) {
        int successes = 0;
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            if (!this.scope.setAttribute(entry.getKey(), entry.getValue())) continue;
            ++successes;
        }
        return successes == attributes.size();
    }

    public boolean createChildScope(String name) {
        if (!this.scope.hasChildScope(name)) {
            return this.scope.createChildScope(name);
        }
        return false;
    }

    public IScope getChildScope(String name) {
        return this.scope.getScope(name);
    }

    public Set<String> getChildScopeNames() {
        return this.scope.getScopeNames();
    }

    public Set<IClient> getClients() {
        return this.scope.getClients();
    }

    public Collection<Set<IConnection>> getConnections() {
        return this.scope.getConnections();
    }

    public Set<IConnection> lookupConnections(IClient client) {
        return this.scope.lookupConnections(client);
    }

    public IContext getContext() {
        return this.scope.getContext();
    }

    public int getDepth() {
        return this.scope.getDepth();
    }

    public String getName() {
        return this.scope.getName();
    }

    public IScope getParent() {
        return this.scope.getParent();
    }

    public String getPath() {
        return this.scope.getPath();
    }

    public boolean hasChildScope(String name) {
        return this.scope.hasChildScope(name);
    }

    public boolean hasParent() {
        return this.scope.hasParent();
    }

    public Resource[] getResources(String pattern) throws IOException {
        return this.scope.getResources(pattern);
    }

    public Resource getResource(String path) {
        return this.scope.getResource(path);
    }
}

