/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.sctp.packet.chunks;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public class StateCookie {
    private static final int HEADER_STATE_COOKIE_SIZE = 26;
    private static final short LIFESPAN = 60;
    private long creationTimestamp = System.currentTimeMillis() / 1000L;
    private short currentLifespan;
    private int verificationTag;
    private int advertisedReceiverWindowCredit;
    private int numberOfOutboundStreams;
    private int numberOfInboundStreams;
    private int initialTSN;
    private byte[] mac;

    public StateCookie(int verificationTag, int initialTSN, int advertisedReceiverWindowCredit, int numberOfOutboundStreams, int numberOfInboundStreams) {
        this.verificationTag = verificationTag;
        this.advertisedReceiverWindowCredit = advertisedReceiverWindowCredit;
        this.numberOfOutboundStreams = numberOfOutboundStreams;
        this.numberOfInboundStreams = numberOfInboundStreams;
        this.initialTSN = initialTSN;
        this.currentLifespan = (short)60;
    }

    public StateCookie(byte[] data, int offset, int length) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, 4);
        int macLength = byteBuffer.getInt();
        this.mac = new byte[macLength];
        System.arraycopy(data, offset + 4, this.mac, 0, macLength);
        byteBuffer = ByteBuffer.wrap(data, offset + 4 + macLength, 26);
        this.creationTimestamp = byteBuffer.getLong();
        this.currentLifespan = byteBuffer.getShort();
        this.verificationTag = byteBuffer.getInt();
        this.advertisedReceiverWindowCredit = byteBuffer.getInt();
        this.numberOfOutboundStreams = byteBuffer.getShort();
        this.numberOfInboundStreams = byteBuffer.getShort();
        this.initialTSN = byteBuffer.getInt();
    }

    public byte[] getBytes(Mac messageAuthenticationCode) throws InvalidKeyException, NoSuchAlgorithmException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(26);
        byteBuffer.putLong(this.creationTimestamp);
        byteBuffer.putShort(this.currentLifespan);
        byteBuffer.putInt(this.verificationTag);
        byteBuffer.putInt(this.advertisedReceiverWindowCredit);
        byteBuffer.putShort((short)this.numberOfOutboundStreams);
        byteBuffer.putShort((short)this.numberOfInboundStreams);
        byteBuffer.putInt(this.initialTSN);
        byteBuffer.clear();
        byte[] data = new byte[byteBuffer.capacity()];
        byteBuffer.get(data, 0, data.length);
        if (messageAuthenticationCode != null) {
            this.mac = messageAuthenticationCode.doFinal(data);
        }
        byte[] macLength = ByteBuffer.allocate(4).putInt(this.mac.length).array();
        byte[] resultData = new byte[this.mac.length + data.length + macLength.length];
        System.arraycopy(macLength, 0, resultData, 0, macLength.length);
        System.arraycopy(this.mac, 0, resultData, macLength.length, this.mac.length);
        System.arraycopy(data, 0, resultData, macLength.length + this.mac.length, data.length);
        return resultData;
    }

    public boolean isValid(Mac mac) {
        return true;
    }

    public int getVerificationTag() {
        return this.verificationTag;
    }

    public int getInitialTSN() {
        return this.initialTSN;
    }

    public byte[] getMac() {
        return this.mac;
    }

    public short getCurrentLifespan() {
        return this.currentLifespan;
    }

    public int getSize() {
        return 26 + this.mac.length + 4;
    }
}

