/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import java.util.HashMap;
import java.util.Map;

public enum StreamAction {
    CONNECT("connect"),
    DISCONNECT("disconnect"),
    CREATE_STREAM("createStream"),
    DELETE_STREAM("deleteStream"),
    CLOSE_STREAM("closeStream"),
    INIT_STREAM("initStream"),
    RELEASE_STREAM("releaseStream"),
    PUBLISH("publish"),
    PAUSE("pause"),
    PAUSE_RAW("pauseRaw"),
    SEEK("seek"),
    PLAY("play"),
    PLAY2("play2"),
    STOP("stop"),
    RECEIVE_VIDEO("receiveVideo"),
    RECEIVE_AUDIO("receiveAudio"),
    GET_STREAM_LENGTH("getStreamLength"),
    CUSTOM("");

    private static final Map<String, StreamAction> map;
    private final String actionString;

    private StreamAction(String actionString) {
        this.actionString = actionString;
    }

    public String getActionString() {
        return this.actionString;
    }

    public static StreamAction getEnum(String actionString) {
        StreamAction match;
        if (map.isEmpty()) {
            for (StreamAction action : StreamAction.values()) {
                map.put(action.getActionString(), action);
            }
        }
        if ((match = map.get(actionString)) != null) {
            return match;
        }
        return CUSTOM;
    }

    public boolean equals(StreamAction action) {
        return action.getActionString().equals(this.actionString);
    }

    public boolean equals(String actionString) {
        return this.getActionString().equals(actionString);
    }

    public String toString() {
        return this.actionString;
    }

    static {
        map = new HashMap<String, StreamAction>(StreamAction.values().length);
    }
}

