/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.beanutils.BeanMap;
import org.red5.annotations.DontSerialize;
import org.red5.annotations.RemoteClass;
import org.red5.io.amf3.ByteArray;
import org.red5.io.amf3.IExternalizable;
import org.red5.io.object.Output;
import org.red5.io.object.RecordSet;
import org.red5.io.utils.ObjectMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Serializer {
    protected static Logger log = LoggerFactory.getLogger(Serializer.class);

    private Serializer() {
    }

    public static void serialize(Output out, Object any) {
        Serializer.serialize(out, null, null, null, any);
    }

    public static void serialize(Output out, Field field, Method getter, Object object, Object value) {
        log.trace("serialize");
        if (value instanceof IExternalizable) {
            out.writeObject(value);
        } else if (value instanceof ByteArray) {
            out.writeByteArray((ByteArray)value);
        } else if (value instanceof Vector) {
            log.trace("Serialize Vector");
            Vector vector = (Vector)value;
            int ints = 0;
            int longs = 0;
            int dubs = 0;
            int nans = 0;
            for (Object o : vector) {
                if (o instanceof Integer) {
                    ++ints;
                    continue;
                }
                if (o instanceof Long) {
                    ++longs;
                    continue;
                }
                if (o instanceof Number || o instanceof Double) {
                    ++dubs;
                    continue;
                }
                ++nans;
            }
            if (nans > 0) {
                ((org.red5.io.amf3.Output)out).enforceAMF3();
                out.writeVectorObject((Vector)value);
            } else if (dubs == 0 && longs == 0) {
                out.writeVectorInt((Vector)value);
            } else if (dubs == 0 && ints == 0) {
                out.writeVectorUInt((Vector)value);
            } else {
                ((org.red5.io.amf3.Output)out).enforceAMF3();
                out.writeVectorNumber((Vector)value);
            }
        } else if (Serializer.writeBasic(out, value)) {
            log.trace("Wrote as basic");
        } else if (!Serializer.writeComplex(out, value)) {
            log.trace("Unable to serialize: {}", value);
        }
    }

    protected static boolean writeBasic(Output out, Object basic) {
        if (basic == null) {
            out.writeNull();
        } else if (basic instanceof Boolean) {
            out.writeBoolean((Boolean)basic);
        } else if (basic instanceof Number) {
            out.writeNumber((Number)basic);
        } else if (basic instanceof String) {
            out.writeString((String)basic);
        } else if (basic instanceof Enum) {
            out.writeString(((Enum)basic).name());
        } else if (basic instanceof Date) {
            out.writeDate((Date)basic);
        } else {
            return false;
        }
        return true;
    }

    public static boolean writeComplex(Output out, Object complex) {
        log.trace("writeComplex");
        if (Serializer.writeListType(out, complex)) {
            return true;
        }
        if (Serializer.writeArrayType(out, complex)) {
            return true;
        }
        if (Serializer.writeXMLType(out, complex)) {
            return true;
        }
        if (Serializer.writeCustomType(out, complex)) {
            return true;
        }
        return Serializer.writeObjectType(out, complex);
    }

    protected static boolean writeListType(Output out, Object listType) {
        log.trace("writeListType");
        if (!(listType instanceof List)) {
            return false;
        }
        Serializer.writeList(out, (List)listType);
        return true;
    }

    protected static void writeList(Output out, List<?> list) {
        if (!list.isEmpty()) {
            int size = list.size();
            if (size < 100) {
                out.writeArray(list);
                return;
            }
            int nullCount = 0;
            for (int i = 0; i < size; ++i) {
                if (list.get(i) != null) continue;
                ++nullCount;
            }
            if ((double)nullCount > (double)size * 0.8) {
                out.writeMap(list);
            } else {
                out.writeArray(list);
            }
        } else {
            out.writeArray(new Object[0]);
        }
    }

    protected static boolean writeArrayType(Output out, Object arrType) {
        log.trace("writeArrayType");
        if (arrType instanceof Collection) {
            out.writeArray((Collection)arrType);
        } else if (arrType instanceof Iterator) {
            Serializer.writeIterator(out, (Iterator)arrType);
        } else if (arrType.getClass().isArray() && arrType.getClass().getComponentType().isPrimitive()) {
            out.writeArray(arrType);
        } else if (arrType instanceof Object[]) {
            out.writeArray((Object[])arrType);
        } else {
            return false;
        }
        return true;
    }

    protected static void writeIterator(Output out, Iterator<Object> it) {
        log.trace("writeIterator");
        LinkedList<Object> list = new LinkedList<Object>();
        while (it.hasNext()) {
            list.addLast(it.next());
        }
        out.writeArray(list);
    }

    protected static boolean writeXMLType(Output out, Object xml) {
        log.trace("writeXMLType");
        if (!(xml instanceof Document)) {
            return false;
        }
        Serializer.writeDocument(out, (Document)xml);
        return true;
    }

    protected static void writeDocument(Output out, Document doc) {
        out.writeXML(doc);
    }

    protected static boolean writeObjectType(Output out, Object obj) {
        if (obj instanceof ObjectMap || obj instanceof BeanMap) {
            out.writeObject((Map)obj);
        } else if (obj instanceof Map) {
            out.writeMap((Map)obj);
        } else if (obj instanceof RecordSet) {
            out.writeRecordSet((RecordSet)obj);
        } else {
            out.writeObject(obj);
        }
        return true;
    }

    protected static boolean writeCustomType(Output out, Object obj) {
        if (out.isCustom(obj)) {
            out.writeCustom(obj);
            return true;
        }
        return false;
    }

    public static boolean serializeField(String keyName, Field field, Method getter) {
        log.trace("serializeField - keyName: {} field: {} method: {}", new Object[]{keyName, field, getter});
        if ("class".equals(keyName)) {
            return false;
        }
        if (field != null) {
            if (Modifier.isTransient(field.getModifiers())) {
                log.trace("Skipping {} because its transient", (Object)keyName);
                return false;
            }
            if (field.isAnnotationPresent(DontSerialize.class)) {
                log.trace("Skipping {} because its marked with @DontSerialize", (Object)keyName);
                return false;
            }
        }
        if (getter != null && getter.isAnnotationPresent(DontSerialize.class)) {
            log.trace("Skipping {} because its marked with @DontSerialize", (Object)keyName);
            return false;
        }
        log.trace("Serialize field: {}", (Object)field);
        return true;
    }

    public static String getClassName(Class<?> objectClass) {
        RemoteClass annotation = objectClass.getAnnotation(RemoteClass.class);
        if (annotation != null) {
            return annotation.alias();
        }
        String className = objectClass.getName();
        if (className.startsWith("org.red5.compatibility.")) {
            if ("flex.messaging.messages.AsyncMessageExt".equals(className = className.substring(23))) {
                className = "DSA";
            } else if ("flex.messaging.messages.CommandMessageExt".equals(className)) {
                className = "DSC";
            } else if ("flex.messaging.messages.AcknowledgeMessageExt".equals(className)) {
                className = "DSK";
            }
        }
        log.debug("Classname: {}", (Object)className);
        return className;
    }
}

