/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.mp4.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.ITagReader;
import org.red5.io.ITagWriter;
import org.red5.io.flv.meta.IMetaData;
import org.red5.io.flv.meta.IMetaService;
import org.red5.io.flv.meta.MetaService;
import org.red5.io.mp4.IMP4;
import org.red5.io.mp4.impl.MP4Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MP4
implements IMP4 {
    protected static Logger log = LoggerFactory.getLogger(MP4.class);
    private File file;
    private IMetaService metaService;
    private IMetaData<?, ?> metaData;

    public MP4() {
    }

    public MP4(File file) {
        this.file = file;
    }

    @Override
    public boolean hasMetaData() {
        return this.metaData != null;
    }

    @Override
    public IMetaData<?, ?> getMetaData() throws FileNotFoundException {
        this.metaService.setFile(this.file);
        return null;
    }

    @Override
    public boolean hasKeyFrameData() {
        return false;
    }

    @Override
    public void setKeyFrameData(Map<?, ?> keyframedata) {
    }

    @Override
    public Map<?, ?> getKeyFrameData() {
        return null;
    }

    @Override
    public void refreshHeaders() throws IOException {
    }

    @Override
    public void flushHeaders() throws IOException {
    }

    @Override
    public ITagReader getReader() throws IOException {
        MP4Reader reader = null;
        IoBuffer fileData = null;
        String fileName = this.file.getName();
        if (this.file.exists()) {
            log.debug("File name: {} size: {}", (Object)fileName, (Object)this.file.length());
            reader = new MP4Reader(this.file);
            fileData = reader.getFileData();
            log.trace("File data size: {}", (Object)fileData);
        } else {
            log.info("Creating new file: {}", (Object)this.file);
            this.file.createNewFile();
        }
        return reader;
    }

    @Override
    public ITagReader readerFromNearestKeyFrame(int seekPoint) {
        return null;
    }

    @Override
    public ITagWriter getWriter() throws IOException {
        return null;
    }

    @Override
    public ITagWriter writerFromNearestKeyFrame(int seekPoint) {
        return null;
    }

    @Override
    public void setMetaData(IMetaData<?, ?> meta) throws IOException {
        if (this.metaService == null) {
            this.metaService = new MetaService(this.file);
        }
        if (this.metaService.getFile() == null) {
            this.metaService.setFile(this.file);
        }
        this.metaService.write(meta);
        this.metaData = meta;
    }

    @Override
    public void setMetaService(IMetaService service) {
        this.metaService = service;
    }

    @Override
    public ITagWriter getAppendWriter() throws IOException {
        return null;
    }
}

