/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv;

import java.nio.ByteBuffer;
import org.apache.mina.core.buffer.IoBuffer;

public class FLVHeader {
    static final int FLV_HEADER_FLAG_HAS_AUDIO = 4;
    static final int FLV_HEADER_FLAG_HAS_VIDEO = 1;
    public static final byte[] signature = new byte[]{70, 76, 86};
    public static final byte version = 1;
    public static byte flagReserved01 = 0;
    public boolean flagAudio;
    public static byte flagReserved02 = 0;
    public boolean flagVideo;
    public int dataOffset = 0;

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setDataOffset(int data_offset) {
        this.dataOffset = data_offset;
    }

    public byte[] getSignature() {
        return signature;
    }

    public String toString() {
        String ret = "";
        ret = ret + "VERSION: \t\t" + this.getVersion() + "\n";
        ret = ret + "TYPE FLAGS VIDEO: \t" + this.getFlagVideo() + "\n";
        ret = ret + "TYPE FLAGS AUDIO: \t" + this.getFlagAudio() + "\n";
        ret = ret + "DATA OFFSET: \t\t" + this.getDataOffset() + "\n";
        return ret;
    }

    public boolean getFlagAudio() {
        return this.flagAudio;
    }

    public void setFlagAudio(boolean flagAudio) {
        this.flagAudio = flagAudio;
    }

    public void setTypeFlags(byte typeFlags) {
        this.flagVideo = (byte)(typeFlags << 7 >>> 7 & 1) > 0;
        this.flagAudio = (byte)(typeFlags << 5 >>> 7 & 1) > 0;
    }

    public byte getFlagReserved01() {
        return flagReserved01;
    }

    public void setFlagReserved01(byte flagReserved01) {
        FLVHeader.flagReserved01 = flagReserved01;
    }

    public byte getFlagReserved02() {
        return flagReserved02;
    }

    public void setFlagReserved02(byte flagReserved02) {
        FLVHeader.flagReserved02 = flagReserved02;
    }

    public boolean getFlagVideo() {
        return this.flagVideo;
    }

    public void setFlagVideo(boolean type_flags_video) {
        this.flagVideo = type_flags_video;
    }

    public byte getVersion() {
        return 1;
    }

    public void write(IoBuffer buffer) {
        buffer.put(signature);
        buffer.put((byte)1);
        buffer.put((byte)(4 * (this.flagAudio ? 1 : 0) + 1 * (this.flagVideo ? 1 : 0)));
        buffer.putInt(9);
        buffer.putInt(0);
        buffer.flip();
    }

    public void write(ByteBuffer buffer) {
        buffer.put(signature);
        buffer.put((byte)1);
        buffer.put((byte)(4 * (this.flagAudio ? 1 : 0) + 1 * (this.flagVideo ? 1 : 0)));
        buffer.putInt(9);
        buffer.putInt(0);
        buffer.flip();
    }
}

